
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


/* stop.c -- Implement the STOP statement.  This has three forms, an
 * integer error code, an error string or a blank stop (which has a
 * numeric code of -1. */

#include <string.h>
#include "runtime.h"

#define stop prefix(stop)

#define pause prefix(pause)
#define pause_integer prefix(pause_integer)
#define pause_string prefix(pause_string)

#define st_read prefix(st_read)
#define transfer_character prefix(transfer_character)
#define st_read_done prefix(st_read_done)

void st_read(void);
void st_read_done(void);



/* stop()-- Process the STOP statement. */

void stop(G95_DINT code, char *string, G95_DINT len) {

    if (code != -1) {
	st_printf("STOP %d\n", code);
	if (!options.stop_code)
	    code = 0;

    } else if (string != NULL) {
	st_printf("STOP ");

	while(len-- > 0)
	    st_printf("%c", *string++);

	st_printf("\n");
	code = 0;

    } else
	code = 0;

    g95_runtime_stop();
    sys_exit(0, code);
}



/* do_pause()-- Common code for a PAUSE statement.  A blank list read
 * has the effect of discarding a line of input. */

static void do_pause(void) {

    st_printf(" statement executed.  Hit Return to continue\n");
    get_ioparm();

    ioparm->unit = &options.stdin_unit;
    ioparm->unit_kind = sizeof(options.stdin_unit);
    ioparm->list_format = 1;

    st_read();
    st_read_done();
}



/* pause()-- Blank pause statement */

void pause(void) {

    st_printf("PAUSE");
    do_pause();
}



/* pause_integer()-- Pause with integer code */

void pause_integer(G95_DINT code) {

    st_printf("PAUSE %d", code);
    do_pause();
}



/* pause_string()-- Pause with string code */

void pause_string(char *code, G95_DINT length) {

    st_printf("PAUSE ");

    while(length-- > 0)
	st_printf("%c", *code++);

    do_pause();
}
