#!/usr/bin/env python

# Generate powers of ten used when reading floating point numbers.

import sys, string


# round()-- Round a list of bits to the number of words.  If the
# trailing bits are 01111111 ... then we complain about not having
# enough bits to correctly round.

def round(value):
    n = 32 * words

    r = value[:n]
    trailing = value[n:]

    if trailing[0] == 0 and reduce(lambda x, y: x & y, trailing[1:]):
        raise RuntimeError, 'Not enough bits!'

    if trailing[0] == 1:
        while 1:
            n = n - 1
            if n < 0:
                raise RuntimeError, 'Rounding rolled over!'

            if r[n] == 0:
                r[n] = 1
                break

            r[n] = 0
            pass
        pass

    return r


# hexify-- Generate a string that is a list of eight-bit hex words

def hexify(value):

    v = value[:]
    s = ''

    while len(v) > 0:

        if len(s) > 0:
            s = s + ','
            pass

        s = s + '0x'

        n = 0
        while n < 8:
            nibble = 2*(2*(2*v[0] + v[1]) + v[2]) + v[3]
            s = s + ('%X' % nibble)
            n = n + 1
            v = v[4:]
            pass

        pass

    return s




def positive(e):

    n = 10L ** e
    p = max(0, int(e * 3.32) - 2)

    while 2L**p <= n:
        p = p + 1
        pass

    divisor = 2L ** (p-1)
    dividend = n
    quotient = []

    bits = 32*words + 15
    i = 0

    while i < bits:
        if dividend >= divisor:
            quotient.append(1)
            dividend = dividend - divisor
        else:
            quotient.append(0)
            pass

        dividend = 2*dividend
        i = i + 1
        pass

    quotient = round(quotient)

    print "{ %6d, {%s}}, /* %s */" % (p - words*32, hexify(quotient), e)
    return




def negative(e):

    divisor = 10L ** e

    p = max(0, int(e*3.32) - 2)

    while 2L**p <= divisor:
        p = p + 1
        pass

    dividend = 2L ** (p-1)
    quotient = []

    bits = 32*words + 15
    i = 0

    while i < bits:
        if dividend >= divisor:
            quotient.append(1)
            dividend = dividend - divisor
        else:
            quotient.append(0)
            pass

        dividend = 2*dividend
        i = i + 1
        pass

    quotient = round(quotient)

    print "{ %6d, {%s}}, /* -%s */" % (2-p - words*32, hexify(quotient), e)
    return



def make_table(name, sub):

    print "static p10 %s[] = {" % name

    e = 0

    while e <= j:
        sub(e)

        e = e + 1
        pass

    e = e + h - 1

    print "};\n\nstatic p10 %s_big[] = {"  % name

    while e <= max_exponent:
        sub(e)
        e = e + h
        pass

    print "};\n\n"
    pass


words = 4
max_exponent = 4950

j = 50
h = 50

print "#define MAX_EXPONENT", max_exponent
print "#define H_PARM", h
print "#define J_PARM", j
print
print

make_table('negative', negative)
make_table('positive', positive)

