
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the VERIFY intrinsic */

#include "runtime.h"


/* verify_1()-- VERIFY intrinsic */

#define verify_1 prefix(verify_1)

G95_DINT verify_1(unsigned char *string, unsigned char *set, G95_DINT *back,
		  G95_DINT string_len, G95_DINT set_len) {
char set_array[256];
G95_DINT i, length;

    if (string_len == 0)
	return 0;

    if (set_len == 0)
	return (back != NULL && *back)
	    ? string_len
	    : 1;

    for(i=0; i<256; i++)
	set_array[i] = 1;

    for(i=0; i<set_len; i++)
	set_array[set[i]] = 0;

    length = string_len - 1;

    if (back != NULL && *back) {
	for(i=length; i>=0; i--) 
	    if (set_array[string[i]])
		return i+1;

    } else
	for(i=0; i<=length; i++) 
	    if (set_array[string[i]])
		return i+1;

    return 0;
}
