
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <string.h>
#include "runtime.h"


/* get_command()-- F2003 command line access function */

#define get_command prefix(get_command)

void get_command(char *command, G95_DINT *length, G95_DINT *status,
		 G95_DINT command_len) {
G95_DINT total, m, n, s;
char *p;
int i;

    s = 0;
    total = 0;
    p = command;
    n = command_len;

    for(i=0; i<f__xargc; i++) {
	m = strlen(f__xargv[i]);
	total += m;

	if (m > n) {
	    m = n;
	    s = -1;
	}

	memcpy(p, f__xargv[i], m);
	p += m;
	n -= m;

	if (i+1 < f__xargc) {
	    total++;

	    if (n > 0) {
		*p++ = ' ';
		n--;
	    } else
		s = -1;
	}
    }

    if (length != NULL)
	*length = total;

    if (status != NULL)
	*status = s;

    n = (command - p) + command_len;
    if (n > 0)
	memset(p, ' ', n);
}


/* get_command_argument*/

#define get_command_argument prefix(get_command_argument)

void get_command_argument(G95_DINT *number, char *value, G95_DINT *length,
			  G95_DINT *status, G95_DINT value_len) {
G95_DINT m;

    if (*number < 0 || *number >= f__xargc) {
	if (status != NULL)
	    *status = 1;

	if (value != NULL)
	    memset(value, ' ', value_len);

	if (length != NULL)
	    *length = 0;

    } else {
	m = strlen(f__xargv[*number]);

	if (value != NULL)
	    copy_string(value, value_len, f__xargv[*number], m);

	if (length != NULL)
	    *length = m;

	if (status != NULL)
	    *status = (m <= value_len) ? 0 : -1;
    }
}


#define command_argument_count prefix(command_argument_count)

G95_DINT command_argument_count(void) {

    return f__xargc - 1;
}

