/*
 * tvscreen.h
 *
 * API for determining basic capabilities of the video card on an
 *   X server screen.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVSCREEN_H
#define __TVSCREEN_H

#include <stdio.h>
#include <assert.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#ifdef HAVE_XFREE86
#include <X11/extensions/xf86vmode.h>
#endif
#include "tvtypes.h"
#include "tvcapture.h"

typedef struct {

    Display              *display;
    int                   screen;
                        
    XVisualInfo          *visual;
    TV_TRANSFER_MODE     *visual_modes;
    TV_INT32              num_visuals;
    TV_INT32              active_visual;
                        
    XVisualInfo          *fb_visual;
    TV_UINT32             base_addr;
    TV_UINT32             pitch;     /* pixels */
    TV_UINT32             bank_size; /* bytes */
    TV_UINT32             ram_size;  /* bytes */

    TV_BOOL               vmode_ext_supported;
    TV_BOOL               dga_ext_supported;
#ifdef HAVE_XFREE86
    int                   vmode_majv;
    int                   vmode_minv;
    XF86VidModeModeInfo **vm_list;
    int                   vm_list_len;
    int                   vm_startup;
#endif

} TV_XSCREEN;


#ifdef __cplusplus
extern "C" {
#endif

void TVXSCREENInit( TV_XSCREEN *s,
                    Display    *display,
                    int         screen );

#define TVSCREEN_VIDEOWIN_MASK (ButtonPressMask      | KeyPressMask         | \
                                PointerMotionMask    | StructureNotifyMask  | \
                                VisibilityChangeMask | ExposureMask )

#define TVSCREEN_SHELLWIN_MASK (StructureNotifyMask | EnterWindowMask)

void TVSCREENGetCurVidModeGeometry(
         TV_XSCREEN *s,
         Dimension  *width,
         Dimension  *height );

void TVSCREENInit(
         TV_XSCREEN *s,
         Display    *display,
         int         screen );

void TVSCREENUpdateWinGeometry();

void TVSCREENVideoWinEventHdlr(
         Widget     wgt,
         XtPointer  cl_data,
         XEvent    *ev,
         Boolean   *continue_dispatch );

void TVSCREENShellWinEventHdlr(
         Widget     wgt,
         XtPointer  cl_data,
         XEvent    *ev,
         Boolean   *continue_dispatch );

void TVSCREENSetZoomState(
         TV_BOOL zoom_on,
         TV_BOOL full_screen );

void TVSCREENSetFreezeState(
         TV_BOOL freeze_on );

void TVSCREENToggleFreezeState( void );

void TVSCREENSetAspectLock( 
         TV_BOOL aspect_lock );

void TVSCREENGetAspectLock( 
         TV_BOOL *aspect_lock );

void TVSCREENSetScreenUpdateEnabled( 
         TV_BOOL enabled );

void TVSCREENSetVideoWinGeom(
         TV_GEOM videowin_geom );

void TVSCREENGetVideoWinGeom(
         TV_GEOM *videowin_geom );

void TVSCREENNewFrameHdlr( TV_IMAGE *img );

void TVSCREENUpdateShellRsrcs( Widget shell_wgt, Widget video_wgt );

void    TVSCREENStartVideo           ( void );
void    TVSCREENStopVideo            ( TV_BOOL suppress_redraw );
TV_BOOL TVSCREENVideoStarted         ( void );
TV_BOOL TVSCREENVideoReqCaptureContin( void );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif




