/*
 * audsav_dlg.h
 *
 * API for the audio save control dialog
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __AUDSAV_DLG_H
#define __AUDSAV_DLG_H

typedef struct {
    TV_AUDIO_FILE_FMT    fmt;
    char                *file_ext;  /*  Also doubles as wgt_name  */
    char                *sox_opt;   /*  FIXME:  Delete  */
    Widget               wgt;
} TV_FFMT_ITEM_DEF;

typedef struct {
    TV_AUDIO_SAMPLE_FMT  fmt;
    char                *wgt_name;
    char                *sox_opt;   /*  FIXME:  Delete  */
    Widget               wgt;
} TV_SFMT_ITEM_DEF;

typedef struct {
    TV_BOOL              stereo;
    char                *wgt_name;
    Widget               wgt;
} TV_CHAN_ITEM_DEF;

typedef struct {
    TV_UINT32            rate;
    char                *wgt_name;
    Widget               wgt;
} TV_RATE_ITEM_DEF;

#ifdef __cplusplus
extern "C" {
#endif

void TVAUDSAVDIALOGPopUp();
void TVAUDSAVDIALOGResync();

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
