/*
 * actions.h
 *
 * Xt action routines for FXTV.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __ACTIONS_H
#define __ACTIONS_H

/*      ******************** Include Files                ************** */
/*      ******************** Local defines                ************** */
/*      ******************** Private variables            ************** */
/*      ******************** Forward declarations         ************** */
/*      ******************** Function Definitions         ************** */

#define TVACTION_VIDEOWIN_MASK (KeyPressMask | LeaveWindowMask)

void TVACTIONKeyEventHdlr(
         const char key_str[],
         TV_BOOL   *handled );

void TVACTIONVideoWinEventHdlr(
         Widget     wgt,
         XtPointer  cl_data,
         XEvent    *ev,
         Boolean   *continue_dispatch );

void TVActionAddAppActions( void );

void TVActionSetStation( char chan_id[] );
void TVActionSetStationRel( TV_INT8 chan_delta );
void TVActionSetVolume( TV_INT32 vol );
void TVActionSetVolumeRel( TV_INT32 vol_delta );
void TVActionSetCaptureInput( TV_INPUT_DEVICE dev );
void TVActionSetCaptureInputRel( TV_INT32 dev_delta );
void TVActionSaveImage( void );
void TVActionToggleFreeze( void );
void TVActionQuit( void );

#endif
