/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ftfcp.h,v 1.14 2005/06/24 11:59:27 pullmoll Exp $
 *****************************************************************************/
#ifndef	_ftfcp_h
#define	_ftfcp_h

#include "ftsock.h"

typedef struct segment_header_s {
	char fec_algorithm[32];
	u_int64_t file_length;
	u_int64_t offset;
	size_t block_count;
	size_t block_size;
	size_t check_block_count;
	size_t check_block_size;
	size_t segments;
	size_t segment_num;
	size_t blocks_required;
}	segment_header_t;

/* number of segment headers (each header is for 128MB) */
#define	MAX_SEGMENTS	128

typedef struct fcp_s {
	conn_t	conn;

	char *uri;
	char *public_key;
	char *private_key;
	char *chk;

	size_t max_filesize;
	size_t max_htl;
	size_t metasize, metaoffs;
	char *meta;

	size_t datasize, dataoffs;
	char *data;

	char *svk_extension;
	char *protocol;
	char *node;
	char *reason;
	size_t timeout;
	int	length;

	int id;
	int min_id;
	int max_id;
	time_t time;
	char *sha1;
	char *channel;
	char *sender;
	char *payload;

	int seen_success:1;
	int seen_failed:1;
	int seen_pending:1;
	int seen_key_collision:1;
	int seen_size_error:1;
	int	seen_uri_error:1;
	int	seen_restarted:1;
	int	seen_node_hello:1;
	int	seen_node_get:1;
	int	seen_node_put:1;
	int	seen_data_found:1;
	int	seen_data_not_found:1;
	int	seen_route_not_found:1;
	int	seen_data_chunk:1;
	int	seen_data:1;
	int	seen_data_complete:1;
	int	seen_segment_header:1;
	int	seen_end_message:1;

	segment_header_t sh0;
	segment_header_t sh[MAX_SEGMENTS];

}	fcp_t;

#ifdef	__cplusplus
extern "C" {
#endif
int fcp_new(fcp_t **pf, const char *hostname, int port);
int fcp_free(fcp_t **pf);
int fcp_hello(fcp_t *f);
int fcp_key(fcp_t *f);
int fcp_get(fcp_t *f, const char *uri, int slimit, int htl);
int fcp_put(fcp_t *f, const char *uri, int htl);
int fcp_chk(fcp_t *f);
int fcp_inv(fcp_t *f, const char *private_ssk, char *public_ssk);
int fcp_del(fcp_t *f, const char *uri);
int fcp_segment_file(fcp_t **pf, const char *hostname, int port,
	const char *algo_name, FILE *fp, u_int64_t file_length);
int fcp_broadcast(fcp_t *f, int htl,
	const char *channel, const char *sender, const char *payload);
int fcp_receive(fcp_t *f, int id);
#ifdef	__cplusplus
}		/* extern "C" */
#endif

#endif	/* _ftfcp_h */
