/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ft.h,v 1.29 2005/07/19 13:52:41 pullmoll Exp $
 *****************************************************************************/
#ifndef	_ft_h
#define	_ft_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <dirent.h>

#ifdef	__CYGWIN__
#define	OPEN_RB	"rb"
#define	OPEN_WB	"wb"
#else
#define	OPEN_RB	"r"
#define	OPEN_WB	"w"
#endif

typedef struct fileinfo_s {
	ssize_t size;
	int	htl;
	int	retry;
	char *name;
	char *chk;
	char *mimetype;
	FILE *fp;
}	fileinfo_t;

/* metadata mode types */
enum {
	MODE_NONE = 0,
	MODE_REDIR,
	MODE_MAPSPACE,
	MODE_SPLITFILE,
	MODE_DATEBASEDREDIR
};

#ifndef	MAXPATHLEN
#define	MAXPATHLEN	256
#endif

#ifndef	MAX_HTL
#define	MAX_HTL		25
#endif

#ifndef	SUCCESS
#define	SUCCESS			"SUCCESS"
#endif

#ifndef	KEYCOLLISION
#define	KEYCOLLISION	"COLLISION"
#endif

#ifndef	ROUTENOTFOUND
#define	ROUTENOTFOUND	"RNF"
#endif

#ifndef	DATANOTFOUND
#define	DATANOTFOUND	"DNF"
#endif

#ifndef	URIERROR
#define	URIERROR		"BADURI"
#endif

#ifndef	SIZEERROR
#define	SIZEERROR		"BADSIZE"
#endif

#ifndef	GENERALERROR
#define	GENERALERROR	"ERROR"
#endif

#ifndef	UNKNOWNERROR
#define	UNKNOWNERROR	"UNKNOWN"
#endif

#if	defined(__CYGWIN__) || defined(__INTERIX)
time_t timegm(struct tm *tm);
#endif

#ifdef	__INTERIX
#define	socklen_t int
#define	strtoull _strtouq

/* hidden version of strtoull() in libc */
u_quad_t _strtouq(const char *, char **, int);
#endif

#ifdef	__cplusplus
extern "C" {
#endif
extern char *homepath;
extern char *confpath;
extern char *temppath;
extern char *progname;
extern char *progpath;
extern char *program;
extern int verbose;
extern int retries;
extern char fcphost[256];
extern int fcpport;
extern int limit32k;
extern int htl;
extern size_t chunksize;
extern int revision;
extern char default_file[256];
extern char mimeignore[4096];
extern int in_threads;
extern int sf_threads;
extern int date_offs;
extern int date_incr;
extern int date_future;
extern int meta_only;
extern int meta_none;
extern int slimit;
extern int delete;

#ifdef	__cplusplus
}
#endif

#endif	/* _ft_h */
