#[[Versioning as per the code authors' specifications: 
   https://github.com/JetBrains/intellij-community/blob/master/native/fsNotifier/linux/make.sh]]
if(NOT VERSION)
  string(TIMESTAMP VERSION "%Y%m%d.%H%M" UTC)
endif()
set(VERSION ${VERSION} CACHE STRING "fsnotifier version" FORCE)
set(CMAKE_PROJECT_VERSION ${VERSION} CACHE STRING "fsnotifier version" FORCE)
add_compile_definitions(VERSION="${VERSION}")

list(APPEND HEADERS fsnotifier.h)
list(TRANSFORM HEADERS PREPEND ${CMAKE_SOURCE_DIR}/)
list(APPEND SOURCES inotify.c util.c)
list(TRANSFORM SOURCES PREPEND ${CMAKE_SOURCE_DIR}/)
list(APPEND LIBS fsnotifier_sharedlib fsnotifier_staticlib)
list(APPEND TYPES SHARED STATIC)
list(APPEND EXES fsnotifier fsnotifier-static)

add_library(fsnotifier_sharedlib SHARED ${HEADERS} ${SOURCES})
add_library(fsnotifier_staticlib STATIC ${HEADERS} ${SOURCES})
foreach(_lib _type IN ZIP_LISTS LIBS TYPES)
  target_link_libraries(${_lib} PUBLIC
      ${INOTIFY_LIBRARY_DIRS}/${CMAKE_${_type}_LIBRARY_PREFIX}${INOTIFY_LIBRARIES}${CMAKE_${_type}_LIBRARY_SUFFIX}
      Threads::Threads)
  target_include_directories(${_lib} PUBLIC ${INOTIFY_INCLUDE_DIRS})
  set_target_properties(${_lib} PROPERTIES OUTPUT_NAME fsnotifier)
endforeach()
target_link_libraries(fsnotifier_staticlib PUBLIC -static)
set_target_properties(fsnotifier_sharedlib PROPERTIES SOVERSION ${CMAKE_PROJECT_VERSION})

#[[Executable 'fsnotifier' is dynamically linked against libc, libthr, libinotify and libfsnotifier.
   Executable 'fsnotifier-static' is statically linked against libc and libthr, libinotify and libfsnotifier.]]
foreach(_lib _exe _type IN ZIP_LISTS LIBS EXES TYPES)
  add_executable(${_exe} main.c)
  target_link_libraries(${_exe} PUBLIC ${_lib})
endforeach()
set_target_properties(fsnotifier-static PROPERTIES INSTALL_RPATH "")