/* freezetag - id3 Editor for Linux
 * Copyright (C), 1999, Jeremy Katz <katzj@linuxpower.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include "freezetag.h"

GtkWidget *entry;	/* where we enter the new filename pattern */
GtkWidget *window;	/* window for renaming -- so we can destroy it */

/* does the actual renaming*/
void write_new_filenames(GtkWidget *widget, gpointer data) {
	GList *list;
	gchar tag[129], *format, *oldpath, *lastpath, *modifiable_filename, *filename, *actual_format;
	gint fd;
	GString *newfilename;
	gchar i;
	extern char *genre_table[];
	extern int genre_count;
	extern GtkWidget *filelist;	/* clist of files */

	actual_format = gtk_entry_get_text( GTK_ENTRY (entry) );
	if ( ! (strstr(actual_format, "%1") ) ) {
		g_warning("Require format string to include song name\n");
		dialog_destroy( NULL, GTK_WIDGET (window) );
		return;
	}

	list = GTK_CLIST(filelist)->selection;
	gtk_clist_freeze( GTK_CLIST (filelist) );

	while(list) {
		gtk_clist_get_text (GTK_CLIST(filelist), (gint) list->data, 0, &filename);
		if ( (fd = open(filename, O_RDWR) ) < 0) {
			g_warning("Can't open file %s\n", filename);
			list = list->next;
			continue;
		}

		lseek(fd, -128, SEEK_END);
		read(fd, tag, 128);
		if ( (tag[0] != 'T') && (tag[1] != 'A') && (tag[2] != 'G') ) {
#ifdef DEBUG
			g_warning("Can't rename a file without a tag - %s\n", filename);
#endif
			list = list->next;
			continue;
		}
		
		newfilename = g_string_new(NULL);

		format = g_strdup(actual_format);
		
		while ( (i = *format++) != '\0') {
			if (i == '%') {
				switch (*format++) {
					case 0:
						format--;
					case '%':
						newfilename = g_string_append_c( newfilename, (gchar) "%");
						break;
					case '1':
						newfilename = g_string_append(newfilename, g_strstrip(substr(tag, 3, 30)) );
						break;
					case '2':
						newfilename = g_string_append(newfilename, g_strstrip(substr(tag, 33, 30)) );
						break;
					case '3':
						newfilename = g_string_append(newfilename, g_strstrip(substr(tag, 63, 30)) );
						break;
					case '4':
						newfilename = g_string_append(newfilename, g_strstrip(substr(tag, 93, 4)) );
						break;
					case '5':
						newfilename = g_string_append(newfilename, g_strstrip(substr(tag, 97, 30)) );
						break;
					case '6':
						if ( ( tag[127] < 0 ) || (tag[127] >= genre_count ) ) {
							tag[127] = 0;
}
						newfilename = g_string_append(newfilename, genre_table[tag[127]] );
						break;
					default:
						newfilename = g_string_append_c(newfilename, i);
						break;
				}
			} else {
				newfilename = g_string_append_c(newfilename, i);
			}
		} 
		
		modifiable_filename = g_strdup(filename);
		oldpath = strtok(modifiable_filename, "/");
		while ( (oldpath=strtok(NULL, "/")) != NULL) {
			lastpath = oldpath;
		}
		
		newfilename = g_string_prepend(newfilename, substr(filename, 0, strlen(filename)-strlen(lastpath)));

		close(fd);

		if( rename(filename,newfilename->str) ) {
			g_warning("Unable to rename %s to %s\n", filename, newfilename->str);
		} else {
			gtk_clist_set_text( GTK_CLIST (filelist), (gint) list->data, 0, newfilename->str );
		}


#ifdef DEBUG		
		g_print("%s\n", newfilename->str);
#endif

		g_string_free(newfilename, TRUE);
		g_free(modifiable_filename);
		g_free(oldpath);
		g_free(lastpath);

		list = list->next;
	}

	g_list_free(list);

	dialog_destroy( NULL, GTK_WIDGET(window) );
	gtk_clist_thaw( GTK_CLIST (filelist) );
}


void rename_box(GtkWidget *clist) {
	GtkWidget *label_table, *box_for_buttons, *vbox;
	GtkWidget *song, *artist, *album, *year, *comments, *genre;
	GtkWidget *ok, *cancel;
	GList *filenames = NULL, *list;
	gchar *tmp;

	window = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_widget_set_usize( GTK_WIDGET(window), 200, 150);
	gtk_window_set_title( GTK_WINDOW (window), "Rename Files");

	vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add( GTK_CONTAINER (window), vbox);
	gtk_widget_show(vbox);	

	label_table = gtk_table_new (3, 2, TRUE);
	gtk_box_pack_start( GTK_BOX(vbox), label_table, FALSE, FALSE, 5);

	song = gtk_label_new("%1 - Song");
	gtk_table_attach_defaults( GTK_TABLE (label_table), song, 0, 1, 0, 1);
	gtk_widget_show(song);	

	artist = gtk_label_new("%2 - Artist");
	gtk_table_attach_defaults( GTK_TABLE (label_table), artist, 1, 2, 0, 1);
	gtk_widget_show(artist);	

	album = gtk_label_new("%3 - Album");
	gtk_table_attach_defaults( GTK_TABLE (label_table), album, 0, 1, 1, 2);
	gtk_widget_show(album);

	year = gtk_label_new("%4 - Year");
	gtk_table_attach_defaults( GTK_TABLE (label_table), year, 1, 2, 1, 2);
	gtk_widget_show(year);
	
	comments = gtk_label_new("%5 - Comments");
	gtk_table_attach_defaults( GTK_TABLE (label_table), comments, 0, 1, 2, 3);
	gtk_widget_show(comments);

	genre = gtk_label_new("%6 - Genre");
	gtk_table_attach_defaults( GTK_TABLE (label_table), genre, 1, 2, 2, 3);
	gtk_widget_show(genre);

	gtk_widget_show(label_table);

	entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX(vbox), entry, FALSE, FALSE, 5);
	gtk_widget_show(entry);

	box_for_buttons = gtk_hbox_new (TRUE, 10);
	gtk_box_pack_start( GTK_BOX(vbox), box_for_buttons, FALSE, FALSE, 5);
	gtk_widget_show( box_for_buttons);

	ok = gtk_button_new_with_label("Ok");
	gtk_box_pack_start( GTK_BOX(box_for_buttons), ok, FALSE, FALSE, 5);
	gtk_widget_show(ok);

	cancel = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start( GTK_BOX(box_for_buttons), cancel, FALSE, FALSE, 5);
	gtk_widget_show(cancel);

	gtk_widget_show(window);

/*	list = GTK_CLIST(clist)->selection;
	while(list) {
		gtk_clist_get_text (GTK_CLIST(clist), (gint) list->data, 0, &tmp);
		filenames = g_list_append(filenames, tmp);
		list = list->next;
	}
	g_list_free(list);*/

	gtk_signal_connect( GTK_OBJECT (cancel), "clicked", GTK_SIGNAL_FUNC (dialog_destroy), GTK_OBJECT (window) );
	gtk_signal_connect( GTK_OBJECT (ok), "clicked", GTK_SIGNAL_FUNC(write_new_filenames), window);
	gtk_signal_connect( GTK_OBJECT (entry), "activate", GTK_SIGNAL_FUNC(write_new_filenames), window);
	
}
