/* Generated by Frama-C */
#include "pthread.h"
#include "sched.h"
#include "signal.h"
#include "stddef.h"
#include "stdint.h"
#include "stdio.h"
#include "string.h"
#include "time.h"
char *__gen_e_acsl_literal_string;
extern  __attribute__((__FC_BUILTIN__)) int __e_acsl_sound_verdict;

/*@ requires valid_string_src: valid_read_string(src);
    requires room_string: \valid(dest + (0 .. strlen(src)));
    requires
      separation:
        \separated(dest + (0 .. strlen(src)), src + (0 .. strlen(src)));
    ensures equal_contents: strcmp(\old(dest), \old(src)) == 0;
    ensures result_ptr: \result == \old(dest);
    assigns *(dest + (0 .. strlen{Old}(src))), \result;
    assigns *(dest + (0 .. strlen{Old}(src)))
      \from *(src + (0 .. strlen{Old}(src)));
    assigns \result \from dest;
 */
char *__gen_e_acsl_strcpy(char * restrict dest, char const * restrict src);

/*@ requires valid_nstring_src: valid_read_nstring(src, n);
    requires room_nstring: \valid(dest + (0 .. n - 1));
    requires separation: \separated(dest + (0 .. n - 1), src + (0 .. n - 1));
    ensures result_ptr: \result == \old(dest);
    ensures initialization: \initialized(\old(dest) + (0 .. \old(n) - 1));
    assigns *(dest + (0 .. n - 1)), \result;
    assigns *(dest + (0 .. n - 1)) \from *(src + (0 .. n - 1));
    assigns \result \from dest;
    
    behavior complete:
      assumes src_fits: strlen(src) < n;
      ensures equal_after_copy: strcmp(\old(dest), \old(src)) == 0;
    
    behavior partial:
      assumes src_too_long: n <= strlen(src);
      ensures
        equal_prefix: memcmp{Post, Post}(\old(dest), \old(src), \old(n)) == 0;
 */
char *__gen_e_acsl_strncpy(char * restrict dest, char const * restrict src,
                           size_t n);

/*@ requires valid_string_src: valid_read_string(src);
    requires valid_string_dest: valid_string(dest);
    requires room_string: \valid(dest + (0 .. strlen(dest) + strlen(src)));
    ensures
      sum_of_lengths: strlen(\old(dest)) == \old(strlen(dest) + strlen(src));
    ensures
      initialization: dest:
        \initialized(\old(dest) + (0 .. \old(strlen(dest) + strlen(src))));
    ensures
      dest_null_terminated:
        *(\old(dest) + \old(strlen(dest) + strlen(src))) == 0;
    ensures result_ptr: \result == \old(dest);
    assigns *(dest +
              (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src))),
            \result;
    assigns
    *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src)))
      \from *(src + (0 .. strlen{Old}(src)));
    assigns \result \from dest;
 */
char *__gen_e_acsl_strcat(char * restrict dest, char const * restrict src);

/*@ requires valid_nstring_src: valid_read_nstring(src, n);
    requires valid_string_dest: valid_string(dest);
    ensures result_ptr: \result == \old(dest);
    assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n)), \result;
    assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n))
      \from *(src + (0 .. n));
    assigns \result \from dest;
    
    behavior complete:
      assumes
        valid_string_src_fits: valid_read_string(src) && strlen(src) <= n;
      requires
        room_string: \valid((dest + strlen(dest)) + (0 .. strlen(src)));
      ensures
        sum_of_lengths:
          strlen(\old(dest)) == \old(strlen(dest) + strlen(src));
      assigns *(dest +
                (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src))),
              \result;
      assigns
      *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src)))
        \from *(src + (0 .. strlen{Old}(src)));
      assigns \result \from dest;
    
    behavior partial:
      assumes
        valid_string_src_too_large:
          !(valid_read_string(src) && strlen(src) <= n);
      requires room_string: \valid((dest + strlen(dest)) + (0 .. n));
      ensures
        sum_of_bounded_lengths:
          strlen(\old(dest)) == \old(strlen(dest)) + \old(n);
      assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n)),
              \result;
      assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n))
        \from *(src + (0 .. strlen{Old}(src)));
      assigns \result \from dest;
 */
char *__gen_e_acsl_strncat(char * restrict dest, char const * restrict src,
                           size_t n);

/*@ requires valid_nstring_src: valid_read_nstring(src, n);
    requires valid_string_dest: valid_string(dest);
    ensures result_ptr: \result == \old(dest);
    assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n)), \result;
    assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n))
      \from *(src + (0 .. n));
    assigns \result \from dest;
    
    behavior complete:
      assumes
        valid_string_src_fits: valid_read_string(src) && strlen(src) <= n;
      requires
        room_string: \valid((dest + strlen(dest)) + (0 .. strlen(src)));
      ensures
        sum_of_lengths:
          strlen(\old(dest)) == \old(strlen(dest) + strlen(src));
      assigns *(dest +
                (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src))),
              \result;
      assigns
      *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src)))
        \from *(src + (0 .. strlen{Old}(src)));
      assigns \result \from dest;
    
    behavior partial:
      assumes
        valid_string_src_too_large:
          !(valid_read_string(src) && strlen(src) <= n);
      requires room_string: \valid((dest + strlen(dest)) + (0 .. n));
      ensures
        sum_of_bounded_lengths:
          strlen(\old(dest)) == \old(strlen(dest)) + \old(n);
      assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n)),
              \result;
      assigns *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + n))
        \from *(src + (0 .. strlen{Old}(src)));
      assigns \result \from dest;
 */
char *__gen_e_acsl_strncat(char * restrict dest, char const * restrict src,
                           size_t n)
{
  unsigned long __gen_e_acsl_strcat_dest_size;
  unsigned long __gen_e_acsl_strcat_src_size;
  __e_acsl_contract_t *__gen_e_acsl_contract;
  char *__gen_e_acsl_at;
  char *__retres;
  __e_acsl_store_block((void *)(& dest),8UL);
  __gen_e_acsl_at = dest;
  __gen_e_acsl_contract = __e_acsl_contract_init(2UL);
  __gen_e_acsl_strcat_src_size = __e_acsl_builtin_strlen(src);
  if (n < __gen_e_acsl_strcat_src_size) __gen_e_acsl_strcat_src_size = n;
  __gen_e_acsl_strcat_dest_size = __e_acsl_builtin_strlen((char const *)dest);
  __retres = strncat(dest,src,n);
  {
    __e_acsl_mpz_t __gen_e_acsl___gen_e_acsl_strcat_src_size;
    __e_acsl_mpz_t __gen_e_acsl___gen_e_acsl_strcat_dest_size;
    __e_acsl_mpz_t __gen_e_acsl_add;
    __e_acsl_mpz_t __gen_e_acsl_;
    __e_acsl_mpz_t __gen_e_acsl_add_2;
    __e_acsl_mpz_t __gen_e_acsl__2;
    int __gen_e_acsl_le;
    unsigned long __gen_e_acsl_size;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_5 =
      {.values = (void *)0};
    __gmpz_init_set_ui(__gen_e_acsl___gen_e_acsl_strcat_src_size,
                       __gen_e_acsl_strcat_src_size);
    __gmpz_init_set_ui(__gen_e_acsl___gen_e_acsl_strcat_dest_size,
                       __gen_e_acsl_strcat_dest_size);
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl___gen_e_acsl_strcat_src_size),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl___gen_e_acsl_strcat_dest_size));
    __gmpz_init_set_si(__gen_e_acsl_,1L);
    __gmpz_init(__gen_e_acsl_add_2);
    __gmpz_add(__gen_e_acsl_add_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init_set_ui(__gen_e_acsl__2,18446744073709551615UL);
    __gen_e_acsl_le = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_5,
                                   "__gen_e_acsl_strcat_src_size",0,
                                   __gen_e_acsl_strcat_src_size);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_5,
                                   "__gen_e_acsl_strcat_dest_size",0,
                                   __gen_e_acsl_strcat_dest_size);
    __gen_e_acsl_assert_data_5.blocking = 1;
    __gen_e_acsl_assert_data_5.kind = "RTE";
    __gen_e_acsl_assert_data_5.pred_txt = "(__gen_e_acsl_strcat_src_size + __gen_e_acsl_strcat_dest_size) + 1 <=\n18446744073709551615";
    __gen_e_acsl_assert_data_5.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_5.fct = "strncat";
    __gen_e_acsl_assert_data_5.line = 438;
    __gen_e_acsl_assert_data_5.name = "size_lesser_or_eq_than_SIZE_MAX";
    __e_acsl_assert(__gen_e_acsl_le <= 0,& __gen_e_acsl_assert_data_5);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_5);
    __gen_e_acsl_size = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2));
    __e_acsl_initialize((void *)dest,__gen_e_acsl_size);
    __gmpz_clear(__gen_e_acsl___gen_e_acsl_strcat_src_size);
    __gmpz_clear(__gen_e_acsl___gen_e_acsl_strcat_dest_size);
    __gmpz_clear(__gen_e_acsl_add);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_add_2);
    __gmpz_clear(__gen_e_acsl__2);
  }
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_6 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,"\\result",
                                 (void *)__retres);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,"\\old(dest)",
                                 (void *)__gen_e_acsl_at);
    __gen_e_acsl_assert_data_6.blocking = 1;
    __gen_e_acsl_assert_data_6.kind = "Postcondition";
    __gen_e_acsl_assert_data_6.pred_txt = "\\result == \\old(dest)";
    __gen_e_acsl_assert_data_6.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_6.fct = "strncat";
    __gen_e_acsl_assert_data_6.line = 443;
    __gen_e_acsl_assert_data_6.name = "result_ptr";
    __e_acsl_assert(__retres == __gen_e_acsl_at,& __gen_e_acsl_assert_data_6);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_6);
    __e_acsl_contract_clean(__gen_e_acsl_contract);
    __e_acsl_delete_block((void *)(& dest));
    return __retres;
  }
}

/*@ requires valid_string_src: valid_read_string(src);
    requires valid_string_dest: valid_string(dest);
    requires room_string: \valid(dest + (0 .. strlen(dest) + strlen(src)));
    ensures
      sum_of_lengths: strlen(\old(dest)) == \old(strlen(dest) + strlen(src));
    ensures
      initialization: dest:
        \initialized(\old(dest) + (0 .. \old(strlen(dest) + strlen(src))));
    ensures
      dest_null_terminated:
        *(\old(dest) + \old(strlen(dest) + strlen(src))) == 0;
    ensures result_ptr: \result == \old(dest);
    assigns *(dest +
              (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src))),
            \result;
    assigns
    *(dest + (strlen{Old}(dest) .. strlen{Old}(dest) + strlen{Old}(src)))
      \from *(src + (0 .. strlen{Old}(src)));
    assigns \result \from dest;
 */
char *__gen_e_acsl_strcat(char * restrict dest, char const * restrict src)
{
  unsigned long __gen_e_acsl_strcat_dest_size;
  unsigned long __gen_e_acsl_strcat_src_size;
  char *__gen_e_acsl_at;
  char *__retres;
  __e_acsl_store_block((void *)(& dest),8UL);
  __gen_e_acsl_at = dest;
  __gen_e_acsl_strcat_src_size = __e_acsl_builtin_strlen(src);
  __gen_e_acsl_strcat_dest_size = __e_acsl_builtin_strlen((char const *)dest);
  __retres = strcat(dest,src);
  {
    __e_acsl_mpz_t __gen_e_acsl___gen_e_acsl_strcat_src_size;
    __e_acsl_mpz_t __gen_e_acsl___gen_e_acsl_strcat_dest_size;
    __e_acsl_mpz_t __gen_e_acsl_add;
    __e_acsl_mpz_t __gen_e_acsl_;
    __e_acsl_mpz_t __gen_e_acsl_add_2;
    __e_acsl_mpz_t __gen_e_acsl__2;
    int __gen_e_acsl_le;
    unsigned long __gen_e_acsl_size;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_4 =
      {.values = (void *)0};
    __gmpz_init_set_ui(__gen_e_acsl___gen_e_acsl_strcat_src_size,
                       __gen_e_acsl_strcat_src_size);
    __gmpz_init_set_ui(__gen_e_acsl___gen_e_acsl_strcat_dest_size,
                       __gen_e_acsl_strcat_dest_size);
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl___gen_e_acsl_strcat_src_size),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl___gen_e_acsl_strcat_dest_size));
    __gmpz_init_set_si(__gen_e_acsl_,1L);
    __gmpz_init(__gen_e_acsl_add_2);
    __gmpz_add(__gen_e_acsl_add_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init_set_ui(__gen_e_acsl__2,18446744073709551615UL);
    __gen_e_acsl_le = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,
                                   "__gen_e_acsl_strcat_src_size",0,
                                   __gen_e_acsl_strcat_src_size);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,
                                   "__gen_e_acsl_strcat_dest_size",0,
                                   __gen_e_acsl_strcat_dest_size);
    __gen_e_acsl_assert_data_4.blocking = 1;
    __gen_e_acsl_assert_data_4.kind = "RTE";
    __gen_e_acsl_assert_data_4.pred_txt = "(__gen_e_acsl_strcat_src_size + __gen_e_acsl_strcat_dest_size) + 1 <=\n18446744073709551615";
    __gen_e_acsl_assert_data_4.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_4.fct = "strcat";
    __gen_e_acsl_assert_data_4.line = 423;
    __gen_e_acsl_assert_data_4.name = "size_lesser_or_eq_than_SIZE_MAX";
    __e_acsl_assert(__gen_e_acsl_le <= 0,& __gen_e_acsl_assert_data_4);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_4);
    __gen_e_acsl_size = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2));
    __e_acsl_initialize((void *)dest,__gen_e_acsl_size);
    __gmpz_clear(__gen_e_acsl___gen_e_acsl_strcat_src_size);
    __gmpz_clear(__gen_e_acsl___gen_e_acsl_strcat_dest_size);
    __gmpz_clear(__gen_e_acsl_add);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_add_2);
    __gmpz_clear(__gen_e_acsl__2);
  }
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_8 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,"\\result",
                                 (void *)__retres);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,"\\old(dest)",
                                 (void *)__gen_e_acsl_at);
    __gen_e_acsl_assert_data_8.blocking = 1;
    __gen_e_acsl_assert_data_8.kind = "Postcondition";
    __gen_e_acsl_assert_data_8.pred_txt = "\\result == \\old(dest)";
    __gen_e_acsl_assert_data_8.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_8.fct = "strcat";
    __gen_e_acsl_assert_data_8.line = 434;
    __gen_e_acsl_assert_data_8.name = "result_ptr";
    __e_acsl_assert(__retres == __gen_e_acsl_at,& __gen_e_acsl_assert_data_8);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_8);
    __e_acsl_delete_block((void *)(& dest));
    return __retres;
  }
}

/*@ requires valid_nstring_src: valid_read_nstring(src, n);
    requires room_nstring: \valid(dest + (0 .. n - 1));
    requires separation: \separated(dest + (0 .. n - 1), src + (0 .. n - 1));
    ensures result_ptr: \result == \old(dest);
    ensures initialization: \initialized(\old(dest) + (0 .. \old(n) - 1));
    assigns *(dest + (0 .. n - 1)), \result;
    assigns *(dest + (0 .. n - 1)) \from *(src + (0 .. n - 1));
    assigns \result \from dest;
    
    behavior complete:
      assumes src_fits: strlen(src) < n;
      ensures equal_after_copy: strcmp(\old(dest), \old(src)) == 0;
    
    behavior partial:
      assumes src_too_long: n <= strlen(src);
      ensures
        equal_prefix: memcmp{Post, Post}(\old(dest), \old(src), \old(n)) == 0;
 */
char *__gen_e_acsl_strncpy(char * restrict dest, char const * restrict src,
                           size_t n)
{
  __e_acsl_contract_t *__gen_e_acsl_contract;
  __e_acsl_mpz_t __gen_e_acsl_at_2;
  char *__gen_e_acsl_at;
  char *__retres;
  {
    __e_acsl_mpz_t __gen_e_acsl_n;
    unsigned long __gen_e_acsl_size;
    __e_acsl_mpz_t __gen_e_acsl_n_2;
    __e_acsl_mpz_t __gen_e_acsl_;
    __e_acsl_mpz_t __gen_e_acsl_sub;
    __e_acsl_mpz_t __gen_e_acsl__2;
    __e_acsl_mpz_t __gen_e_acsl_sub_2;
    __e_acsl_mpz_t __gen_e_acsl_add;
    unsigned long __gen_e_acsl__3;
    unsigned long __gen_e_acsl_if;
    int __gen_e_acsl_valid;
    unsigned long __gen_e_acsl_size_2;
    unsigned long __gen_e_acsl__4;
    unsigned long __gen_e_acsl_if_2;
    int __gen_e_acsl_valid_read;
    unsigned long __gen_e_acsl_size_3;
    unsigned long __gen_e_acsl__5;
    unsigned long __gen_e_acsl_if_3;
    int __gen_e_acsl_valid_read_2;
    unsigned long __gen_e_acsl_size_4;
    unsigned long __gen_e_acsl__6;
    unsigned long __gen_e_acsl_if_4;
    unsigned long __gen_e_acsl_size_5;
    unsigned long __gen_e_acsl__7;
    unsigned long __gen_e_acsl_if_5;
    int __gen_e_acsl_separated;
    __e_acsl_store_block((void *)(& src),8UL);
    __e_acsl_store_block((void *)(& dest),8UL);
    __gen_e_acsl_at = dest;
    __gmpz_init_set_ui(__gen_e_acsl_n,n);
    __gmpz_init_set(__gen_e_acsl_at_2,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl_n));
    __gen_e_acsl_contract = __e_acsl_contract_init(2UL);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_2 =
      {.values = (void *)0};
    __gmpz_init_set_ui(__gen_e_acsl_n_2,n);
    __gmpz_init_set_si(__gen_e_acsl_,1L);
    __gmpz_init(__gen_e_acsl_sub);
    __gmpz_sub(__gen_e_acsl_sub,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_n_2),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init_set_si(__gen_e_acsl__2,0L);
    __gmpz_init(__gen_e_acsl_sub_2);
    __gmpz_sub(__gen_e_acsl_sub_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub_2),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gen_e_acsl__3 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __gen_e_acsl_size = 1UL * __gen_e_acsl__3;
    if (__gen_e_acsl_size <= 0UL) __gen_e_acsl_if = 0UL;
    else __gen_e_acsl_if = __gen_e_acsl_size;
    __gen_e_acsl_valid = __e_acsl_valid((void *)(dest + 1 * 0),
                                        __gen_e_acsl_if,(void *)dest,
                                        (void *)(& dest));
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_2,"dest",
                                 (void *)dest);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,"n",0,n);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,"size",0,
                                   __gen_e_acsl_size);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,"size",0,
                                   __gen_e_acsl_size);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,
                                 "room_nstring: \\valid(dest + (0 .. n - 1))",
                                 0,__gen_e_acsl_valid);
    __gen_e_acsl_assert_data_2.blocking = 1;
    __gen_e_acsl_assert_data_2.kind = "Precondition";
    __gen_e_acsl_assert_data_2.pred_txt = "\\valid(dest + (0 .. n - 1))";
    __gen_e_acsl_assert_data_2.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_2.fct = "strncpy";
    __gen_e_acsl_assert_data_2.line = 380;
    __gen_e_acsl_assert_data_2.name = "room_nstring";
    __e_acsl_assert(__gen_e_acsl_valid,& __gen_e_acsl_assert_data_2);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_2);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_3 =
      {.values = (void *)0};
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_4 =
      {.values = (void *)0};
    __gen_e_acsl__4 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __gen_e_acsl_size_2 = 1UL * __gen_e_acsl__4;
    if (__gen_e_acsl_size_2 <= 0UL) __gen_e_acsl_if_2 = 0UL;
    else __gen_e_acsl_if_2 = __gen_e_acsl_size_2;
    __gen_e_acsl_valid_read = __e_acsl_valid_read((void *)(dest + 1 * 0),
                                                  __gen_e_acsl_if_2,
                                                  (void *)dest,
                                                  (void *)(& dest));
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_4,"dest",
                                 (void *)dest);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,"n",0,n);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,"size",0,
                                   __gen_e_acsl_size_2);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,"size",0,
                                   __gen_e_acsl_size_2);
    __gen_e_acsl_assert_data_4.blocking = 1;
    __gen_e_acsl_assert_data_4.kind = "RTE";
    __gen_e_acsl_assert_data_4.pred_txt = "\\valid_read(dest + (0 .. n - 1))";
    __gen_e_acsl_assert_data_4.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_4.fct = "strncpy";
    __gen_e_acsl_assert_data_4.line = 382;
    __gen_e_acsl_assert_data_4.name = "separated_guard";
    __e_acsl_assert(__gen_e_acsl_valid_read,& __gen_e_acsl_assert_data_4);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_4);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_5 =
      {.values = (void *)0};
    __gen_e_acsl__5 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __gen_e_acsl_size_3 = 1UL * __gen_e_acsl__5;
    if (__gen_e_acsl_size_3 <= 0UL) __gen_e_acsl_if_3 = 0UL;
    else __gen_e_acsl_if_3 = __gen_e_acsl_size_3;
    __gen_e_acsl_valid_read_2 = __e_acsl_valid_read((void *)(src + 1 * 0),
                                                    __gen_e_acsl_if_3,
                                                    (void *)src,
                                                    (void *)(& src));
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_5,"src",
                                 (void *)src);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,
                                 "sizeof(char const)",0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,
                                 "sizeof(char const)",0,1);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_5,"n",0,n);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_5,"size",0,
                                   __gen_e_acsl_size_3);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_5,"size",0,
                                   __gen_e_acsl_size_3);
    __gen_e_acsl_assert_data_5.blocking = 1;
    __gen_e_acsl_assert_data_5.kind = "RTE";
    __gen_e_acsl_assert_data_5.pred_txt = "\\valid_read(src + (0 .. n - 1))";
    __gen_e_acsl_assert_data_5.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_5.fct = "strncpy";
    __gen_e_acsl_assert_data_5.line = 382;
    __gen_e_acsl_assert_data_5.name = "separated_guard";
    __e_acsl_assert(__gen_e_acsl_valid_read_2,& __gen_e_acsl_assert_data_5);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_5);
    __gen_e_acsl__6 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __gen_e_acsl_size_4 = 1UL * __gen_e_acsl__6;
    if (__gen_e_acsl_size_4 <= 0UL) __gen_e_acsl_if_4 = 0UL;
    else __gen_e_acsl_if_4 = __gen_e_acsl_size_4;
    __gen_e_acsl__7 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __gen_e_acsl_size_5 = 1UL * __gen_e_acsl__7;
    if (__gen_e_acsl_size_5 <= 0UL) __gen_e_acsl_if_5 = 0UL;
    else __gen_e_acsl_if_5 = __gen_e_acsl_size_5;
    __gen_e_acsl_separated = __e_acsl_separated(2UL,dest + 1 * 0,
                                                __gen_e_acsl_if_4,
                                                src + 1 * 0,
                                                __gen_e_acsl_if_5);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_3,"dest",
                                 (void *)dest);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"n",0,n);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_4);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_4);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_3,"src",
                                 (void *)src);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                 "sizeof(char const)",0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                 "sizeof(char const)",0,1);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"n",0,n);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_5);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_5);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                 "separation: \\separated(dest + (0 .. n - 1), src + (0 .. n - 1))",
                                 0,__gen_e_acsl_separated);
    __gen_e_acsl_assert_data_3.blocking = 1;
    __gen_e_acsl_assert_data_3.kind = "Precondition";
    __gen_e_acsl_assert_data_3.pred_txt = "\\separated(dest + (0 .. n - 1), src + (0 .. n - 1))";
    __gen_e_acsl_assert_data_3.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_3.fct = "strncpy";
    __gen_e_acsl_assert_data_3.line = 382;
    __gen_e_acsl_assert_data_3.name = "separation";
    __e_acsl_assert(__gen_e_acsl_separated,& __gen_e_acsl_assert_data_3);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_3);
    __gmpz_clear(__gen_e_acsl_n);
    __gmpz_clear(__gen_e_acsl_n_2);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_sub);
    __gmpz_clear(__gen_e_acsl__2);
    __gmpz_clear(__gen_e_acsl_sub_2);
    __gmpz_clear(__gen_e_acsl_add);
  }
  __retres = strncpy(dest,src,n);
  __e_acsl_initialize((void *)dest,n);
  {
    unsigned long __gen_e_acsl_size_6;
    __e_acsl_mpz_t __gen_e_acsl__8;
    __e_acsl_mpz_t __gen_e_acsl_sub_3;
    __e_acsl_mpz_t __gen_e_acsl__9;
    __e_acsl_mpz_t __gen_e_acsl_sub_4;
    __e_acsl_mpz_t __gen_e_acsl_add_2;
    unsigned long __gen_e_acsl__10;
    unsigned long __gen_e_acsl_if_6;
    int __gen_e_acsl_initialized;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_6 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,"\\result",
                                 (void *)__retres);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,"\\old(dest)",
                                 (void *)__gen_e_acsl_at);
    __gen_e_acsl_assert_data_6.blocking = 1;
    __gen_e_acsl_assert_data_6.kind = "Postcondition";
    __gen_e_acsl_assert_data_6.pred_txt = "\\result == \\old(dest)";
    __gen_e_acsl_assert_data_6.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_6.fct = "strncpy";
    __gen_e_acsl_assert_data_6.line = 385;
    __gen_e_acsl_assert_data_6.name = "result_ptr";
    __e_acsl_assert(__retres == __gen_e_acsl_at,& __gen_e_acsl_assert_data_6);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_6);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_7 =
      {.values = (void *)0};
    __gmpz_init_set_si(__gen_e_acsl__8,1L);
    __gmpz_init(__gen_e_acsl_sub_3);
    __gmpz_sub(__gen_e_acsl_sub_3,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_at_2),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__8));
    __gmpz_init_set_si(__gen_e_acsl__9,0L);
    __gmpz_init(__gen_e_acsl_sub_4);
    __gmpz_sub(__gen_e_acsl_sub_4,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub_3),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__9));
    __gmpz_init(__gen_e_acsl_add_2);
    __gmpz_add(__gen_e_acsl_add_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub_4),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__8));
    __gen_e_acsl__10 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2));
    __gen_e_acsl_size_6 = 1UL * __gen_e_acsl__10;
    if (__gen_e_acsl_size_6 <= 0UL) __gen_e_acsl_if_6 = 0UL;
    else __gen_e_acsl_if_6 = __gen_e_acsl_size_6;
    __gen_e_acsl_initialized = __e_acsl_initialized((void *)(__gen_e_acsl_at + 
                                                             1 * 0),
                                                    __gen_e_acsl_if_6);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_7,"\\old(dest)",
                                 (void *)__gen_e_acsl_at);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_7,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_7,"sizeof(char)",
                                 0,1);
    __e_acsl_assert_register_mpz(& __gen_e_acsl_assert_data_7,"\\old(n)",0,
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_at_2));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_7,"size",0,
                                   __gen_e_acsl_size_6);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_7,"size",0,
                                   __gen_e_acsl_size_6);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_7,
                                 "initialization: \\initialized(\\old(dest) + (0 .. \\old(n) - 1))",
                                 0,__gen_e_acsl_initialized);
    __gen_e_acsl_assert_data_7.blocking = 1;
    __gen_e_acsl_assert_data_7.kind = "Postcondition";
    __gen_e_acsl_assert_data_7.pred_txt = "\\initialized(\\old(dest) + (0 .. \\old(n) - 1))";
    __gen_e_acsl_assert_data_7.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_7.fct = "strncpy";
    __gen_e_acsl_assert_data_7.line = 386;
    __gen_e_acsl_assert_data_7.name = "initialization";
    __e_acsl_assert(__gen_e_acsl_initialized,& __gen_e_acsl_assert_data_7);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_7);
    __e_acsl_contract_clean(__gen_e_acsl_contract);
    __e_acsl_delete_block((void *)(& src));
    __e_acsl_delete_block((void *)(& dest));
    __gmpz_clear(__gen_e_acsl__8);
    __gmpz_clear(__gen_e_acsl_sub_3);
    __gmpz_clear(__gen_e_acsl__9);
    __gmpz_clear(__gen_e_acsl_sub_4);
    __gmpz_clear(__gen_e_acsl_add_2);
    __gmpz_clear(__gen_e_acsl_at_2);
    return __retres;
  }
}

/*@ requires valid_string_src: valid_read_string(src);
    requires room_string: \valid(dest + (0 .. strlen(src)));
    requires
      separation:
        \separated(dest + (0 .. strlen(src)), src + (0 .. strlen(src)));
    ensures equal_contents: strcmp(\old(dest), \old(src)) == 0;
    ensures result_ptr: \result == \old(dest);
    assigns *(dest + (0 .. strlen{Old}(src))), \result;
    assigns *(dest + (0 .. strlen{Old}(src)))
      \from *(src + (0 .. strlen{Old}(src)));
    assigns \result \from dest;
 */
char *__gen_e_acsl_strcpy(char * restrict dest, char const * restrict src)
{
  unsigned long __gen_e_acsl_strcpy_src_size;
  char *__gen_e_acsl_at;
  char *__retres;
  __e_acsl_store_block((void *)(& src),8UL);
  __e_acsl_store_block((void *)(& dest),8UL);
  __gen_e_acsl_at = dest;
  __gen_e_acsl_strcpy_src_size = __e_acsl_builtin_strlen(src);
  __retres = strcpy(dest,src);
  {
    __e_acsl_mpz_t __gen_e_acsl___gen_e_acsl_strcpy_src_size;
    __e_acsl_mpz_t __gen_e_acsl_;
    __e_acsl_mpz_t __gen_e_acsl_add;
    __e_acsl_mpz_t __gen_e_acsl__2;
    int __gen_e_acsl_le;
    unsigned long __gen_e_acsl_size;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_6 =
      {.values = (void *)0};
    __gmpz_init_set_ui(__gen_e_acsl___gen_e_acsl_strcpy_src_size,
                       __gen_e_acsl_strcpy_src_size);
    __gmpz_init_set_si(__gen_e_acsl_,1L);
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl___gen_e_acsl_strcpy_src_size),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init_set_ui(__gen_e_acsl__2,18446744073709551615UL);
    __gen_e_acsl_le = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_6,
                                   "__gen_e_acsl_strcpy_src_size",0,
                                   __gen_e_acsl_strcpy_src_size);
    __gen_e_acsl_assert_data_6.blocking = 1;
    __gen_e_acsl_assert_data_6.kind = "RTE";
    __gen_e_acsl_assert_data_6.pred_txt = "__gen_e_acsl_strcpy_src_size + 1 <= 18446744073709551615";
    __gen_e_acsl_assert_data_6.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_6.fct = "strcpy";
    __gen_e_acsl_assert_data_6.line = 367;
    __gen_e_acsl_assert_data_6.name = "size_lesser_or_eq_than_SIZE_MAX";
    __e_acsl_assert(__gen_e_acsl_le <= 0,& __gen_e_acsl_assert_data_6);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_6);
    __gen_e_acsl_size = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_add));
    __e_acsl_initialize((void *)dest,__gen_e_acsl_size);
    __gmpz_clear(__gen_e_acsl___gen_e_acsl_strcpy_src_size);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_add);
    __gmpz_clear(__gen_e_acsl__2);
  }
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_8 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,"\\result",
                                 (void *)__retres);
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,"\\old(dest)",
                                 (void *)__gen_e_acsl_at);
    __gen_e_acsl_assert_data_8.blocking = 1;
    __gen_e_acsl_assert_data_8.kind = "Postcondition";
    __gen_e_acsl_assert_data_8.pred_txt = "\\result == \\old(dest)";
    __gen_e_acsl_assert_data_8.file = "FRAMAC_SHARE/libc/string.h";
    __gen_e_acsl_assert_data_8.fct = "strcpy";
    __gen_e_acsl_assert_data_8.line = 374;
    __gen_e_acsl_assert_data_8.name = "result_ptr";
    __e_acsl_assert(__retres == __gen_e_acsl_at,& __gen_e_acsl_assert_data_8);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_8);
    __e_acsl_delete_block((void *)(& src));
    __e_acsl_delete_block((void *)(& dest));
    return __retres;
  }
}

void __e_acsl_globals_init(void)
{
  static char __e_acsl_already_run = 0;
  if (! __e_acsl_already_run) {
    __e_acsl_already_run = 1;
    __gen_e_acsl_literal_string = "a";
    __e_acsl_store_block((void *)__gen_e_acsl_literal_string,sizeof("a"));
    __e_acsl_full_init((void *)__gen_e_acsl_literal_string);
    __e_acsl_mark_readonly((void *)__gen_e_acsl_literal_string);
  }
  return;
}

int main(void)
{
  int __retres;
  __e_acsl_memory_init((int *)0,(char ***)0,8UL);
  __e_acsl_globals_init();
  {
    char dest[4];
    __e_acsl_store_block((void *)(dest),4UL);
    char src[2] = {(char)'b', (char)'\000'};
    __e_acsl_store_block((void *)(src),2UL);
    __e_acsl_full_init((void *)(& src));
    {
      int __gen_e_acsl_size;
      int __gen_e_acsl_if;
      int __gen_e_acsl_initialized;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data =
        {.values = (void *)0};
      __gen_e_acsl_size = 1 * ((3 - 0) + 1);
      if (__gen_e_acsl_size <= 0) __gen_e_acsl_if = 0;
      else __gen_e_acsl_if = __gen_e_acsl_size;
      __gen_e_acsl_initialized = __e_acsl_initialized((void *)(dest + 1 * 0),
                                                      (size_t)__gen_e_acsl_if);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data,"(char *)dest",
                                   (void *)(dest));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,"sizeof(char)",
                                   0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,"sizeof(char)",
                                   0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,"size",0,
                                   __gen_e_acsl_size);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,"size",0,
                                   __gen_e_acsl_size);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,
                                   "\\initialized(&dest[0 .. 3])",0,
                                   __gen_e_acsl_initialized);
      __gen_e_acsl_assert_data.blocking = 1;
      __gen_e_acsl_assert_data.kind = "Assertion";
      __gen_e_acsl_assert_data.pred_txt = "!\\initialized(&dest[0 .. 3])";
      __gen_e_acsl_assert_data.file = "str.c";
      __gen_e_acsl_assert_data.fct = "main";
      __gen_e_acsl_assert_data.line = 12;
      __e_acsl_assert(! __gen_e_acsl_initialized,& __gen_e_acsl_assert_data);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data);
    }
    /*@ assert !\initialized(&dest[0 .. 3]); */ ;
    {
      int __gen_e_acsl_size_2;
      int __gen_e_acsl_if_2;
      int __gen_e_acsl_initialized_2;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_2 =
        {.values = (void *)0};
      __gen_e_acsl_size_2 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_2 <= 0) __gen_e_acsl_if_2 = 0;
      else __gen_e_acsl_if_2 = __gen_e_acsl_size_2;
      __gen_e_acsl_initialized_2 = __e_acsl_initialized((void *)(src + 1 * 0),
                                                        (size_t)__gen_e_acsl_if_2);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_2,
                                   "(char *)src",(void *)(src));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,"size",0,
                                   __gen_e_acsl_size_2);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,"size",0,
                                   __gen_e_acsl_size_2);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,
                                   "\\initialized(&src[0 .. 1])",0,
                                   __gen_e_acsl_initialized_2);
      __gen_e_acsl_assert_data_2.blocking = 1;
      __gen_e_acsl_assert_data_2.kind = "Assertion";
      __gen_e_acsl_assert_data_2.pred_txt = "\\initialized(&src[0 .. 1])";
      __gen_e_acsl_assert_data_2.file = "str.c";
      __gen_e_acsl_assert_data_2.fct = "main";
      __gen_e_acsl_assert_data_2.line = 13;
      __e_acsl_assert(__gen_e_acsl_initialized_2,
                      & __gen_e_acsl_assert_data_2);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_2);
    }
    /*@ assert \initialized(&src[0 .. 1]); */ ;
    __gen_e_acsl_strcpy(dest,(char const *)(src));
    {
      int __gen_e_acsl_size_3;
      int __gen_e_acsl_if_3;
      int __gen_e_acsl_initialized_3;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_3 =
        {.values = (void *)0};
      __gen_e_acsl_size_3 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_3 <= 0) __gen_e_acsl_if_3 = 0;
      else __gen_e_acsl_if_3 = __gen_e_acsl_size_3;
      __gen_e_acsl_initialized_3 = __e_acsl_initialized((void *)(dest + 1 * 0),
                                                        (size_t)__gen_e_acsl_if_3);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_3,
                                   "(char *)dest",(void *)(dest));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_3);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,"size",0,
                                   __gen_e_acsl_size_3);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                   "\\initialized(&dest[0 .. 1])",0,
                                   __gen_e_acsl_initialized_3);
      __gen_e_acsl_assert_data_3.blocking = 1;
      __gen_e_acsl_assert_data_3.kind = "Assertion";
      __gen_e_acsl_assert_data_3.pred_txt = "\\initialized(&dest[0 .. 1])";
      __gen_e_acsl_assert_data_3.file = "str.c";
      __gen_e_acsl_assert_data_3.fct = "main";
      __gen_e_acsl_assert_data_3.line = 16;
      __e_acsl_assert(__gen_e_acsl_initialized_3,
                      & __gen_e_acsl_assert_data_3);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_3);
    }
    /*@ assert \initialized(&dest[0 .. 1]); */ ;
    {
      int __gen_e_acsl_size_4;
      int __gen_e_acsl_if_4;
      int __gen_e_acsl_initialized_4;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_4 =
        {.values = (void *)0};
      __gen_e_acsl_size_4 = 1 * ((3 - 2) + 1);
      if (__gen_e_acsl_size_4 <= 0) __gen_e_acsl_if_4 = 0;
      else __gen_e_acsl_if_4 = __gen_e_acsl_size_4;
      __gen_e_acsl_initialized_4 = __e_acsl_initialized((void *)(dest + 1 * 2),
                                                        (size_t)__gen_e_acsl_if_4);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_4,
                                   "(char *)dest",(void *)(dest));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"size",0,
                                   __gen_e_acsl_size_4);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"size",0,
                                   __gen_e_acsl_size_4);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,
                                   "\\initialized(&dest[2 .. 3])",0,
                                   __gen_e_acsl_initialized_4);
      __gen_e_acsl_assert_data_4.blocking = 1;
      __gen_e_acsl_assert_data_4.kind = "Assertion";
      __gen_e_acsl_assert_data_4.pred_txt = "!\\initialized(&dest[2 .. 3])";
      __gen_e_acsl_assert_data_4.file = "str.c";
      __gen_e_acsl_assert_data_4.fct = "main";
      __gen_e_acsl_assert_data_4.line = 17;
      __e_acsl_assert(! __gen_e_acsl_initialized_4,
                      & __gen_e_acsl_assert_data_4);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_4);
    }
    /*@ assert !\initialized(&dest[2 .. 3]); */ ;
    __e_acsl_delete_block((void *)(src));
    __e_acsl_delete_block((void *)(dest));
  }
  {
    char dest_0[4];
    __e_acsl_store_block((void *)(dest_0),4UL);
    char src_0[4] = {(char)'a', (char)'b', (char)'\000'};
    __e_acsl_store_block((void *)(src_0),4UL);
    __e_acsl_full_init((void *)(& src_0));
    {
      int __gen_e_acsl_size_5;
      int __gen_e_acsl_if_5;
      int __gen_e_acsl_initialized_5;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_5 =
        {.values = (void *)0};
      __gen_e_acsl_size_5 = 1 * ((3 - 0) + 1);
      if (__gen_e_acsl_size_5 <= 0) __gen_e_acsl_if_5 = 0;
      else __gen_e_acsl_if_5 = __gen_e_acsl_size_5;
      __gen_e_acsl_initialized_5 = __e_acsl_initialized((void *)(dest_0 + 
                                                                 1 * 0),
                                                        (size_t)__gen_e_acsl_if_5);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_5,
                                   "(char *)dest_0",(void *)(dest_0));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,"size",0,
                                   __gen_e_acsl_size_5);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,"size",0,
                                   __gen_e_acsl_size_5);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,
                                   "\\initialized(&dest_0[0 .. 3])",0,
                                   __gen_e_acsl_initialized_5);
      __gen_e_acsl_assert_data_5.blocking = 1;
      __gen_e_acsl_assert_data_5.kind = "Assertion";
      __gen_e_acsl_assert_data_5.pred_txt = "!\\initialized(&dest_0[0 .. 3])";
      __gen_e_acsl_assert_data_5.file = "str.c";
      __gen_e_acsl_assert_data_5.fct = "main";
      __gen_e_acsl_assert_data_5.line = 22;
      __e_acsl_assert(! __gen_e_acsl_initialized_5,
                      & __gen_e_acsl_assert_data_5);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_5);
    }
    /*@ assert !\initialized(&dest_0[0 .. 3]); */ ;
    {
      int __gen_e_acsl_size_6;
      int __gen_e_acsl_if_6;
      int __gen_e_acsl_initialized_6;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_6 =
        {.values = (void *)0};
      __gen_e_acsl_size_6 = 1 * ((3 - 0) + 1);
      if (__gen_e_acsl_size_6 <= 0) __gen_e_acsl_if_6 = 0;
      else __gen_e_acsl_if_6 = __gen_e_acsl_size_6;
      __gen_e_acsl_initialized_6 = __e_acsl_initialized((void *)(src_0 + 
                                                                 1 * 0),
                                                        (size_t)__gen_e_acsl_if_6);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,
                                   "(char *)src_0",(void *)(src_0));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_6,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_6,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_6,"size",0,
                                   __gen_e_acsl_size_6);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_6,"size",0,
                                   __gen_e_acsl_size_6);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_6,
                                   "\\initialized(&src_0[0 .. 3])",0,
                                   __gen_e_acsl_initialized_6);
      __gen_e_acsl_assert_data_6.blocking = 1;
      __gen_e_acsl_assert_data_6.kind = "Assertion";
      __gen_e_acsl_assert_data_6.pred_txt = "\\initialized(&src_0[0 .. 3])";
      __gen_e_acsl_assert_data_6.file = "str.c";
      __gen_e_acsl_assert_data_6.fct = "main";
      __gen_e_acsl_assert_data_6.line = 23;
      __e_acsl_assert(__gen_e_acsl_initialized_6,
                      & __gen_e_acsl_assert_data_6);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_6);
    }
    /*@ assert \initialized(&src_0[0 .. 3]); */ ;
    __gen_e_acsl_strncpy(dest_0,(char const *)(src_0),(size_t)1);
    {
      int __gen_e_acsl_initialized_7;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_7 =
        {.values = (void *)0};
      __gen_e_acsl_initialized_7 = __e_acsl_initialized((void *)(dest_0),
                                                        sizeof(char));
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_7,
                                   "(char *)dest_0",(void *)(dest_0));
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_7,
                                     "sizeof(char)",0,sizeof(char));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_7,
                                   "\\initialized((char *)dest_0)",0,
                                   __gen_e_acsl_initialized_7);
      __gen_e_acsl_assert_data_7.blocking = 1;
      __gen_e_acsl_assert_data_7.kind = "Assertion";
      __gen_e_acsl_assert_data_7.pred_txt = "\\initialized((char *)dest_0)";
      __gen_e_acsl_assert_data_7.file = "str.c";
      __gen_e_acsl_assert_data_7.fct = "main";
      __gen_e_acsl_assert_data_7.line = 26;
      __e_acsl_assert(__gen_e_acsl_initialized_7,
                      & __gen_e_acsl_assert_data_7);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_7);
    }
    /*@ assert \initialized((char *)dest_0); */ ;
    {
      int __gen_e_acsl_size_7;
      int __gen_e_acsl_if_7;
      int __gen_e_acsl_initialized_8;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_8 =
        {.values = (void *)0};
      __gen_e_acsl_size_7 = 1 * ((3 - 1) + 1);
      if (__gen_e_acsl_size_7 <= 0) __gen_e_acsl_if_7 = 0;
      else __gen_e_acsl_if_7 = __gen_e_acsl_size_7;
      __gen_e_acsl_initialized_8 = __e_acsl_initialized((void *)(dest_0 + 
                                                                 1 * 1),
                                                        (size_t)__gen_e_acsl_if_7);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,
                                   "(char *)dest_0",(void *)(dest_0));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_8,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_8,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_8,"size",0,
                                   __gen_e_acsl_size_7);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_8,"size",0,
                                   __gen_e_acsl_size_7);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_8,
                                   "\\initialized(&dest_0[1 .. 3])",0,
                                   __gen_e_acsl_initialized_8);
      __gen_e_acsl_assert_data_8.blocking = 1;
      __gen_e_acsl_assert_data_8.kind = "Assertion";
      __gen_e_acsl_assert_data_8.pred_txt = "!\\initialized(&dest_0[1 .. 3])";
      __gen_e_acsl_assert_data_8.file = "str.c";
      __gen_e_acsl_assert_data_8.fct = "main";
      __gen_e_acsl_assert_data_8.line = 27;
      __e_acsl_assert(! __gen_e_acsl_initialized_8,
                      & __gen_e_acsl_assert_data_8);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_8);
    }
    /*@ assert !\initialized(&dest_0[1 .. 3]); */ ;
    __e_acsl_delete_block((void *)(src_0));
    __e_acsl_delete_block((void *)(dest_0));
  }
  {
    char dest_1[4];
    __e_acsl_store_block((void *)(dest_1),4UL);
    char src_1[4] = {(char)'b', (char)'\000'};
    __e_acsl_store_block((void *)(src_1),4UL);
    __e_acsl_full_init((void *)(& src_1));
    {
      int __gen_e_acsl_size_8;
      int __gen_e_acsl_if_8;
      int __gen_e_acsl_initialized_9;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_9 =
        {.values = (void *)0};
      __gen_e_acsl_size_8 = 1 * ((3 - 0) + 1);
      if (__gen_e_acsl_size_8 <= 0) __gen_e_acsl_if_8 = 0;
      else __gen_e_acsl_if_8 = __gen_e_acsl_size_8;
      __gen_e_acsl_initialized_9 = __e_acsl_initialized((void *)(dest_1 + 
                                                                 1 * 0),
                                                        (size_t)__gen_e_acsl_if_8);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_9,
                                   "(char *)dest_1",(void *)(dest_1));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,"size",0,
                                   __gen_e_acsl_size_8);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,"size",0,
                                   __gen_e_acsl_size_8);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,
                                   "\\initialized(&dest_1[0 .. 3])",0,
                                   __gen_e_acsl_initialized_9);
      __gen_e_acsl_assert_data_9.blocking = 1;
      __gen_e_acsl_assert_data_9.kind = "Assertion";
      __gen_e_acsl_assert_data_9.pred_txt = "!\\initialized(&dest_1[0 .. 3])";
      __gen_e_acsl_assert_data_9.file = "str.c";
      __gen_e_acsl_assert_data_9.fct = "main";
      __gen_e_acsl_assert_data_9.line = 32;
      __e_acsl_assert(! __gen_e_acsl_initialized_9,
                      & __gen_e_acsl_assert_data_9);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_9);
    }
    /*@ assert !\initialized(&dest_1[0 .. 3]); */ ;
    {
      int __gen_e_acsl_size_9;
      int __gen_e_acsl_if_9;
      int __gen_e_acsl_initialized_10;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_10 =
        {.values = (void *)0};
      __gen_e_acsl_size_9 = 1 * ((3 - 0) + 1);
      if (__gen_e_acsl_size_9 <= 0) __gen_e_acsl_if_9 = 0;
      else __gen_e_acsl_if_9 = __gen_e_acsl_size_9;
      __gen_e_acsl_initialized_10 = __e_acsl_initialized((void *)(src_1 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_9);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_10,
                                   "(char *)src_1",(void *)(src_1));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_10,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_10,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_10,"size",0,
                                   __gen_e_acsl_size_9);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_10,"size",0,
                                   __gen_e_acsl_size_9);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_10,
                                   "\\initialized(&src_1[0 .. 3])",0,
                                   __gen_e_acsl_initialized_10);
      __gen_e_acsl_assert_data_10.blocking = 1;
      __gen_e_acsl_assert_data_10.kind = "Assertion";
      __gen_e_acsl_assert_data_10.pred_txt = "\\initialized(&src_1[0 .. 3])";
      __gen_e_acsl_assert_data_10.file = "str.c";
      __gen_e_acsl_assert_data_10.fct = "main";
      __gen_e_acsl_assert_data_10.line = 33;
      __e_acsl_assert(__gen_e_acsl_initialized_10,
                      & __gen_e_acsl_assert_data_10);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_10);
    }
    /*@ assert \initialized(&src_1[0 .. 3]); */ ;
    __gen_e_acsl_strncpy(dest_1,(char const *)(src_1),(size_t)3);
    {
      int __gen_e_acsl_size_10;
      int __gen_e_acsl_if_10;
      int __gen_e_acsl_initialized_11;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_11 =
        {.values = (void *)0};
      __gen_e_acsl_size_10 = 1 * ((2 - 0) + 1);
      if (__gen_e_acsl_size_10 <= 0) __gen_e_acsl_if_10 = 0;
      else __gen_e_acsl_if_10 = __gen_e_acsl_size_10;
      __gen_e_acsl_initialized_11 = __e_acsl_initialized((void *)(dest_1 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_10);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_11,
                                   "(char *)dest_1",(void *)(dest_1));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,"size",0,
                                   __gen_e_acsl_size_10);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,"size",0,
                                   __gen_e_acsl_size_10);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,
                                   "\\initialized(&dest_1[0 .. 2])",0,
                                   __gen_e_acsl_initialized_11);
      __gen_e_acsl_assert_data_11.blocking = 1;
      __gen_e_acsl_assert_data_11.kind = "Assertion";
      __gen_e_acsl_assert_data_11.pred_txt = "\\initialized(&dest_1[0 .. 2])";
      __gen_e_acsl_assert_data_11.file = "str.c";
      __gen_e_acsl_assert_data_11.fct = "main";
      __gen_e_acsl_assert_data_11.line = 36;
      __e_acsl_assert(__gen_e_acsl_initialized_11,
                      & __gen_e_acsl_assert_data_11);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_11);
    }
    /*@ assert \initialized(&dest_1[0 .. 2]); */ ;
    {
      int __gen_e_acsl_initialized_12;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_12 =
        {.values = (void *)0};
      __gen_e_acsl_initialized_12 = __e_acsl_initialized((void *)(& dest_1[3]),
                                                         sizeof(char));
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_12,
                                   "&dest_1[3]",(void *)(& dest_1[3]));
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_12,
                                     "sizeof(char)",0,sizeof(char));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_12,
                                   "\\initialized(&dest_1[3])",0,
                                   __gen_e_acsl_initialized_12);
      __gen_e_acsl_assert_data_12.blocking = 1;
      __gen_e_acsl_assert_data_12.kind = "Assertion";
      __gen_e_acsl_assert_data_12.pred_txt = "!\\initialized(&dest_1[3])";
      __gen_e_acsl_assert_data_12.file = "str.c";
      __gen_e_acsl_assert_data_12.fct = "main";
      __gen_e_acsl_assert_data_12.line = 37;
      __e_acsl_assert(! __gen_e_acsl_initialized_12,
                      & __gen_e_acsl_assert_data_12);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_12);
    }
    /*@ assert !\initialized(&dest_1[3]); */ ;
    __e_acsl_delete_block((void *)(src_1));
    __e_acsl_delete_block((void *)(dest_1));
  }
  {
    char dest_2[4];
    __e_acsl_store_block((void *)(dest_2),4UL);
    __gen_e_acsl_strcpy(dest_2,__gen_e_acsl_literal_string);
    char src_2[2] = {(char)'b', (char)'\000'};
    __e_acsl_store_block((void *)(src_2),2UL);
    __e_acsl_full_init((void *)(& src_2));
    {
      int __gen_e_acsl_size_11;
      int __gen_e_acsl_if_11;
      int __gen_e_acsl_initialized_13;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_13 =
        {.values = (void *)0};
      __gen_e_acsl_size_11 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_11 <= 0) __gen_e_acsl_if_11 = 0;
      else __gen_e_acsl_if_11 = __gen_e_acsl_size_11;
      __gen_e_acsl_initialized_13 = __e_acsl_initialized((void *)(dest_2 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_11);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_13,
                                   "(char *)dest_2",(void *)(dest_2));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_13,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_13,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_13,"size",0,
                                   __gen_e_acsl_size_11);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_13,"size",0,
                                   __gen_e_acsl_size_11);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_13,
                                   "\\initialized(&dest_2[0 .. 1])",0,
                                   __gen_e_acsl_initialized_13);
      __gen_e_acsl_assert_data_13.blocking = 1;
      __gen_e_acsl_assert_data_13.kind = "Assertion";
      __gen_e_acsl_assert_data_13.pred_txt = "\\initialized(&dest_2[0 .. 1])";
      __gen_e_acsl_assert_data_13.file = "str.c";
      __gen_e_acsl_assert_data_13.fct = "main";
      __gen_e_acsl_assert_data_13.line = 43;
      __e_acsl_assert(__gen_e_acsl_initialized_13,
                      & __gen_e_acsl_assert_data_13);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_13);
    }
    /*@ assert \initialized(&dest_2[0 .. 1]); */ ;
    {
      int __gen_e_acsl_size_12;
      int __gen_e_acsl_if_12;
      int __gen_e_acsl_initialized_14;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_14 =
        {.values = (void *)0};
      __gen_e_acsl_size_12 = 1 * ((3 - 2) + 1);
      if (__gen_e_acsl_size_12 <= 0) __gen_e_acsl_if_12 = 0;
      else __gen_e_acsl_if_12 = __gen_e_acsl_size_12;
      __gen_e_acsl_initialized_14 = __e_acsl_initialized((void *)(dest_2 + 
                                                                  1 * 2),
                                                         (size_t)__gen_e_acsl_if_12);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_14,
                                   "(char *)dest_2",(void *)(dest_2));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_14,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_14,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_14,"size",0,
                                   __gen_e_acsl_size_12);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_14,"size",0,
                                   __gen_e_acsl_size_12);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_14,
                                   "\\initialized(&dest_2[2 .. 3])",0,
                                   __gen_e_acsl_initialized_14);
      __gen_e_acsl_assert_data_14.blocking = 1;
      __gen_e_acsl_assert_data_14.kind = "Assertion";
      __gen_e_acsl_assert_data_14.pred_txt = "!\\initialized(&dest_2[2 .. 3])";
      __gen_e_acsl_assert_data_14.file = "str.c";
      __gen_e_acsl_assert_data_14.fct = "main";
      __gen_e_acsl_assert_data_14.line = 44;
      __e_acsl_assert(! __gen_e_acsl_initialized_14,
                      & __gen_e_acsl_assert_data_14);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_14);
    }
    /*@ assert !\initialized(&dest_2[2 .. 3]); */ ;
    {
      int __gen_e_acsl_size_13;
      int __gen_e_acsl_if_13;
      int __gen_e_acsl_initialized_15;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_15 =
        {.values = (void *)0};
      __gen_e_acsl_size_13 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_13 <= 0) __gen_e_acsl_if_13 = 0;
      else __gen_e_acsl_if_13 = __gen_e_acsl_size_13;
      __gen_e_acsl_initialized_15 = __e_acsl_initialized((void *)(src_2 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_13);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_15,
                                   "(char *)src_2",(void *)(src_2));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_15,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_15,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_15,"size",0,
                                   __gen_e_acsl_size_13);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_15,"size",0,
                                   __gen_e_acsl_size_13);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_15,
                                   "\\initialized(&src_2[0 .. 1])",0,
                                   __gen_e_acsl_initialized_15);
      __gen_e_acsl_assert_data_15.blocking = 1;
      __gen_e_acsl_assert_data_15.kind = "Assertion";
      __gen_e_acsl_assert_data_15.pred_txt = "\\initialized(&src_2[0 .. 1])";
      __gen_e_acsl_assert_data_15.file = "str.c";
      __gen_e_acsl_assert_data_15.fct = "main";
      __gen_e_acsl_assert_data_15.line = 45;
      __e_acsl_assert(__gen_e_acsl_initialized_15,
                      & __gen_e_acsl_assert_data_15);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_15);
    }
    /*@ assert \initialized(&src_2[0 .. 1]); */ ;
    __gen_e_acsl_strcat(dest_2,(char const *)(src_2));
    {
      int __gen_e_acsl_size_14;
      int __gen_e_acsl_if_14;
      int __gen_e_acsl_initialized_16;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_16 =
        {.values = (void *)0};
      __gen_e_acsl_size_14 = 1 * ((2 - 0) + 1);
      if (__gen_e_acsl_size_14 <= 0) __gen_e_acsl_if_14 = 0;
      else __gen_e_acsl_if_14 = __gen_e_acsl_size_14;
      __gen_e_acsl_initialized_16 = __e_acsl_initialized((void *)(dest_2 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_14);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_16,
                                   "(char *)dest_2",(void *)(dest_2));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_16,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_16,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_16,"size",0,
                                   __gen_e_acsl_size_14);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_16,"size",0,
                                   __gen_e_acsl_size_14);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_16,
                                   "\\initialized(&dest_2[0 .. 2])",0,
                                   __gen_e_acsl_initialized_16);
      __gen_e_acsl_assert_data_16.blocking = 1;
      __gen_e_acsl_assert_data_16.kind = "Assertion";
      __gen_e_acsl_assert_data_16.pred_txt = "\\initialized(&dest_2[0 .. 2])";
      __gen_e_acsl_assert_data_16.file = "str.c";
      __gen_e_acsl_assert_data_16.fct = "main";
      __gen_e_acsl_assert_data_16.line = 48;
      __e_acsl_assert(__gen_e_acsl_initialized_16,
                      & __gen_e_acsl_assert_data_16);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_16);
    }
    /*@ assert \initialized(&dest_2[0 .. 2]); */ ;
    {
      int __gen_e_acsl_initialized_17;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_17 =
        {.values = (void *)0};
      __gen_e_acsl_initialized_17 = __e_acsl_initialized((void *)(& dest_2[3]),
                                                         sizeof(char));
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_17,
                                   "&dest_2[3]",(void *)(& dest_2[3]));
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_17,
                                     "sizeof(char)",0,sizeof(char));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_17,
                                   "\\initialized(&dest_2[3])",0,
                                   __gen_e_acsl_initialized_17);
      __gen_e_acsl_assert_data_17.blocking = 1;
      __gen_e_acsl_assert_data_17.kind = "Assertion";
      __gen_e_acsl_assert_data_17.pred_txt = "!\\initialized(&dest_2[3])";
      __gen_e_acsl_assert_data_17.file = "str.c";
      __gen_e_acsl_assert_data_17.fct = "main";
      __gen_e_acsl_assert_data_17.line = 49;
      __e_acsl_assert(! __gen_e_acsl_initialized_17,
                      & __gen_e_acsl_assert_data_17);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_17);
    }
    /*@ assert !\initialized(&dest_2[3]); */ ;
    __e_acsl_delete_block((void *)(src_2));
    __e_acsl_delete_block((void *)(dest_2));
  }
  {
    char dest_3[4];
    __e_acsl_store_block((void *)(dest_3),4UL);
    __gen_e_acsl_strcpy(dest_3,__gen_e_acsl_literal_string);
    char src_3[3] = {(char)'b', (char)'c', (char)'\000'};
    __e_acsl_store_block((void *)(src_3),3UL);
    __e_acsl_full_init((void *)(& src_3));
    {
      int __gen_e_acsl_size_15;
      int __gen_e_acsl_if_15;
      int __gen_e_acsl_initialized_18;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_18 =
        {.values = (void *)0};
      __gen_e_acsl_size_15 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_15 <= 0) __gen_e_acsl_if_15 = 0;
      else __gen_e_acsl_if_15 = __gen_e_acsl_size_15;
      __gen_e_acsl_initialized_18 = __e_acsl_initialized((void *)(dest_3 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_15);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_18,
                                   "(char *)dest_3",(void *)(dest_3));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_18,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_18,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_18,"size",0,
                                   __gen_e_acsl_size_15);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_18,"size",0,
                                   __gen_e_acsl_size_15);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_18,
                                   "\\initialized(&dest_3[0 .. 1])",0,
                                   __gen_e_acsl_initialized_18);
      __gen_e_acsl_assert_data_18.blocking = 1;
      __gen_e_acsl_assert_data_18.kind = "Assertion";
      __gen_e_acsl_assert_data_18.pred_txt = "\\initialized(&dest_3[0 .. 1])";
      __gen_e_acsl_assert_data_18.file = "str.c";
      __gen_e_acsl_assert_data_18.fct = "main";
      __gen_e_acsl_assert_data_18.line = 55;
      __e_acsl_assert(__gen_e_acsl_initialized_18,
                      & __gen_e_acsl_assert_data_18);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_18);
    }
    /*@ assert \initialized(&dest_3[0 .. 1]); */ ;
    {
      int __gen_e_acsl_size_16;
      int __gen_e_acsl_if_16;
      int __gen_e_acsl_initialized_19;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_19 =
        {.values = (void *)0};
      __gen_e_acsl_size_16 = 1 * ((3 - 2) + 1);
      if (__gen_e_acsl_size_16 <= 0) __gen_e_acsl_if_16 = 0;
      else __gen_e_acsl_if_16 = __gen_e_acsl_size_16;
      __gen_e_acsl_initialized_19 = __e_acsl_initialized((void *)(dest_3 + 
                                                                  1 * 2),
                                                         (size_t)__gen_e_acsl_if_16);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_19,
                                   "(char *)dest_3",(void *)(dest_3));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_19,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_19,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_19,"size",0,
                                   __gen_e_acsl_size_16);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_19,"size",0,
                                   __gen_e_acsl_size_16);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_19,
                                   "\\initialized(&dest_3[2 .. 3])",0,
                                   __gen_e_acsl_initialized_19);
      __gen_e_acsl_assert_data_19.blocking = 1;
      __gen_e_acsl_assert_data_19.kind = "Assertion";
      __gen_e_acsl_assert_data_19.pred_txt = "!\\initialized(&dest_3[2 .. 3])";
      __gen_e_acsl_assert_data_19.file = "str.c";
      __gen_e_acsl_assert_data_19.fct = "main";
      __gen_e_acsl_assert_data_19.line = 56;
      __e_acsl_assert(! __gen_e_acsl_initialized_19,
                      & __gen_e_acsl_assert_data_19);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_19);
    }
    /*@ assert !\initialized(&dest_3[2 .. 3]); */ ;
    {
      int __gen_e_acsl_size_17;
      int __gen_e_acsl_if_17;
      int __gen_e_acsl_initialized_20;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_20 =
        {.values = (void *)0};
      __gen_e_acsl_size_17 = 1 * ((2 - 0) + 1);
      if (__gen_e_acsl_size_17 <= 0) __gen_e_acsl_if_17 = 0;
      else __gen_e_acsl_if_17 = __gen_e_acsl_size_17;
      __gen_e_acsl_initialized_20 = __e_acsl_initialized((void *)(src_3 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_17);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_20,
                                   "(char *)src_3",(void *)(src_3));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_20,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_20,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_20,"size",0,
                                   __gen_e_acsl_size_17);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_20,"size",0,
                                   __gen_e_acsl_size_17);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_20,
                                   "\\initialized(&src_3[0 .. 2])",0,
                                   __gen_e_acsl_initialized_20);
      __gen_e_acsl_assert_data_20.blocking = 1;
      __gen_e_acsl_assert_data_20.kind = "Assertion";
      __gen_e_acsl_assert_data_20.pred_txt = "\\initialized(&src_3[0 .. 2])";
      __gen_e_acsl_assert_data_20.file = "str.c";
      __gen_e_acsl_assert_data_20.fct = "main";
      __gen_e_acsl_assert_data_20.line = 57;
      __e_acsl_assert(__gen_e_acsl_initialized_20,
                      & __gen_e_acsl_assert_data_20);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_20);
    }
    /*@ assert \initialized(&src_3[0 .. 2]); */ ;
    __gen_e_acsl_strncat(dest_3,(char const *)(src_3),(size_t)1);
    {
      int __gen_e_acsl_size_18;
      int __gen_e_acsl_if_18;
      int __gen_e_acsl_initialized_21;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_21 =
        {.values = (void *)0};
      __gen_e_acsl_size_18 = 1 * ((2 - 0) + 1);
      if (__gen_e_acsl_size_18 <= 0) __gen_e_acsl_if_18 = 0;
      else __gen_e_acsl_if_18 = __gen_e_acsl_size_18;
      __gen_e_acsl_initialized_21 = __e_acsl_initialized((void *)(dest_3 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_18);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_21,
                                   "(char *)dest_3",(void *)(dest_3));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_21,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_21,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_21,"size",0,
                                   __gen_e_acsl_size_18);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_21,"size",0,
                                   __gen_e_acsl_size_18);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_21,
                                   "\\initialized(&dest_3[0 .. 2])",0,
                                   __gen_e_acsl_initialized_21);
      __gen_e_acsl_assert_data_21.blocking = 1;
      __gen_e_acsl_assert_data_21.kind = "Assertion";
      __gen_e_acsl_assert_data_21.pred_txt = "\\initialized(&dest_3[0 .. 2])";
      __gen_e_acsl_assert_data_21.file = "str.c";
      __gen_e_acsl_assert_data_21.fct = "main";
      __gen_e_acsl_assert_data_21.line = 60;
      __e_acsl_assert(__gen_e_acsl_initialized_21,
                      & __gen_e_acsl_assert_data_21);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_21);
    }
    /*@ assert \initialized(&dest_3[0 .. 2]); */ ;
    {
      int __gen_e_acsl_initialized_22;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_22 =
        {.values = (void *)0};
      __gen_e_acsl_initialized_22 = __e_acsl_initialized((void *)(& dest_3[3]),
                                                         sizeof(char));
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_22,
                                   "&dest_3[3]",(void *)(& dest_3[3]));
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_22,
                                     "sizeof(char)",0,sizeof(char));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_22,
                                   "\\initialized(&dest_3[3])",0,
                                   __gen_e_acsl_initialized_22);
      __gen_e_acsl_assert_data_22.blocking = 1;
      __gen_e_acsl_assert_data_22.kind = "Assertion";
      __gen_e_acsl_assert_data_22.pred_txt = "!\\initialized(&dest_3[3])";
      __gen_e_acsl_assert_data_22.file = "str.c";
      __gen_e_acsl_assert_data_22.fct = "main";
      __gen_e_acsl_assert_data_22.line = 61;
      __e_acsl_assert(! __gen_e_acsl_initialized_22,
                      & __gen_e_acsl_assert_data_22);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_22);
    }
    /*@ assert !\initialized(&dest_3[3]); */ ;
    __e_acsl_delete_block((void *)(src_3));
    __e_acsl_delete_block((void *)(dest_3));
  }
  {
    char dest_4[4];
    __e_acsl_store_block((void *)(dest_4),4UL);
    __gen_e_acsl_strcpy(dest_4,__gen_e_acsl_literal_string);
    char src_4[2] = {(char)'b', (char)'\000'};
    __e_acsl_store_block((void *)(src_4),2UL);
    __e_acsl_full_init((void *)(& src_4));
    {
      int __gen_e_acsl_size_19;
      int __gen_e_acsl_if_19;
      int __gen_e_acsl_initialized_23;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_23 =
        {.values = (void *)0};
      __gen_e_acsl_size_19 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_19 <= 0) __gen_e_acsl_if_19 = 0;
      else __gen_e_acsl_if_19 = __gen_e_acsl_size_19;
      __gen_e_acsl_initialized_23 = __e_acsl_initialized((void *)(dest_4 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_19);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_23,
                                   "(char *)dest_4",(void *)(dest_4));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_23,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_23,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_23,"size",0,
                                   __gen_e_acsl_size_19);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_23,"size",0,
                                   __gen_e_acsl_size_19);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_23,
                                   "\\initialized(&dest_4[0 .. 1])",0,
                                   __gen_e_acsl_initialized_23);
      __gen_e_acsl_assert_data_23.blocking = 1;
      __gen_e_acsl_assert_data_23.kind = "Assertion";
      __gen_e_acsl_assert_data_23.pred_txt = "\\initialized(&dest_4[0 .. 1])";
      __gen_e_acsl_assert_data_23.file = "str.c";
      __gen_e_acsl_assert_data_23.fct = "main";
      __gen_e_acsl_assert_data_23.line = 67;
      __e_acsl_assert(__gen_e_acsl_initialized_23,
                      & __gen_e_acsl_assert_data_23);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_23);
    }
    /*@ assert \initialized(&dest_4[0 .. 1]); */ ;
    {
      int __gen_e_acsl_size_20;
      int __gen_e_acsl_if_20;
      int __gen_e_acsl_initialized_24;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_24 =
        {.values = (void *)0};
      __gen_e_acsl_size_20 = 1 * ((3 - 2) + 1);
      if (__gen_e_acsl_size_20 <= 0) __gen_e_acsl_if_20 = 0;
      else __gen_e_acsl_if_20 = __gen_e_acsl_size_20;
      __gen_e_acsl_initialized_24 = __e_acsl_initialized((void *)(dest_4 + 
                                                                  1 * 2),
                                                         (size_t)__gen_e_acsl_if_20);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_24,
                                   "(char *)dest_4",(void *)(dest_4));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_24,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_24,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_24,"size",0,
                                   __gen_e_acsl_size_20);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_24,"size",0,
                                   __gen_e_acsl_size_20);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_24,
                                   "\\initialized(&dest_4[2 .. 3])",0,
                                   __gen_e_acsl_initialized_24);
      __gen_e_acsl_assert_data_24.blocking = 1;
      __gen_e_acsl_assert_data_24.kind = "Assertion";
      __gen_e_acsl_assert_data_24.pred_txt = "!\\initialized(&dest_4[2 .. 3])";
      __gen_e_acsl_assert_data_24.file = "str.c";
      __gen_e_acsl_assert_data_24.fct = "main";
      __gen_e_acsl_assert_data_24.line = 68;
      __e_acsl_assert(! __gen_e_acsl_initialized_24,
                      & __gen_e_acsl_assert_data_24);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_24);
    }
    /*@ assert !\initialized(&dest_4[2 .. 3]); */ ;
    {
      int __gen_e_acsl_size_21;
      int __gen_e_acsl_if_21;
      int __gen_e_acsl_initialized_25;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_25 =
        {.values = (void *)0};
      __gen_e_acsl_size_21 = 1 * ((1 - 0) + 1);
      if (__gen_e_acsl_size_21 <= 0) __gen_e_acsl_if_21 = 0;
      else __gen_e_acsl_if_21 = __gen_e_acsl_size_21;
      __gen_e_acsl_initialized_25 = __e_acsl_initialized((void *)(src_4 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_21);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_25,
                                   "(char *)src_4",(void *)(src_4));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_25,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_25,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_25,"size",0,
                                   __gen_e_acsl_size_21);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_25,"size",0,
                                   __gen_e_acsl_size_21);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_25,
                                   "\\initialized(&src_4[0 .. 1])",0,
                                   __gen_e_acsl_initialized_25);
      __gen_e_acsl_assert_data_25.blocking = 1;
      __gen_e_acsl_assert_data_25.kind = "Assertion";
      __gen_e_acsl_assert_data_25.pred_txt = "\\initialized(&src_4[0 .. 1])";
      __gen_e_acsl_assert_data_25.file = "str.c";
      __gen_e_acsl_assert_data_25.fct = "main";
      __gen_e_acsl_assert_data_25.line = 69;
      __e_acsl_assert(__gen_e_acsl_initialized_25,
                      & __gen_e_acsl_assert_data_25);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_25);
    }
    /*@ assert \initialized(&src_4[0 .. 1]); */ ;
    __gen_e_acsl_strncat(dest_4,(char const *)(src_4),(size_t)2);
    {
      int __gen_e_acsl_size_22;
      int __gen_e_acsl_if_22;
      int __gen_e_acsl_initialized_26;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_26 =
        {.values = (void *)0};
      __gen_e_acsl_size_22 = 1 * ((2 - 0) + 1);
      if (__gen_e_acsl_size_22 <= 0) __gen_e_acsl_if_22 = 0;
      else __gen_e_acsl_if_22 = __gen_e_acsl_size_22;
      __gen_e_acsl_initialized_26 = __e_acsl_initialized((void *)(dest_4 + 
                                                                  1 * 0),
                                                         (size_t)__gen_e_acsl_if_22);
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_26,
                                   "(char *)dest_4",(void *)(dest_4));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_26,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_26,
                                   "sizeof(char)",0,1);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_26,"size",0,
                                   __gen_e_acsl_size_22);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_26,"size",0,
                                   __gen_e_acsl_size_22);
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_26,
                                   "\\initialized(&dest_4[0 .. 2])",0,
                                   __gen_e_acsl_initialized_26);
      __gen_e_acsl_assert_data_26.blocking = 1;
      __gen_e_acsl_assert_data_26.kind = "Assertion";
      __gen_e_acsl_assert_data_26.pred_txt = "\\initialized(&dest_4[0 .. 2])";
      __gen_e_acsl_assert_data_26.file = "str.c";
      __gen_e_acsl_assert_data_26.fct = "main";
      __gen_e_acsl_assert_data_26.line = 72;
      __e_acsl_assert(__gen_e_acsl_initialized_26,
                      & __gen_e_acsl_assert_data_26);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_26);
    }
    /*@ assert \initialized(&dest_4[0 .. 2]); */ ;
    {
      int __gen_e_acsl_initialized_27;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_27 =
        {.values = (void *)0};
      __gen_e_acsl_initialized_27 = __e_acsl_initialized((void *)(& dest_4[3]),
                                                         sizeof(char));
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_27,
                                   "&dest_4[3]",(void *)(& dest_4[3]));
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_27,
                                     "sizeof(char)",0,sizeof(char));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_27,
                                   "\\initialized(&dest_4[3])",0,
                                   __gen_e_acsl_initialized_27);
      __gen_e_acsl_assert_data_27.blocking = 1;
      __gen_e_acsl_assert_data_27.kind = "Assertion";
      __gen_e_acsl_assert_data_27.pred_txt = "!\\initialized(&dest_4[3])";
      __gen_e_acsl_assert_data_27.file = "str.c";
      __gen_e_acsl_assert_data_27.fct = "main";
      __gen_e_acsl_assert_data_27.line = 73;
      __e_acsl_assert(! __gen_e_acsl_initialized_27,
                      & __gen_e_acsl_assert_data_27);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_27);
    }
    /*@ assert !\initialized(&dest_4[3]); */ ;
    __e_acsl_delete_block((void *)(src_4));
    __e_acsl_delete_block((void *)(dest_4));
  }
  __retres = 0;
  __e_acsl_memory_clean();
  return __retres;
}


