# ==============================================================================
# Create NLS catalogs
#
# Copyright (c) 2012-2013 by the developers. See the LICENSE file for details.
#
# The numbering is taken from 'string_table'. The localized strings are taken
# from the translation files in the 'L10n' subdirectory. A NLS mesage file and
# a NLS catalog file is created for every translation file found in the 'L10n'
# subdirectory


# ==============================================================================
# Generate header of NLS message file

BEGIN \
{
   # Get name of translation file
   fn = ENVIRON["NLS_TRANSLATION"]
   if("" == fn)  exit(1)

   # Message file header
   printf("$ This file was generated automatically - do not edit\n")
   printf("$quote \"\n")
}


# ==============================================================================
# Search every string from table in translation file and create NLS message

{
   if(match($0, /^".*"/))
   {
      # Original (not translated) string found
      orig = substr($0, RSTART, RLENGTH)
      # Extract number
      sno = substr($0, RSTART + RLENGTH)
      if(match(sno, /[ ]*[0123456789]*/))
      {
         no = substr(sno, RSTART, RLENGTH) + 0
      }
      transl = search_translation(orig)
      printf("%d %s\n", no, transl)
   }
   next
}


# ==============================================================================
# Search translation for string 's'
# The parameter 's' is returned if nothing was found

function search_translation(s) \
{
   # Open file
   if(-1 == getline cur <fn)  exit(1)

   # Search string
   do
   {
      if(match(cur, /^"[^"]*"/))
      {
         # String found => Check whether it is the searched one
         if(substr(cur, RSTART, RLENGTH) == s)
         {
            # Yes => Extract translation
            tl = substr(cur, RSTART + RLENGTH)
            if(match(tl, /".*"/))
            {
               translation = substr(tl, RSTART, RLENGTH)
               if(close(fn))  exit(1)

               # Return translated string
               return(translation)
            }
         }
      }
   }
   while(1 == getline cur <fn)

   # Translation not found
   # Close file
   if(close(fn))  exit(1)
   # Return original string
   return(s)
}


# EOF
