# ==============================================================================
# Extract NLS information from preprocessed source files
#
# Copyright (c) 2012-2013 by the developers. See the LICENSE file for details.
#
# Note that this simple regex may fail: /NLS_STRING\("[^)]*"\)/
# Some preprocessors replace 'S("string")' with
# 'NLS_STRING( "string" )' or 'NLS_STRING ( "string" )'


# ==============================================================================
# Extrakt all comments that are marked as NLS_COMMENT("Comment")

{
   pos = 1
   do
   {
      matched_exp = substr($0, pos)
      #printf("%s\n", matched_exp)
      # Search for 'NLS_COMMENT()'
      rv = match(matched_exp, /NLS_COMMENT[ ]*\([ ]*"[^)]*"[ ]*\)/)
      if (rv)
      {
         matched_exp = substr(matched_exp, RSTART, RLENGTH)
         #printf("%s\n", matched_exp)
         # Set position to rest of line
         pos = pos - 1 + RSTART + RLENGTH

         # Extrakt parameter of 'NLS_COMMENT()'
         if (match(matched_exp, /".*"/))
         {
            str = substr(matched_exp, RSTART, RLENGTH)
            # Remove quotes
            str = substr(str, 2, RLENGTH - 2)
            if (0 == length(str))  printf("\n")
            else  printf("$ %s\n", str)
         }
      }
   }
   while(rv != 0)
}


# ==============================================================================
# Extrakt all strings that are marked as NLS_STRING("String")

{
   pos = 1
   do
   {
      matched_exp = substr($0, pos)
      #printf("%s\n", matched_exp)
      # Search for 'NLS_STRING()'
      rv = match(matched_exp, /NLS_STRING[ ]*\([ ]*"[^)]*"[ ]*\)/)
      if (rv)
      {
         matched_exp = substr(matched_exp, RSTART, RLENGTH)
         #printf("%s\n", matched_exp)
         # Set position to rest of line
         pos = pos - 1 + RSTART + RLENGTH

         # Extrakt parameter of 'NLS_STRING()'
         if (match(matched_exp, /".*"/))
         {
            str = substr(matched_exp, RSTART, RLENGTH)
            printf("%s\n", str)
         }
      }
   }
   while(rv != 0)
}


# EOF
