# ==============================================================================
# First sublevel Makefile torso
#
# Copyright (c) 2012-2016 by the developers. See the LICENSE file for details.


# ==============================================================================
# Clear suffix list for inference rules

.SUFFIXES:


# ==============================================================================
# Prebuild rules

# Clean source tree
clean:
	-$(UTIL_RM) -f bin/*
	-$(UTIL_RM) -f *.o
	-$(UTIL_RM) -f bdate.c
	-$(UTIL_RM) -f depend.mk
	-$(UTIL_RM) -f build1.mk
	-$(UTIL_RM) -f build2.mk
	-$(UTIL_RM) -f Doxyfile
	-$(UTIL_RM) -f .gui_nls.cxx
	-$(UTIL_RM) -f uc_*.c
	-$(UTIL_RM) -f iso2022*.c
	-$(UTIL_RM) -f doc/*.1.html
	-$(UTIL_RM) -f doc/html/*
	-$(UTIL_RM) -f doc/latex/*
	-$(UTIL_RM) -f nls/.tmp
	-$(UTIL_RM) -f nls/.nls_switch
	-$(UTIL_RM) -f nls/.nls_support
	-$(UTIL_RM) -f nls/.nls_catalogs
	-$(UTIL_RM) -f nls/L10n/*.msg
	-$(UTIL_RM) -f nls/L10n/*.cat

# Rule to build second sublevel Makefile (that contains the dependencies)
build2.mk: build1.mk mk/config.mk mk/rules.mk bdate.c uc_v.c uc_cdc.c uc_hst.c \
           uc_qc_nfc.c uc_test_nfc.c uc_fce.c uc_cf.c iso2022-jp.c
	@printf "Create dependencies ...\n"
	@printf "# =======================================" >depend.mk
	@printf "=========================================\n" >>depend.mk
	printf "# Dependencies created by build1.mk\n\n" >>depend.mk
	export LC_ALL=POSIX ; for file in *; \
           do \
              case $$file in \
              *.c)    set -e ; $(CC_DEP_COMMAND) >>depend.mk ; \
                      printf "\n"    >>depend.mk \
                      ;; \
              *.cxx)  set -e ; $(CXX_DEP_COMMAND) >>depend.mk ; \
                      printf "\n"    >>depend.mk \
                      ;; \
              esac ; \
           done
	@printf "\n# EOF\n" >>depend.mk
	$(UTIL_CAT) mk/config.mk mk/rules.mk depend.mk >build2.mk
	$(UTIL_RM) depend.mk

# Create source file with compile date constant
# For reproducible builds the date can be specified with the SOURCE_DATE_EPOCH
# environemnt variable (set to seconds since epoch).
bdate.c:
	@printf "Store build date ...\n"
	printf "/* ISO 8601 conformant build date created by build1.mk */\n" >$@
	printf "%s\n" "#include \"bdate.h\"" >>$@
	printf "%s" "const char  BDATE[] = \"" >>$@
	printf "%s" "$(DATE_TIME)" >>$@
	printf "\";\n\n\n/* EOF */\n" >>$@

# Create Unicode version definition
uc_v.c:
	@printf "Store Unicode version ...\n"
	printf "/* Unicode standard version created by build1.mk */\n" >$@
	printf "%s" "#define UC_VERSION  \"" >>$@
	export LC_ALL=POSIX ; $(UTIL_CAT) uc/VERSION >>$@
	printf "\"\n\n\n/* EOF */\n" >>$@

# Create Unicode decomposition table
uc_cdc.c:
	@printf "Create Unicode canonical decomposition table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_cdc_create.awk uc/UnicodeData.txt >$@

# Create Unicode hangul syllable type table
uc_hst.c:
	@printf "Create Unicode hangul syllable type table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_hst_create.awk uc/HangulSyllableType.txt >$@

# Create Unicode NFC quick check table
uc_qc_nfc.c:
	@printf "Create Unicode NFC quick check table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_qc_nfc_create.awk \
           uc/DerivedNormalizationProps.txt >$@

# Create Unicode NFC test data
uc_test_nfc.c:
	@printf "Create Unicode NFC test data ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_test_nfc_create.awk \
           uc/NormalizationTest.txt >$@

# Create Unicode full composition exclusions table
uc_fce.c:
	@printf "Create Unicode full composititon exclusions table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_fce_create.awk \
           uc/DerivedNormalizationProps.txt >$@

# Create Unicode default case folding table
uc_cf.c:
	@printf "Create Unicode default case folding table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -F ';' -f uc_cf_create.awk \
           uc/CaseFolding.txt >$@

# Create ISO 2022-JP to Unicode mapping table
iso2022-jp.c:
	@printf "Create ISO 2022-JP to Unicode mapping table ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_AWK) -f iso2022-jp_create.awk iso2022-jp/iso-2022-jp.txt >$@


# EOF
