# ==============================================================================
# Convert configfile from flnews major versions 0 to 1 semantics
#
# Copyright (c) 2021 by the developers. See the LICENSE file for details.

/^#/

/^[^#]/ \
{
   if (match($0, /^domain:/))
   {
      # Entry "domain" found
      domain = substr($0, RSTART + RLENGTH + 1)
      if (0 == length(domain))
      {
         # Create empty "fqdn" entry
         print "fqdn: "
      }
      else
      {
         # Convert to "fqdn" semantics by prepending nodename
         nodename = ENVIRON["CFG_NODENAME"]
         print "fqdn: " nodename "." domain
      }
   }
   else
   {
      # Do not modify other entries
      print
   }
}


# EOF
