#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/filename.H>
#include <FL/x.H>

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#ifdef WIN32
	#include "fl_logbookrc.h"
#else
	#include <pwd.h>
	#include "ipcdata.h"
#endif

#include <string>
#include "adif_io.h"
#include "multipsklog.h"
#include "lgbook.h"
#include "support.h"
#include "fileio.h"

using namespace std;
#ifndef WIN32
char homedir[120] = "";
#else
char homedir[] = "c:/FL_LOGBOOK/";
#endif

void cb_Main(Fl_Widget *, void *)
{
   cleanExit();
}

int main (int argc, char *argv[])
{
	Fl_Window * window = create_main();
#ifdef WIN32
	strcpy(logfile, homedir); 
	strcat(logfile,"logbook.lgb");
	FILE *testfile = fopen(logfile,"r");
	if (!testfile)
		mkdir( homedir );
	else
		fclose( testfile );
#else
	strcpy(logfile, homedir); strcat(logfile,"logbook.lgb");
	FILE *testfile = fopen(logfile,"r");
	if (!testfile)
		mkdir( homedir, S_IRUSR | S_IWUSR | S_IXUSR);
	else
		fclose(testfile);
#endif
	if (argc == 2) 
		strcpy(logfile, argv[1]);
	else {
		strcpy(logfile, homedir);
		strcat(logfile, "logbook.lgb");
	}

	window->callback(cb_Main);
#ifdef WIN32
	window->icon((char *)LoadIcon(fl_display, MAKEINTRESOURCE(IDI_ICON)));
	window->show (argc, argv);
#else
	window->show();
#endif

	if(qsodb.qsoReadFile(logfile) == 0)
		loadBrowser();
	qsodb.isdirty(0);

#ifndef WIN32
	setup_ipc_data();
#else
	setup_fileio();
#endif

	return Fl::run();
}
