// @(#) $Id: output.cc,v 1.2 2003/08/05 00:25:30 balu Exp $

#include "output.h"
#include <iostream>

void Output::flush()
{
for(Buffer::iterator i=buffer.begin();i!=buffer.end();i++)
   if(i->length!=0)
     {
     for(Replacement::iterator j=i->replacement.begin();
         j!=i->replacement.end();j++)
        writeLine(*j);
     i+=i->length-1;
     }
   else
     writeLine(i->value);
buffer.clear();
}

void Output::writeLine(const string &s) const
{
cout<<s<<endl;
}

Output::Output():
        suspended(0)
{
}

void Output::putLine(const string &s)
{
if(suspended>0)
  {
  Line line={s};
  buffer.push_back(line);
  }
else
  writeLine(s);
}

void Output::suspend()
{
suspended++;
}

void Output::resume()
{
suspended--;
if(suspended==0)
  flush();
}

int Output::tell() const
{
return buffer.size();
}

void Output::replace(int pos,int len,const string &s)
{
Buffer::iterator p=buffer.begin()+pos;
p->length=len;
p->replacement.push_back(s);
}

void Output::replace(int pos,int len,const Replacement &r)
{
Buffer::iterator p=buffer.begin()+pos;
p->length=len;
p->replacement=r;
}
