/*
 * Generic utility-functions, macros and defaults
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#include "th_util.h"
#include <stdio.h>

/*
 * Default settings
 */
#define	TH_PROG_NAME		"program"
#define	TH_PROG_FULLNAME	"A Program"
#define TH_PROG_VERSION		"0.0.0"
#define TH_PROG_AUTHOR		"By Matti 'ccr' Hmlinen (C) Copyright 2004 TNSP"
#define TH_PROG_LICENSE		"This software is licensed under GNU GPL version 2"

BOOL	th_isInitialized = FALSE;
int	th_verbosityLevel = 2;
char	*th_prog_name = NULL,
	*th_prog_fullname = NULL,
	*th_prog_version = NULL,
	*th_prog_author = NULL,
	*th_prog_license = NULL;


void th_init(
	char *progName, char *progFullName, char *progVersion,
	char *progAuthor, char *progLicense)
{
 /* Free previous values */
 if (progName)
 	th_prog_name = progName;
 	else
 	th_prog_name = TH_PROG_NAME;

 if (progFullName)
 	th_prog_fullname = progFullName;
 	else
 	th_prog_fullname = TH_PROG_FULLNAME;
 
 if (progVersion)
 	th_prog_version = progVersion;
 	else
 	th_prog_version = TH_PROG_VERSION;
 
 if (progAuthor)
 	th_prog_author = progAuthor;
 	else
 	th_prog_author = TH_PROG_AUTHOR;

 if (progLicense)
 	th_prog_license = progLicense;
 	else
 	th_prog_license = TH_PROG_LICENSE;

 th_isInitialized = TRUE;
}


void THERR(const char *pcFormat, ...)
{
 va_list ap;
 assert(th_isInitialized);
 
 va_start(ap, pcFormat);
 fprintf(stderr, "%s: ", th_prog_name);
 vfprintf(stderr, pcFormat, ap);
 va_end(ap);
}


void THMSG(int verbLevel, const char *pcFormat, ...)
{
 va_list ap;
 assert(th_isInitialized);

 /* Check if the current verbosity level is enough */
 if (th_verbosityLevel >= verbLevel)
 	{
 	/* Print message */
	va_start(ap, pcFormat);
	fprintf(stderr, "%s: ", th_prog_name);
	vfprintf(stderr, pcFormat, ap);
	va_end(ap);
	}
}


void THPRINT(int verbLevel, const char *pcFormat, ...)
{
 va_list ap;
 assert(th_isInitialized);

 /* Check if the current verbosity level is enough */
 if (th_verbosityLevel >= verbLevel)
 	{
 	/* Print message */
	va_start(ap, pcFormat);
	vfprintf(stderr, pcFormat, ap);
	va_end(ap);
	}
}


