/*
 * Miscellaneous string-handling related utility-functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _TH_STRING_H
#define _TH_STRING_H

#include "th_util.h"
#include <stdlib.h>
#include <ctype.h>

#define SET_HASH_MAXINDEX	(256)

/*
 * Macros
 */
#define th_isalnum(c)	(isalnum((int)(unsigned char) c)||(c=='')||(c=='')||(c=='')||(c=='')||(c=='')||(c==''))
#define th_isalpha(c)	(isalpha((int)(unsigned char) c)||(c=='')||(c=='')||(c=='')||(c=='')||(c=='')||(c==''))
#define th_isascii(c)	isascii((int)(unsigned char) c)
#define th_isblank(c)	isblank((int)(unsigned char) c)
#define th_iscntrl(c)	iscntrl((int)(unsigned char) c)
#define th_isdigit(c)	isdigit((int)(unsigned char) c)
#define th_isgraph(c)	isgraph((int)(unsigned char) c)
#define th_islower(c)	(islower((int)(unsigned char) c)||(c=='')||(c=='')||(c==''))
#define th_isprint(c)	isprint((int)(unsigned char) c)
#define th_ispunct(c)	ispunct((int)(unsigned char) c)
#define th_isspace(c)	isspace((int)(unsigned char) c)
#define th_isupper(c)	(isupper((int)(unsigned char) c)||(c=='')||(c=='')||(c==''))
#define th_isxdigit(c)	isxdigit((int)(unsigned char) c)
#define th_iscrlf(c)	((c=='\r')||(c=='\n'))

#define th_isspecial(q)	(((q >= 0x5b) && (q <= 0x60)) || ((q >= 0x7b) && (q <= 0x7d)))


/*
 * Typedefs and structures
 */
typedef struct tstrnode {
	char	*pcStr;		/* String */
	t_ulint	nUsed;		/* Times this string has been referenced */
	void	*pData;		/* Extra data */
	
	struct tstrnode *pPrev, *pNext;
} t_str_node;


typedef t_str_node *t_str_hash[SET_HASH_MAXINDEX];


typedef struct tstrindex {
	t_str_node	**ppIndex;
	t_ulint		n;
} t_str_index;


/*
 * Normal NUL-terminated string functions
 */
int	th_strcpy(char **, const char *);
int	th_strcat(char **, const char *);
char	*th_strdup(const char *);

char	*th_findnext(char *, size_t *);
char	*th_findsep(char *, size_t *, char);
char	*th_findseporspace(char *, size_t *, char);

BOOL	th_strmatch(char *, char *);
BOOL	th_strcasematch(char *, char *);

int	th_tolower(int);
int	th_toupper(int);
int	th_strcasecmp(char *, char *);

void	th_strip_ctrlchars(char *);


/*
 * Handling of string-lists and hashes
 */
t_str_node *	th_strnode_new(char *, t_ulint, void *);
void		th_strnode_free(t_str_node *);
void		th_strlist_free(t_str_node *);
void		th_strlist_insert(t_str_node **, t_str_node *);
int		th_strhash_insert(t_str_node **, t_str_node *, BOOL);
void		th_strhash_free(t_str_node **);
void		th_strhash_change_pdata(t_str_hash, void *, void *);
t_str_node *	th_strhash_search(t_str_node **, char *, BOOL);
t_str_index *	th_strhash_makeindex(t_str_node **);
t_str_index *	th_strlist_makeindex(t_str_node *);
void		th_strindex_free(t_str_index *);
void		th_strindex_sort_nused(t_str_index *);
void		th_strindex_sort_alpha(t_str_index *);

#endif /* _TH_STRING_H */
