/*
 * FISG - Input Formats
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#include "fisg.h"
#include "in_formats.h"

/*
 * List of pre-defined input formats
 */
t_logformat	inputFormats[] = {

	{ "irssi", "Handles the DEFAULT Irssi-style logs",
		"%H:%M <%@%n> %t",
		"%H:%M -%n:%c- %t",
		"%H:%M  * %n %t",
		"%H:%M -!- mode/%c [%m] by %n",
		"%H:%M -!- %n [%*] has joined %c",
		"%H:%M -!- %n [%*] has left %c",
		"%H:%M -!- %n [%*] has quit ",
		"%H:%M -!- %n was kicked from %c by %N",
		"%H:%M -!- %n is now known as %N",
		"%H:%M -!- %n changed the topic of %c to: %t",
		"--- Day changed"
	},
	
	{ "eggdrop", "Eggdrop log-format",
		"[%H:%M] <%n> %t",
		NULL,
		"[%H:%M] Action: %n %t",
		"[%H:%M] %c: mode change '%m' by %n!",
		"[%H:%M] %n (%*) joined %c",
		"[%H:%M] %n (%*) left %c (",
		"[%H:%M] %n (%*) left irc:",
		"[%H:%M] %n kicked from %c by %N:",
		"[%H:%M] Nick change: %n -> %N",
		"[%H:%M] Topic changed on %c by %n!%*: %t",
		"[%H:%M] ---"
	},

	{ "emech", "Energymech log-format",
		"[%H:%M] <%n> %t",
		"[%H:%M] -%n:%*- %t",
		"[%H:%M] * %n %t",
		"[%H:%M] *** %n sets mode: %m ",
		"[%H:%M] *** Joins: %n (%*)",
		"[%H:%M] *** Parts: %n (%*)",
		"[%H:%M] *** Quits: %n (%*)",
		"[%H:%M] *** %n was kicked by %N (%*)",
		"[%H:%M] *** %n is now known as %N",
		NULL,
		NULL
	},

	{ "mirc", "mIRC basic log-format",
		"[%H:%M:%S] <%n> %t",
		"[%H:%M:%S] -%n- %t",
		"[%H:%M:%S] Action: %n",
		"[%H:%M:%S] * %n sets mode: %m",
		"[%H:%M:%S] * Joins: %n",
		"[%H:%M:%S] %n (%*) ",
		"[%H:%M:%S] %n (%*) left irc:  ",
		"[%H:%M:%S] %n kicked from %c by %N:",
		"[%H:%M:%S] Nick change: %n -> %N",
		"[%H:%M:%S] * %n changes topic to %t",
		NULL
	},

	{ "bitchx", "Does not work :)",
		"\x1b%*m<\x1b%*m%n\x1b%*m:\x1b%*m%c\x1b%*m>\x1b%*m %t\x1b",
		"-%n:%c- %t",
		"%H:%M  * %n %t",
		"%H:%M -!- mode/%c [%m] by %n",
		"%H:%M -!- %n [%*] has joined %c",
		"%H:%M -!- %n [%*] has left %c",
		"%H:%M -!- %n [%*] has quit ",
		"%H:%M -!- %n was kicked from %c by %N",
		"%H:%M -!- %n is now known as %N",
		"%H:%M -!- %n changed the topic of %c to: %t",
		"--- Day changed"
	},

	{ "irssi-th", "Handles the 'th-style' Irssi-style logs",
		"%H:%M:%S<%@%n> %t",
		"%H:%M:%S-%n:%c- %t",
		"%H:%M:%S * %n %t",
		"%H:%M:%S-!- mode/%c [%m] by %n",
		"%H:%M:%S-!- %n [%*] has joined %c",
		"%H:%M:%S-!- %n [%*] has left %c",
                "%H:%M:%S-!- %n [%*] has quit IRC [%*]",
                "%H:%M:%S-!- %n was kicked from %c by %N",
                "%H:%M:%S-!- %n is now known as %N",
                "%H:%M:%S-!- %n changed the topic of %c to: %t",
                "--- Day changed"
	},

	{ "mirc-x", "mIRC whatever",
		"%H:%M <%n> %t",
		"%H:%M -%n- %t",
		"%H:%M * %n %t",
		"%H:%M  %n sets mode: %m",
		"%H:%M  Joins: %n(",
		"%H:%M  Quits: %n",
		"%H:%M  Quits: %n(%*) left irc:  ",
		"%H:%M  %n was kicked by %N ",
		"%H:%M  %n is now known as %N",
		"%H:%M  Topic has been changed by %n: %t",
		NULL
	},

};

const int	nInputFormats = (sizeof(inputFormats) / sizeof(t_logformat));


