/*
   weaponwin.c
   
   for Final Battle
   
   Mike Hufnagel & Bill Kendrick
   Previously modified: 11/29/95
   Last modified: 12/18/97
   
   Routines to redraw the weapons window.
*/

#include <stdio.h>
#include "const.h"
#include "glovar.h"
#include "types.h"
#include "weaponwin.h"
#include "lib/text.h"
#include "graphics.h"


void drawweaponwin(int pln)
{
  int i;
  
  XFillRectangle(display[pln], weaponwin[pln], weapongc_middle[pln],
		 0, 0, weapongeom[pln].w, weapongeom[pln].h);
  
  XDrawLine(display[pln], weaponwin[pln], weapongc_hilight[pln],
	    0, 0, 0, weapongeom[pln].h - 1);
  XDrawLine(display[pln], weaponwin[pln], weapongc_shadow[pln],
	    weapongeom[pln].w - 1, 0, 
	    weapongeom[pln].w - 1, weapongeom[pln].h - 1);
  
  
  /* Draw each weapon's icon and its name: */
  
  for (i = 0; i < UNIQUE_WEAPONS; i++)
    {
      drawbitmap(display[pln], weaponwin[pln], weapongc[pln],
		 8, i * 34 + 1, weaponweaponbitmaps[pln][i]);
      XDrawLine(display[pln], weaponwin[pln], weapongc_hilight[pln],
		1, i * 34, weapongeom[pln].w - 2, i * 34);
      XDrawLine(display[pln], weaponwin[pln], weapongc_shadow[pln],
		1, i * 34 + 33, weapongeom[pln].w - 2, i * 34 + 33);
      drawtext(display[pln], weaponwin[pln], weapongc[pln], 48, i * 34 +
	       fh[pln], weapon_name_strings[i]);
    }
  
  updateweaponwin(pln);
}


void updateweaponwin(int pln)
{
  int i;
  int whichgc;     /* which color to draw it in? */
  char many[10];

  
  /* Keep us up to date on how many there are: */
  
  for (i = 0; i < UNIQUE_WEAPONS; i++)
    {
      XDrawLine(display[pln], weaponwin[pln], weapongc_middle[pln],
		1, i * 34 + 1, 5, i * 34 + 16);
      XDrawLine(display[pln], weaponwin[pln], weapongc_middle[pln],
		5, i * 34 + 16,	1, i * 34 + 32);

      XDrawLine(display[pln], weaponwin[pln], weapongc_middle[pln],
		2, i * 34 + 2, 6, i * 34 + 17);
      XDrawLine(display[pln], weaponwin[pln], weapongc_middle[pln],
		6, i * 34 + 17,	2, i * 34 + 33);
      
      if (player[pln].weapons[i] != UNLIMITED)
	{
	  sprintf(many, "%d  ", player[pln].weapons[i]);
	  if (player[pln].weapons[i] == 0)
	    whichgc = 0;
	  else
	    whichgc = 1;
	}
      else
	{
	  strcpy(many, "Unlimited");
	  whichgc = 1;
	}
      
      drawtext(display[pln], weaponwin[pln], weapongc_colors[pln][whichgc],
	       48, i * 34 + 28, many);
    }
  
  
  /* Draw the "cursor" */
  
  i = player[pln].current_weapon;
  
  XDrawLine(display[pln], weaponwin[pln], weapongc_shadow[pln],
	    1, i * 34 + 1, 5, i * 34 + 16);
  XDrawLine(display[pln], weaponwin[pln], weapongc_shadow[pln],
	    5, i * 34 + 16, 1, i * 34 + 32);
  
  XDrawLine(display[pln], weaponwin[pln], weapongc_hilight[pln],
	    2, i * 34 + 2, 6, i * 34 + 17);
  XDrawLine(display[pln], weaponwin[pln], weapongc_hilight[pln],
	    6, i * 34 + 17, 2, i * 34 + 33);
}
