/*
   setup.c
   
   for Final Battle
   
   By Mike Hufnagel and Bill Kendrick
   Last modified: 4/2/98
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "lib/connect.h"   /* Simplified connect-to-server interface */
#include "lib/gc.h"        /* Specialized Graphics Contexts */
#include "lib/rndm.h"      /* Random number generator */
#include "lib/text.h"      /* Font stuff */
#include "lib/visual.h"
#include "lib/color.h"
#include "const.h"
#include "glovar.h"
#include "setup.h"         /* Our header file */
#include "types.h"
#include "misc.h"

char dash_dot[] = {3,3};   /* Dash information for our dashed GC... */
int dash_dots = 2;


/* Local prototypes */

void do_title(int i);
void loadships(char *fname, int i, int s);
void loadasteroids(int s);
void loaddrone(int s);
void loadupgrades(int s);
FILE *objopen(char *fname, int frames_wanted);
void bload(FILE *fi, unsigned char *buf);
int maxfontwidth(int pln, char * * text, int max_texts);
unsigned long MyAllocNamedColor(Display *display, Colormap colormap,
				char* colorname, unsigned long default_color,
				int has_color);


void setup(int argc, char *argv[])
{
  int i;                          /* Counter */
  int servers;                    /* Count of servers */
  Display *MainsDisp;             /* First player's data that we get when */
  int MainsScreen;                /* ...we go to "-add" ourselfs to an */
  Window MainsRoot, MainsWin;     /* ...in-progress game */
  Display *MyDisp;                /* Our screen */
  int MyScreen;
  Window MyRoot, MyWin;
  int format;                     /* Our property stuff for sending an */
  unsigned long nitems, left;     /* ...event to the first player's window */
  unsigned char *retdata;         /* ...(thereby to the current game */
  XClientMessageEvent event;      /* ...itself)... */
  Atom type, AnAtom;
  int x, y;
  char buf[128];
  int c;                          /* For showing... */
  FILE * fi;                      /* ...the news file */
  
  
  /* Create underlines (for comm. win. message entry field) */
  
  for (i = 0; i < MAX_MESG_SIZE; i++)
    blank_message_str[i] = '_';
  blank_message_str[MAX_MESG_SIZE] = '\0';
  
  
  x = 0;
  y = 0;
  
  /* Our parsing sucks.  No geometry settings or anything! */
  
  if (argc == 1)
    {
      /* For now, usage */
      
      fprintf(stderr,
	      "final playername server [playername server...] [-g x y]\n");
      fprintf(stderr,
	      "final -add playername server masterserver [-g x y]\n\n");
      exit(1);
    }
  
  
  /* ------- Connect to an existing game ------ */
  
  if (strcmp(argv[1], "-add") == 0)
    {
      if (argc != 5)
	{
	  fprintf(stderr,
		  "final -add playername server masterserver\n\n");
	  exit(1);
	}
      
      
      /* Connect to the server, find the game atom */
      
      MainsDisp = ConnectToServer(argv[4], &MainsScreen, &MainsRoot);
      
      
      /* Was there a problem? */
      
      if (MainsDisp == NULL)
	{
	  fprintf(stderr, "Sorry!  Cannot connect to X Server [%s]\n",
		  argv[4]);
          exit(1);
	}
      
      
      /* Look for (and get?) the atom: */
      
      AnAtom = XInternAtom(MainsDisp, "Final_Battle_Hook", 1);

      if (AnAtom == None)
	{
	  fprintf(stderr, "No Final Battle server running on [%s]\n", argv[4]);
	  exit(1);
	}
      
      
      /* Determine the "dualtest" window */
      /* (I forget what dualtest means! -bjk 11/3/97) */
      
      if (XGetWindowProperty(MainsDisp, MainsRoot, AnAtom, 0, 4, 0,
			     XA_WINDOW, &type, &format, &nitems, &left,
			     &retdata) == Success &&
	  type == XA_WINDOW && retdata != 0)
	{
	  MainsWin = *(Window *)retdata;
	}
      else
	{
	  fprintf(stderr, "Final Battle master window is missing!\n");
	  exit(1);
	}
      
      
      /* Where's MY screen? (we need to StoreBuffer onto it...) */
      
      MyDisp = ConnectToServer(argv[3], &MyScreen, &MyRoot);
      if (MyDisp == NULL)
	{
	  fprintf(stderr, "Can't find your display! [%s]\n", argv[3]);
	  exit(1);
	}
      
      
      /* Save my name in my display */
      
      XStoreBuffer(MyDisp, argv[2], strlen(argv[2]), 0); 
      XFlush(MyDisp);
      
      
      /* Send an event to it telling it our server: */
      
      event.display = MainsDisp;
      event.window = MainsWin;
      event.type = ClientMessage;
      event.format = 8;
      event.message_type = XA_STRING;
      
      strcpy(buf, argv[3]);
      if (strlen(buf) > 19)
	{
	  fprintf(stderr,
		  "Your server's string is too long!  Max 19 chars!\n");
	  exit(1);
	}
      
      strcpy(event.data.b, buf);
      
      XSendEvent(MainsDisp, MainsWin, 1, (long)0, (XEvent *)&event);
      
      
      XFlush(MainsDisp);
      XCloseDisplay(MainsDisp);
      
      printf("My display is: %s\n", DisplayString(MyDisp));
      printf("Sent message. (Let's hope it works!)\n");
      
      sleep(10);
      
      printf("They should have got it by now.  Bye!\n\n");
      
      XCloseDisplay(MyDisp);
      
      exit(0);
    }
  
  
  /* Show the news file: */
  
  fi = fopen("final.news", "r");
  
  if (fi != NULL)
    {
      do
	{
	  c = fgetc(fi);
	  if (c != EOF)
	    fputc(c, stdout);
	}
      while (c != EOF);
      fclose(fi);
      
      fflush(stdout);
    }
  
  
  /* ------- New game setup ------ (usage was "final username display...") */
  
  /* Clear stuff out first */
  
  servers = 0;
  for (i = 0; i < SERV; i++)
    player[i].exist = 0;
  wormhole.exist = 0;
  
  
  /* Determine the servers and their users' names */
  
  for (i = 1; i < argc; i = i + 2)
    {
      strcpy(name[servers], argv[i]);
      if (strlen(name[servers]) > MAX_NAME_SIZE)
	name[servers][MAX_NAME_SIZE] = '\0';
      
      if (i + 1 >= argc)
	{
	  fprintf(stderr, "Each player needs a server!\n");
	  exit(0);
	}
      
      strcpy(server[servers], argv[i + 1]);
      servers++;
    }
  
  
  /* Initialize our random function */
  
  initrndm();
  
  
  /* Connect to the servers, open the windows and do local setup */
  
  for (i = 0; i < servers; i++)
    add(i, x, y);
  
  
  /* Global setup: Initialize the stars, asteroids and weapons */
  
  for (i = 0; i < NUM_STARS; i++)
    {
      /* Random positions */
      
      star[i].x = rndm(WIDTH_OF_WORLD);
      star[i].y = rndm(HEIGHT_OF_WORLD);
      
      /* Random colors */
      
      star[i].color = rndm(STAR_COLORS);
    }
  
  
  for (i = 0; i < NUM_DEBRIS; i++)
    {
      /* No debris anywhere yet */
      
      debris[i].exist = 0;
    }
  
  
  for (i = 0; i < NUM_DEADMAN; i++)
    {
      /* No deadmen anywhere yet */
      
      deadman[i].exist = 0;
    }
  
  
  /* Clear our counters (debris may replace older debris - early removal of
     debris is alright, but not having any debris on a collision is not) */
  
  current_debris = 0;
  current_deadman = 0;
  
  
  /* Setup the asteroids */
  
  for (i = 0; i < NUM_ASTEROIDS; i++)
    {
      /* Our asteroid slot is taken */
      
      asteroid[i].exist = 1;
      
      
      /* Random positions */
      
      asteroid[i].x = rndm(WIDTH_OF_WORLD);
      asteroid[i].y = rndm(HEIGHT_OF_WORLD);
      
      
      /* Random speed and direction */
      
      asteroid[i].xm = rndm(16) - 8;
      asteroid[i].ym = rndm(16) - 8;
      
      
      /* Start at a random animation frame */
      
      asteroid[i].rotation = rndm(10) + 2;
      
      
      /* Random animation-frame-change speed/sign */
      
      asteroid[i].rotationm = rndm(4) - 2;
    }


  /* Setup the drones */
  
  for (i = 0; i < NUM_DRONES; i++)
    {
      /* Our drone slot is taken */
      
      drone[i].exist = 1;
      
      
      /* Random positions */
      
      drone[i].x = rndm(WIDTH_OF_WORLD);
      drone[i].y = rndm(HEIGHT_OF_WORLD);
      
      
      /* Random speed and direction */
      
      drone[i].xm = rndm(16) - 8;
      drone[i].ym = rndm(16) - 8;
      
      
      /* Don't home just yet (keep game easy for a sec. at the beginning): */
      
      drone[i].hometime = rndm(DRONE_HOMETIME_MAX) + DRONE_HOMETIME_MAX;
      drone[i].homeship = -1;
    }
  

  /* No bullets exist yet */
  
  for (i = 0; i < NUM_WEAPONS; i++)
    weapons[i].exist = 0;
  
  
  /* No upgrades exist yet */
  
  for (i = 0; i < NUM_UPGRADES; i++)
    upgrade[i].exist = 0;
  
  
  /* Init. toggle flag: */
  
  toggle = 0;
}


int add(int i, int x, int y)
{
  char title[100];            /* Buffer in which to store the derived titles */
  char fname[100];            /* Buffer for sprite file location/name */
  int maxheight, maxwidth;    /* How big is the screen? */
  int j;                      /* Counter */
  int color1, color2;         /* Our colors */
  int status, temp_depth;
  Visual * temp_visual = CopyFromParent;
  
  
  /* Connect to the server */
  
  printf("Attempting to connect to: %s\n", server[i]);
  fflush(stdout);
  
  display[i] = ConnectToServer(server[i], &screen[i], &rootwin[i]);
  
  
  /* Opps!  Couldn't do it! */
  
  if (display[i] == NULL)
    {
      printf("Could not connect to X Server [%s]\n", server[i]);
      return(0);
    }
  

  /* Our display's black and white pixel values (guaranteed to be there :) ) */
  
  black[i] = BlackPixel(display[i], screen[i]);
  white[i] = WhitePixel(display[i], screen[i]);
  
  middle[i] = MyAllocNamedColor(display[i], colormap[i],
				middle_color,
				(unsigned long) black[i],
				has_color[i]);
  
  
  /* Font: */
  
  font[i] = LoadFont(display[i], "variable", "fixed");
  fh[i] = FontHeight(font[i]);
  
  
  /* (Our server slot is taken) */
  
  player[i].exist = 1;
  
  
  /* How big is our screen? */
  
  maxheight = DisplayHeight(display[i], screen[i]);
  maxwidth = DisplayWidth(display[i], screen[i]);
  maxheight = 600;
  maxwidth = 800;
  
  
  /* Action window position */
  
  actiongeom[i].x = x;
  actiongeom[i].y = y;
  maxwidth -= actiongeom[i].x;
  maxheight -= actiongeom[i].y;
  commgeom[i].x = x;
  commgeom[i].w = ((MAX_MESG_SIZE + MAX_NAME_SIZE + 1) *
		   XTextWidth(font[i], "x", 1));
  commgeom[i].h = fh[i] * (NUM_MESSAGES + 2);
  weapongeom[i].w = maxfontwidth(i, weapon_name_strings, UNIQUE_WEAPONS) + 48;
  weapongeom[i].h = UNIQUE_WEAPONS * 34;
  upgradegeom[i].w = (maxfontwidth(i, upgrade_name_strings, UNIQUE_UPGRADES) +
		      40);
  upgradegeom[i].h = UNIQUE_UPGRADES * 32;
  damagegeom[i].h = (UNIQUE_DAMAGABLES + 5) * (fh[i] + 2);
  damagegeom[i].w = maxfontwidth(i, damagable_name_strings, UNIQUE_DAMAGABLES)
    + maxfontwidth(i, damage_name_strings, UNIQUE_DAMAGE_STATES) +
    (XTextWidth(font[i], "x", 1) * 12);
  radargeom[i].w = damagegeom[i].w;
  radargeom[i].h = radargeom[i].w;
  weapongeom[i].x = maxwidth - weapongeom[i].w - 10;
  damagegeom[i].x = weapongeom[i].x - damagegeom[i].w - 10;
  damagegeom[i].y = radargeom[i].y + radargeom[i].h + 28;
  commgeom[i].y = maxheight - commgeom[i].h - 28;
  actiongeom[i].h = commgeom[i].y - 28;
  radargeom[i].x = weapongeom[i].x - radargeom[i].w - 10;
  actiongeom[i].w = radargeom[i].x - 10;
  
  upgradegeom[i].x = weapongeom[i].x;
  upgradegeom[i].y = weapongeom[i].y + weapongeom[i].h + 28;
  upgradegeom[i].w = weapongeom[i].w;
  upgradegeom[i].h = 33 * (NUM_SHOWN_UPGRADES);
  
  
  initstate(i);
  
  
  /* Prevent untimely death (if a user kills their window, don't let it
     kill the entire game! */
  
  wm_delete_window = XInternAtom(display[i], "WM_DELETE_WINDOW", False);
  wm_protocols = XInternAtom(display[i], "WM_PROTOCOLS", False);
  
  
  /* Setup colors: */
  
  has_color[i] = 0;
  
  if (SetUpVisual(display[i], screen[i], &temp_visual, &temp_depth))
    {
      if (!SetUpColormap(display[i], screen[i], realactionwin[i], temp_visual,
			 &colormap[i]))
	{
	  fprintf(stderr, "Could not create a colormap!\n");
	  /* XCloseDisplay(display[i]);
	  exit(1); */
	}
      else
	has_color[i] = 1;
    }
  else
    {
      fprintf(stderr, "Could not find a PseudoColor visual!\n");
      /* XCloseDisplay(display[i]);
      exit(1); */
    }
  
  
  /* Action window */
  
  realactionwin[i] = OpenWindow(display[i], rootwin[i],
				actiongeom[i].x, actiongeom[i].y,
				actiongeom[i].w, actiongeom[i].h,
				CopyFromParent, black[i],
				ACTION_EVENT_MASK, VISUAL);
  
  if (BACKBUFFER)
    {
      actionwin[i] = XCreatePixmap(display[i], rootwin[i],
				   actiongeom[i].w, actiongeom[i].h,
				   DefaultDepthOfScreen(DefaultScreenOfDisplay(display[i])));
    }
  else
    {
      actionwin[i] = realactionwin[i];
    }
  
  
  sprintf(title,"%s at %s!", name[i], server[i]);
  SetStandardHints(display[i], realactionwin[i], "Game", title,
		   actiongeom[i].x, actiongeom[i].y,
		   actiongeom[i].w, actiongeom[i].h);
  
  status = XSetWMProtocols(display[i], realactionwin[i], &wm_delete_window, 1);
  
  
  /* Action window GraphicContexts: */
  
  actioncleargc[i] = CreateGC(display[i], actionwin[i], black[i], black[i]);
  actionandgc[i] = CreateAndGC(display[i], actionwin[i], white[i], black[i]);
  actiongc_white[i] = CreateGC(display[i], actionwin[i], white[i], black[i]);
  realactiongc[i] = CreateGC(display[i], realactionwin[i], white[i], black[i]);
  
  for (j = 0; j < EXPLODE_COLORS; j++)
    {
	 actiongc_explode[i][j] = CreateGC(display[i], actionwin[i], 
					   MyAllocNamedColor(display[i],
							     colormap[i],
							     explode_colors[j],
							     (unsigned long)
							     white[i],
							     has_color[i]),
					   black[i]);
    }
  
  
  for (j = 0; j < STAR_COLORS; j++)
    {
      actiongc_star[i][j] = CreateGC(display[i], actionwin[i], 
				     MyAllocNamedColor(display[i], colormap[i],
						       star_colors[j],
						       (unsigned long)
						       white[i],
						       has_color[i]),
				     black[i]);
    }
  
  actiongc_asteroid[i] = CreateGC(display[i], actionwin[i],
				  MyAllocNamedColor(display[i], colormap[i],
						    ASTEROID_COLOR,
						    (unsigned long)
						    white[i],
						    has_color[i]),
				  black[i]);
  
  actiongc_ship[i] = CreateGC(display[i], actionwin[i],
			      MyAllocNamedColor(display[i], colormap[i],
						SHIP_COLOR,
						(unsigned long) white[i],
						has_color[i]),
			      black[i]);
  
  actiongc_drone[i] = CreateGC(display[i], actionwin[i],
			       MyAllocNamedColor(display[i], colormap[i],
						 DRONE_COLOR,
						 (unsigned long) white[i],
						 has_color[i]),
			       black[i]);
  
  actiongc_upgrade[i] = CreateGC(display[i], actionwin[i],
				 MyAllocNamedColor(display[i], colormap[i],
						   UPGRADE_COLOR,
						   (unsigned long) white[i],
						   has_color[i]),
				 black[i]);
  
  actionorgc[i] = CreateOrGC(display[i], actionwin[i], white[i], black[i]);
  
  
  /* Radar window */
  
  color1 = MyAllocNamedColor(display[i], colormap[i], RADAR_FORE_COLOR,
			     (unsigned long) white[i], has_color[i]);
  
  color2 = MyAllocNamedColor(display[i], colormap[i], RADAR_BACK_COLOR,
			     (unsigned long) black[i], has_color[i]);
  
  radarwin[i] = OpenWindow(display[i], rootwin[i],
			   radargeom[i].x, radargeom[i].y,
			   radargeom[i].w, radargeom[i].h,
			   CopyFromParent, color2,
			   RADAR_EVENT_MASK, VISUAL);

  sprintf(title, "Radar");
  SetStandardHints(display[i], radarwin[i], "Game", title, radargeom[i].x,
		   radargeom[i].y, radargeom[i].w, radargeom[i].h);
  
  status = XSetWMProtocols(display[i], radarwin[i], &wm_delete_window, 1);
  
  
  /* Radar window GC's: */
  
  radargc[i] = CreateGC(display[i], radarwin[i], color1, color2);
  radardashedgc[i] = CreateGC(display[i], radarwin[i], color1, color2);
  
  
  /* Radar's dashed-line GC: */
  
  XSetLineAttributes(display[i], radardashedgc[i], 1, LineOnOffDash, CapButt,
		     JoinMiter);
  XSetDashes(display[i], radardashedgc[i], 0, dash_dot, dash_dots);
  
  
  /* Weapon window */
  
  weaponwin[i] = OpenWindow(display[i], rootwin[i],
			    weapongeom[i].x, weapongeom[i].y,
			    weapongeom[i].w, weapongeom[i].h,
			    CopyFromParent,
			    middle[i], WEAPON_EVENT_MASK, VISUAL);
  
  sprintf(title, "Weapons");
  SetStandardHints(display[i], weaponwin[i], "Game", title, weapongeom[i].x,
		   weapongeom[i].y, weapongeom[i].w, weapongeom[i].h);
  
  status = XSetWMProtocols(display[i], weaponwin[i], &wm_delete_window, 1);
  
  
  /* Weapon window GC's: */
  
  weapongc[i] = CreateGC(display[i], weaponwin[i], white[i],
			 MyAllocNamedColor(display[i], colormap[i],
					   middle_color,
					   (unsigned long) black[i],
					   has_color[i]));
  
  weaponblackgc[i] = CreateGC(display[i], weaponwin[i], black[i], middle[i]);
  
  weapongc_hilight[i] = CreateGC(display[i], weaponwin[i], 
				 MyAllocNamedColor(display[i], colormap[i],
						   hilight_color,
						   (unsigned long) white[i],
						   has_color[i]),
				 MyAllocNamedColor(display[i], colormap[i],
						   middle_color,
						   (unsigned long) black[i],
						   has_color[i]));
  
  weapongc_middle[i] = CreateGC(display[i], weaponwin[i], 
				MyAllocNamedColor(display[i], colormap[i],
						  middle_color,
						  (unsigned long) black[i],
						  has_color[i]),
				MyAllocNamedColor(display[i], colormap[i],
						  middle_color,
						  (unsigned long) black[i],
						  has_color[i]));
  
  weapongc_shadow[i] = CreateGC(display[i], weaponwin[i], 
				MyAllocNamedColor(display[i], colormap[i],
						  shadow_color,
						  (unsigned long) black[i],
						  has_color[i]),
				MyAllocNamedColor(display[i], colormap[i],
						  middle_color,
						  (unsigned long) black[i],
						  has_color[i]));
  
  for (j = 0; j < 2; j++)
    {
      weapongc_colors[i][j] = CreateGC(display[i], weaponwin[i], 
				       MyAllocNamedColor(display[i],
							 colormap[i],
							 weapon_colors[j],
							 (unsigned long)
							 white[i],
							 has_color[i]),
				       MyAllocNamedColor(display[i],
							 colormap[i],
							 middle_color,
							 (unsigned long)
							 black[i],
							 has_color[i]));
    }
  
  
  /* Damage window */
  
  damagewin[i] = OpenWindow(display[i], rootwin[i],
			    damagegeom[i].x, damagegeom[i].y,
			    damagegeom[i].w, damagegeom[i].h,
			    CopyFromParent, black[i],
			    DAMAGE_EVENT_MASK, VISUAL);

  sprintf(title, "Damage");
  SetStandardHints(display[i], damagewin[i], "Game", title, damagegeom[i].x,
		   damagegeom[i].y, damagegeom[i].w, damagegeom[i].h);
  
  status = XSetWMProtocols(display[i], damagewin[i], &wm_delete_window, 1);
  

  /* Damage window GC's: */
  
  damagegc[i] = CreateGC(display[i], damagewin[i], white[i], black[i]);
  
  for (j = 0; j < UNIQUE_DAMAGE_STATES; j++)
    {
      damagegc_colors[i][j] = CreateGC(display[i], damagewin[i], 
				       MyAllocNamedColor(display[i],
							 colormap[i],
							 damage_colors[j],
							 (unsigned long)
							 white[i],
							 has_color[i]),
				       black[i]);
    }
  
  
  /* Upgrade window */
  
  upgradewin[i] = OpenWindow(display[i], rootwin[i],
			     upgradegeom[i].x, upgradegeom[i].y,
			     upgradegeom[i].w, upgradegeom[i].h,
			     CopyFromParent, black[i],
			     UPGRADE_EVENT_MASK, VISUAL);
  
  sprintf(title, "Upgrade");
  SetStandardHints(display[i], upgradewin[i], "Game", title, upgradegeom[i].x,
		   upgradegeom[i].y, upgradegeom[i].w, upgradegeom[i].h);
  
  status = XSetWMProtocols(display[i], upgradewin[i], &wm_delete_window, 1);
  
  
  /* Upgrade window GC: */
  
  upgradegc[i] = CreateGC(display[i], upgradewin[i], white[i], black[i]);
  
  for (j = 0; j < 2; j++)
    {
      upgradegc_colors[i][j] = CreateGC(display[i], upgradewin[i], 
					MyAllocNamedColor(display[i],
							  colormap[i],
							  upgrade_colors[j],
							  (unsigned long)
							  white[i],
							  has_color[i]),
					black[i]);
    }
  
  
  /* Communications window */
  
  commwin[i] = OpenWindow(display[i], rootwin[i], commgeom[i].x, commgeom[i].y,
			  commgeom[i].w, commgeom[i].h, CopyFromParent,
			  black[i], COMM_EVENT_MASK, VISUAL);
  
  sprintf(title, "Communications");
  SetStandardHints(display[i], commwin[i], "Game", title, commgeom[i].x,
		   commgeom[i].y, commgeom[i].w, commgeom[i].h);

  status = XSetWMProtocols(display[i], commwin[i], &wm_delete_window, 1);
  

  /* Communications window GC's: */
  
  commgc[i] = CreateGC(display[i], commwin[i], white[i], black[i]);
  
  for (j = 0; j < NUM_MESSAGES; j++)
    commgc_message[i][j] = CreateGC(display[i], commwin[i],
				    MyAllocNamedColor(display[i],
						      colormap[i],
						      message_colors[j],
						      (unsigned long)
						      white[i],
						      has_color[i]),
				    black[i]);
  
  commgc_highlight[i] = CreateGC(display[i], commwin[i],
				 MyAllocNamedColor(display[i],
						   colormap[i],
						   message_highlight_color,
						   (unsigned long)
						   white[i],
						   has_color[i]),
				 black[i]);
  
  
  /* Store this player's ship bitmaps onto all of the servers */
  
  sprintf(fname, "sprites/obj/%c.obj", i + 'a');
  
  for (j = 0; j < SERV; j++)
    {
      if (player[j].exist)
	loadships(fname, i, j);
    }
  
  
  /* Store everyone else's ship bitmaps onto your server */
  
  for (j = 0; j < SERV; j++)
    {
      sprintf(fname, "sprites/obj/%c.obj", j + 'a');
      
      if (player[j].exist && i != j)
	loadships(fname, j, i);
    }
  
  
  /* Store the asteroids bitmaps onto your server */
  
  loadasteroids(i);
  
  
  /* Store the drone bitmap onto your server */
  
  loaddrone(i);
  
  
  /* Store the upgrade and weapon bitmaps onto your server */
  
  loadupgrades(i);
  
  
  /* Pop all of the windows up, make the action window raised */
  
  XMapWindow(display[i], radarwin[i]);
  XMapWindow(display[i], weaponwin[i]);
  XMapWindow(display[i], damagewin[i]);
  XMapWindow(display[i], upgradewin[i]);
  XMapWindow(display[i], commwin[i]);
  XMapRaised(display[i], realactionwin[i]);
  
  
  /* Clear out your comm. window message space */
  
  for (j = 0; j < NUM_MESSAGES; j++)
    strcpy(messages[i][j], " ");
  
  
  /* Make an atom for other clients ("final -add") to look at and get
     a player's realactionwin ID from so that they can send client mesgs to it 
     (and thereby to us) */
  
  OurAtom[i] = XInternAtom(display[i], "Final_Battle_Hook", False);
  OurAtom[i] = XInternAtom(display[i], "Final_Battle_Hook", 0);
  XChangeProperty(display[i], rootwin[i], OurAtom[i], XA_WINDOW, 32,
		  PropModeReplace, (unsigned char *)&realactionwin[i], 1);
  
  
  title_exist[i] = 0;
  /* do_title(i); */
  
  XFlush(display[i]);
  
  return(1);
}


/* Init player's state: */

void initstate(int i)
{
  int j;
  
  
  /* Player starting state (position, power, etc.) */
  
  player[i].x = rndm(WIDTH_OF_WORLD);   /* Random starting position... */
  player[i].y = rndm(HEIGHT_OF_WORLD);
  player[i].xm = 0;                     /* Standing still (0 momentum)... */
  player[i].ym = 0;
  player[i].dir = rndm(16);             /* Facing random direction */
  player[i].max = MAX_SPEED;            /* Default normal max speed */
  player[i].cloaked = CLOAK_NONE;       /* No cloak to start with */
  player[i].can_radar_cloak = 0;        /* No cloaking ability to start... */
  player[i].can_total_cloak = 0;
  player[i].cloakradar = 0;             /* No cloak-radar to start with */
  player[i].shields = 0;                /* No shields to start with */
  player[i].armor = 100;                /* Armor at 100% */
  player[i].warp = 0;                   /* No special radar-based upgrds... */
  player[i].home = 0;
  player[i].autop = 0;
  player[i].homingmode = HOME_NONE;     /* Of course they aren't homing yet! */
  player[i].crew_free = 50;             /* All crew free... */
  player[i].crew_frozen = 0;
  player[i].energy = INITIAL_ENERGY;
  player[i].energylow = 0;
  
  for (j = 0; j < 4; j++)
    arrow_key[i][j] = 0;
  
  
  /* Initialize damage: */
  
  for (j = 0; j < UNIQUE_DAMAGABLES; j++)
    {
      player[i].damage[j] = 0;
      player[i].crew_working[j] = 0;
    }
  
  
  /* Initialize weapons supply */
  
  player[i].weapons[0] = UNLIMITED;     /* Unlimited supply for standard */
  for (j = 1; j < UNIQUE_WEAPONS; j++)  /* No other weapons */
    player[i].weapons[j] = 0;
  
  
  /* Initialize current weapons */
  
  player[i].current_weapon = STANDARD;
}


/* Open a temp. title window */

void do_title(int i)
{
  int xhot, yhot;

  title_exist[i] = 1;
  titlew = 288;
  titleh = 207;
  titlewin[i] = OpenWindow(display[i], rootwin[i], actiongeom[i].x + 30,
			   actiongeom[i].y + 30, titlew, titleh,
			   CopyFromParent, black[i], TITLE_EVENT_MASK, VISUAL);
  XReadBitmapFile(display[i], titlewin[i], "sprites/title.xbm", &titlew,
		  &titleh, &titlebitmap[i], &xhot, &yhot);
  SetStandardHints(display[i], titlewin[i], "Game", "Final Battle",
		   actiongeom[i].x + 30, actiongeom[i].y + 30, titlew, titleh);
  titlegc[i] = CreateGC(display[i], titlewin[i], black[i], white[i]);
  
  XMapRaised(display[i], titlewin[i]);
}


/* Load ship frames from file "fname" into player-ship-bitmaps-slot "i" on
   server "s" */

void loadships(char *fname, int i, int s)
{
  unsigned char buf[128];       /* Storage space for raw bitmap data */
  int j;                        /* Counter */
  FILE *fi;                     /* For file I/O... */
  char str[100];
  
  fi = objopen(fname, 16);
  
  for (j = 0; j < 16; j++)
    {
      bload(fi, buf);
      shipbitmaps[s][i][j] = XCreateBitmapFromData(display[s], actionwin[s],
						   buf, 32, 32);
      
      /* bload(fi, buf); */
      shipbitmasks[s][i][j] = XCreateBitmapFromData(display[s], actionwin[s],
						    buf, 32, 32);
      bload(fi, buf);
    }
  fclose(fi);
}


/* Load asteroid frames onto server "s" */

void loadasteroids(int s)
{
  unsigned char buf[128];       /* Storage space for raw bitmap data */
  int j;                        /* Counter */
  FILE *fi;                     /* For file I/O... */
  
  fi = objopen("sprites/obj/asteroids.obj", 16);
  
  for (j = 0; j < 16; j++)
    {
      bload(fi, buf);
      asteroidbitmaps[s][j] = XCreateBitmapFromData(display[s], actionwin[s],
						    buf, 32, 32);

      bload(fi, buf);
      asteroidbitmasks[s][j] = XCreateBitmapFromData(display[s], actionwin[s],
						     buf, 32, 32);
    }
  fclose(fi);
}


/* Load drone bitmap onto server "s" */

void loaddrone(int s)
{
  unsigned char buf[128];       /* Storage space for raw bitmap data */
  FILE *fi;                     /* For file I/O... */
  
  fi = objopen("sprites/obj/drone.obj", 1);
  
  bload(fi, buf);
  dronebitmaps[s] = XCreateBitmapFromData(display[s], actionwin[s],
					  buf, 32, 32);

  bload(fi, buf);
  dronebitmasks[s] = XCreateBitmapFromData(display[s], actionwin[s],
					   buf, 32, 32);
  
  fclose(fi);
}


/* Load upgrade and weapon frames onto server "s" */

void loadupgrades(int s)
{
  unsigned char buf[128];       /* Storage space for raw bitmap data */
  int i, j;                     /* Counters */
  FILE *fi;                     /* For file I/O... */
  char str[100];
  

  /* Load the upgrade icons */
  
  for (i = 0; i < UNIQUE_UPGRADES - 1; i++)  /* -1 `cause weapons dont count */
    {
      sprintf(str, "sprites/obj/upgrade_%c.obj", i + 'a');
      
      fi = objopen(str, 8);
      
      for (j = 0; j < 8; j++)
	{
	  bload(fi, buf);
	  upgradebitmaps[s][i][j] = XCreateBitmapFromData(display[s],
							  actionwin[s],
							  buf, 32, 32);
	  upgradeupgradebitmaps[s][i] = XCreateBitmapFromData(display[s],
							      upgradewin[s],
							      buf, 32, 32);

	  bload(fi, buf);
	  upgradebitmasks[s][i][j] = XCreateBitmapFromData(display[s],
							   actionwin[s],
							   buf, 32, 32);
	}
      fclose(fi);
    } /* (for UNIQUE_UPGRADES) */
  

  /* Load the weapons icons */
  
  for (i = 0; i < UNIQUE_WEAPONS; i++)
    {
      sprintf(str, "sprites/obj/weapon_%c.obj", i + 'a');
      
      fi = objopen(str, 1);
      
      bload(fi, buf);
      weaponbitmaps[s][i] = XCreateBitmapFromData(display[s],
						  actionwin[s],
						  buf, 32, 32);
      weaponweaponbitmaps[s][i] = XCreateBitmapFromData(display[s],
							weaponwin[s],
							buf, 32, 32);
      
      bload(fi, buf);
      weaponbitmasks[s][i] = XCreateBitmapFromData(display[s],
						   actionwin[s],
						   buf, 32, 32);
      
      fclose(fi);
    } /* (for UNIQUE_WEAPONS) */
}


/* Opens and tests the correctness (right type, size, #frames) of an .obj
   animation file */

FILE *objopen(char *fname, int frames_wanted)
{
  char str[100];        /* For file I/O... */
  FILE *fi;
  
  fi = fopen(fname, "r");
  
  if (fi == NULL)
    {
      perror(fname);
      exit(1);
    }
  
  fgets(str, 99, fi);
  if (strcmp(str, "obj\n"))        /* bad type */
    {
      fprintf(stderr, "%s: Bad type\n", fname);
      exit(1);
    }
  
  fgets(str, 10, fi);
  if (atoi(str) != frames_wanted)  /* bad # frames */
    {
      fprintf(stderr, "%s: Bad # frames\n", fname);
      exit(1);
    }
  
  fgets(str, 10, fi);
  if (atoi(str) != 32)             /* bad width */
    {
      fprintf(stderr, "%s: Bad width\n", fname);
      exit(1);
    }
  
  fgets(str, 10, fi);
  if (atoi(str) != 32)             /* bad height */
    {
      fprintf(stderr, "%s: Bad height\n", fname);
      exit(1);
    }
  return(fi);
}


void bload(FILE *fi, unsigned char *buf)
{
  int i;

  for (i = 0; i < 128; i++)
    buf[i] = fgetc(fi);
}


int maxfontwidth(int pln, char * * text, int max_texts)
{
  int i, max, maxlen;
  
  max = 0;
  maxlen = strlen(text[0]);
  
  for (i = 1; i < max_texts; i++)
    {
      if (strlen(text[i]) > maxlen)
	{
	  maxlen = strlen(text[i]);
	  max = i;
	}
    }
  
  return (XTextWidth(font[pln], text[max], strlen(text[max])));
}


unsigned long MyAllocNamedColor(Display *display, Colormap colormap,
				char* colorname, unsigned long default_color,
				int has_color)
{
  if (has_color == 0)
    return(default_color);
  else
    return(AllocNamedColor(display, colormap, colorname, default_color));
}
