/*
  event.h
  
  For Final Battle
  
  Bill Kendrick & Mike Hufnagel
  Previously modified: 11/19/95 (clean up)
  Last modified: 11/3/97
  
  Handles different types of events.
*/

#ifndef EVENT_H
#define EVENT_H

#include <X11/Xlib.h>


void button_event(int pln, Window whichwin, int x, int y, unsigned int but);
/* 
   Intercepts button events (controls).
*/

void client_event(int pln);
/* 
   Intercepts and handles client-message events (a user is joining or
   a window is getting killed).
*/

void configure_event(int pln, Window whichwin, int w, int h);
/*
   Intercepts and handles configure events (window structure changes) and
   updates the Geom'etry structure for the appropriate window
*/

void map_event(int pln);
/*
   When one window is mapped, remap all windows
*/

void expose_event(int pln, Window whichwin);
/*
   Determines which window-redraw function to call on an expose event.
*/

void kbd_event(int pln);
/* 
   Intercepts keyboard events (controls).
*/

void kbd_release(int pln);
/* 
   Handles release of arrow keys.
*/

void keep_handling_keyboard_control(int pln);
/* 
   Interprets arrow keys.
*/

#endif /* EVENT_H */



