/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:49 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 16 */

/*
 * This function contains 359 FP additions, 152 FP multiplications,
 * (or, 307 additions, 100 multiplications, 52 fused multiply/add),
 * 57 stack variables, and 128 memory accesses
 */
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);
static const fftw_real K923879532 = FFTW_KONST(+0.923879532511286756128183189396788286822416626);
static const fftw_real K382683432 = FFTW_KONST(+0.382683432365089771728459984030398866761344562);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_16(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (16 * iostride);
     {
	  fftw_real tmp360;
	  fftw_real tmp363;
	  fftw_real tmp364;
	  fftw_real tmp392;
	  fftw_real tmp375;
	  fftw_real tmp390;
	  fftw_real tmp397;
	  fftw_real tmp405;
	  fftw_real tmp413;
	  fftw_real tmp367;
	  fftw_real tmp370;
	  fftw_real tmp371;
	  fftw_real tmp393;
	  fftw_real tmp374;
	  fftw_real tmp383;
	  fftw_real tmp398;
	  fftw_real tmp408;
	  fftw_real tmp414;
	  fftw_real tmp373;
	  fftw_real tmp372;
	  fftw_real tmp400;
	  fftw_real tmp401;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp358;
	       fftw_real tmp359;
	       fftw_real tmp361;
	       fftw_real tmp362;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp358 = X[0];
	       tmp359 = X[8 * iostride];
	       tmp360 = tmp358 + tmp359;
	       tmp361 = X[4 * iostride];
	       tmp362 = X[12 * iostride];
	       tmp363 = tmp361 + tmp362;
	       tmp364 = tmp360 + tmp363;
	       tmp392 = tmp358 - tmp359;
	       tmp375 = tmp361 - tmp362;
	  }
	  {
	       fftw_real tmp386;
	       fftw_real tmp403;
	       fftw_real tmp389;
	       fftw_real tmp404;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp384;
		    fftw_real tmp385;
		    fftw_real tmp387;
		    fftw_real tmp388;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp384 = X[iostride];
		    tmp385 = X[9 * iostride];
		    tmp386 = tmp384 - tmp385;
		    tmp403 = tmp384 + tmp385;
		    tmp387 = X[5 * iostride];
		    tmp388 = X[13 * iostride];
		    tmp389 = tmp387 - tmp388;
		    tmp404 = tmp387 + tmp388;
	       }
	       tmp390 = (K382683432 * tmp386) + (K923879532 * tmp389);
	       tmp397 = (K923879532 * tmp386) - (K382683432 * tmp389);
	       tmp405 = tmp403 - tmp404;
	       tmp413 = tmp403 + tmp404;
	  }
	  {
	       fftw_real tmp365;
	       fftw_real tmp366;
	       fftw_real tmp368;
	       fftw_real tmp369;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp365 = X[2 * iostride];
	       tmp366 = X[10 * iostride];
	       tmp367 = tmp365 + tmp366;
	       tmp373 = tmp365 - tmp366;
	       tmp368 = X[14 * iostride];
	       tmp369 = X[6 * iostride];
	       tmp370 = tmp368 + tmp369;
	       tmp372 = tmp368 - tmp369;
	  }
	  tmp371 = tmp367 + tmp370;
	  tmp393 = K707106781 * (tmp373 + tmp372);
	  tmp374 = K707106781 * (tmp372 - tmp373);
	  {
	       fftw_real tmp379;
	       fftw_real tmp406;
	       fftw_real tmp382;
	       fftw_real tmp407;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp377;
		    fftw_real tmp378;
		    fftw_real tmp380;
		    fftw_real tmp381;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp377 = X[15 * iostride];
		    tmp378 = X[7 * iostride];
		    tmp379 = tmp377 - tmp378;
		    tmp406 = tmp377 + tmp378;
		    tmp380 = X[3 * iostride];
		    tmp381 = X[11 * iostride];
		    tmp382 = tmp380 - tmp381;
		    tmp407 = tmp380 + tmp381;
	       }
	       tmp383 = (K382683432 * tmp379) - (K923879532 * tmp382);
	       tmp398 = (K923879532 * tmp379) + (K382683432 * tmp382);
	       tmp408 = tmp406 - tmp407;
	       tmp414 = tmp406 + tmp407;
	  }
	  {
	       fftw_real tmp412;
	       fftw_real tmp415;
	       fftw_real tmp410;
	       fftw_real tmp411;
	       ASSERT_ALIGNED_DOUBLE();
	       X[4 * iostride] = tmp364 - tmp371;
	       tmp412 = tmp364 + tmp371;
	       tmp415 = tmp413 + tmp414;
	       X[8 * iostride] = tmp412 - tmp415;
	       X[0] = tmp412 + tmp415;
	       Y[-4 * iostride] = tmp414 - tmp413;
	       tmp410 = tmp370 - tmp367;
	       tmp411 = K707106781 * (tmp408 - tmp405);
	       Y[-2 * iostride] = tmp410 + tmp411;
	       Y[-6 * iostride] = tmp411 - tmp410;
	  }
	  {
	       fftw_real tmp402;
	       fftw_real tmp409;
	       fftw_real tmp396;
	       fftw_real tmp399;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp402 = tmp360 - tmp363;
	       tmp409 = K707106781 * (tmp405 + tmp408);
	       X[6 * iostride] = tmp402 - tmp409;
	       X[2 * iostride] = tmp402 + tmp409;
	       tmp396 = tmp392 + tmp393;
	       tmp399 = tmp397 + tmp398;
	       X[7 * iostride] = tmp396 - tmp399;
	       X[iostride] = tmp396 + tmp399;
	  }
	  tmp400 = tmp375 + tmp374;
	  tmp401 = tmp398 - tmp397;
	  Y[-3 * iostride] = tmp400 + tmp401;
	  Y[-5 * iostride] = tmp401 - tmp400;
	  {
	       fftw_real tmp376;
	       fftw_real tmp391;
	       fftw_real tmp394;
	       fftw_real tmp395;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp376 = tmp374 - tmp375;
	       tmp391 = tmp383 - tmp390;
	       Y[-iostride] = tmp376 + tmp391;
	       Y[-7 * iostride] = tmp391 - tmp376;
	       tmp394 = tmp392 - tmp393;
	       tmp395 = tmp390 + tmp383;
	       X[5 * iostride] = tmp394 - tmp395;
	       X[3 * iostride] = tmp394 + tmp395;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 15) {
	  fftw_real tmp160;
	  fftw_real tmp244;
	  fftw_real tmp332;
	  fftw_real tmp345;
	  fftw_real tmp171;
	  fftw_real tmp346;
	  fftw_real tmp247;
	  fftw_real tmp329;
	  fftw_real tmp230;
	  fftw_real tmp241;
	  fftw_real tmp314;
	  fftw_real tmp281;
	  fftw_real tmp297;
	  fftw_real tmp315;
	  fftw_real tmp316;
	  fftw_real tmp317;
	  fftw_real tmp276;
	  fftw_real tmp296;
	  fftw_real tmp183;
	  fftw_real tmp305;
	  fftw_real tmp253;
	  fftw_real tmp289;
	  fftw_real tmp194;
	  fftw_real tmp306;
	  fftw_real tmp258;
	  fftw_real tmp290;
	  fftw_real tmp207;
	  fftw_real tmp218;
	  fftw_real tmp309;
	  fftw_real tmp270;
	  fftw_real tmp294;
	  fftw_real tmp310;
	  fftw_real tmp311;
	  fftw_real tmp312;
	  fftw_real tmp265;
	  fftw_real tmp293;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp154;
	       fftw_real tmp331;
	       fftw_real tmp159;
	       fftw_real tmp330;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp154 = X[0];
	       tmp331 = Y[-15 * iostride];
	       {
		    fftw_real tmp156;
		    fftw_real tmp158;
		    fftw_real tmp155;
		    fftw_real tmp157;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp156 = X[8 * iostride];
		    tmp158 = Y[-7 * iostride];
		    tmp155 = c_re(W[7]);
		    tmp157 = c_im(W[7]);
		    tmp159 = (tmp155 * tmp156) - (tmp157 * tmp158);
		    tmp330 = (tmp157 * tmp156) + (tmp155 * tmp158);
	       }
	       tmp160 = tmp154 + tmp159;
	       tmp244 = tmp154 - tmp159;
	       tmp332 = tmp330 + tmp331;
	       tmp345 = tmp331 - tmp330;
	  }
	  {
	       fftw_real tmp165;
	       fftw_real tmp245;
	       fftw_real tmp170;
	       fftw_real tmp246;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp162;
		    fftw_real tmp164;
		    fftw_real tmp161;
		    fftw_real tmp163;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp162 = X[4 * iostride];
		    tmp164 = Y[-11 * iostride];
		    tmp161 = c_re(W[3]);
		    tmp163 = c_im(W[3]);
		    tmp165 = (tmp161 * tmp162) - (tmp163 * tmp164);
		    tmp245 = (tmp163 * tmp162) + (tmp161 * tmp164);
	       }
	       {
		    fftw_real tmp167;
		    fftw_real tmp169;
		    fftw_real tmp166;
		    fftw_real tmp168;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp167 = X[12 * iostride];
		    tmp169 = Y[-3 * iostride];
		    tmp166 = c_re(W[11]);
		    tmp168 = c_im(W[11]);
		    tmp170 = (tmp166 * tmp167) - (tmp168 * tmp169);
		    tmp246 = (tmp168 * tmp167) + (tmp166 * tmp169);
	       }
	       tmp171 = tmp165 + tmp170;
	       tmp346 = tmp165 - tmp170;
	       tmp247 = tmp245 - tmp246;
	       tmp329 = tmp245 + tmp246;
	  }
	  {
	       fftw_real tmp224;
	       fftw_real tmp277;
	       fftw_real tmp240;
	       fftw_real tmp274;
	       fftw_real tmp229;
	       fftw_real tmp278;
	       fftw_real tmp235;
	       fftw_real tmp273;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp221;
		    fftw_real tmp223;
		    fftw_real tmp220;
		    fftw_real tmp222;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp221 = X[15 * iostride];
		    tmp223 = Y[0];
		    tmp220 = c_re(W[14]);
		    tmp222 = c_im(W[14]);
		    tmp224 = (tmp220 * tmp221) - (tmp222 * tmp223);
		    tmp277 = (tmp222 * tmp221) + (tmp220 * tmp223);
	       }
	       {
		    fftw_real tmp237;
		    fftw_real tmp239;
		    fftw_real tmp236;
		    fftw_real tmp238;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp237 = X[11 * iostride];
		    tmp239 = Y[-4 * iostride];
		    tmp236 = c_re(W[10]);
		    tmp238 = c_im(W[10]);
		    tmp240 = (tmp236 * tmp237) - (tmp238 * tmp239);
		    tmp274 = (tmp238 * tmp237) + (tmp236 * tmp239);
	       }
	       {
		    fftw_real tmp226;
		    fftw_real tmp228;
		    fftw_real tmp225;
		    fftw_real tmp227;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp226 = X[7 * iostride];
		    tmp228 = Y[-8 * iostride];
		    tmp225 = c_re(W[6]);
		    tmp227 = c_im(W[6]);
		    tmp229 = (tmp225 * tmp226) - (tmp227 * tmp228);
		    tmp278 = (tmp227 * tmp226) + (tmp225 * tmp228);
	       }
	       {
		    fftw_real tmp232;
		    fftw_real tmp234;
		    fftw_real tmp231;
		    fftw_real tmp233;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp232 = X[3 * iostride];
		    tmp234 = Y[-12 * iostride];
		    tmp231 = c_re(W[2]);
		    tmp233 = c_im(W[2]);
		    tmp235 = (tmp231 * tmp232) - (tmp233 * tmp234);
		    tmp273 = (tmp233 * tmp232) + (tmp231 * tmp234);
	       }
	       {
		    fftw_real tmp279;
		    fftw_real tmp280;
		    fftw_real tmp272;
		    fftw_real tmp275;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp230 = tmp224 + tmp229;
		    tmp241 = tmp235 + tmp240;
		    tmp314 = tmp230 - tmp241;
		    tmp279 = tmp277 - tmp278;
		    tmp280 = tmp235 - tmp240;
		    tmp281 = tmp279 + tmp280;
		    tmp297 = tmp279 - tmp280;
		    tmp315 = tmp277 + tmp278;
		    tmp316 = tmp273 + tmp274;
		    tmp317 = tmp315 - tmp316;
		    tmp272 = tmp224 - tmp229;
		    tmp275 = tmp273 - tmp274;
		    tmp276 = tmp272 - tmp275;
		    tmp296 = tmp272 + tmp275;
	       }
	  }
	  {
	       fftw_real tmp177;
	       fftw_real tmp249;
	       fftw_real tmp182;
	       fftw_real tmp250;
	       fftw_real tmp251;
	       fftw_real tmp252;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp174;
		    fftw_real tmp176;
		    fftw_real tmp173;
		    fftw_real tmp175;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp174 = X[2 * iostride];
		    tmp176 = Y[-13 * iostride];
		    tmp173 = c_re(W[1]);
		    tmp175 = c_im(W[1]);
		    tmp177 = (tmp173 * tmp174) - (tmp175 * tmp176);
		    tmp249 = (tmp175 * tmp174) + (tmp173 * tmp176);
	       }
	       {
		    fftw_real tmp179;
		    fftw_real tmp181;
		    fftw_real tmp178;
		    fftw_real tmp180;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp179 = X[10 * iostride];
		    tmp181 = Y[-5 * iostride];
		    tmp178 = c_re(W[9]);
		    tmp180 = c_im(W[9]);
		    tmp182 = (tmp178 * tmp179) - (tmp180 * tmp181);
		    tmp250 = (tmp180 * tmp179) + (tmp178 * tmp181);
	       }
	       tmp183 = tmp177 + tmp182;
	       tmp305 = tmp249 + tmp250;
	       tmp251 = tmp249 - tmp250;
	       tmp252 = tmp177 - tmp182;
	       tmp253 = tmp251 - tmp252;
	       tmp289 = tmp252 + tmp251;
	  }
	  {
	       fftw_real tmp188;
	       fftw_real tmp255;
	       fftw_real tmp193;
	       fftw_real tmp256;
	       fftw_real tmp254;
	       fftw_real tmp257;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp185;
		    fftw_real tmp187;
		    fftw_real tmp184;
		    fftw_real tmp186;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp185 = X[14 * iostride];
		    tmp187 = Y[-iostride];
		    tmp184 = c_re(W[13]);
		    tmp186 = c_im(W[13]);
		    tmp188 = (tmp184 * tmp185) - (tmp186 * tmp187);
		    tmp255 = (tmp186 * tmp185) + (tmp184 * tmp187);
	       }
	       {
		    fftw_real tmp190;
		    fftw_real tmp192;
		    fftw_real tmp189;
		    fftw_real tmp191;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp190 = X[6 * iostride];
		    tmp192 = Y[-9 * iostride];
		    tmp189 = c_re(W[5]);
		    tmp191 = c_im(W[5]);
		    tmp193 = (tmp189 * tmp190) - (tmp191 * tmp192);
		    tmp256 = (tmp191 * tmp190) + (tmp189 * tmp192);
	       }
	       tmp194 = tmp188 + tmp193;
	       tmp306 = tmp255 + tmp256;
	       tmp254 = tmp188 - tmp193;
	       tmp257 = tmp255 - tmp256;
	       tmp258 = tmp254 + tmp257;
	       tmp290 = tmp254 - tmp257;
	  }
	  {
	       fftw_real tmp201;
	       fftw_real tmp261;
	       fftw_real tmp217;
	       fftw_real tmp268;
	       fftw_real tmp206;
	       fftw_real tmp262;
	       fftw_real tmp212;
	       fftw_real tmp267;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp198;
		    fftw_real tmp200;
		    fftw_real tmp197;
		    fftw_real tmp199;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp198 = X[iostride];
		    tmp200 = Y[-14 * iostride];
		    tmp197 = c_re(W[0]);
		    tmp199 = c_im(W[0]);
		    tmp201 = (tmp197 * tmp198) - (tmp199 * tmp200);
		    tmp261 = (tmp199 * tmp198) + (tmp197 * tmp200);
	       }
	       {
		    fftw_real tmp214;
		    fftw_real tmp216;
		    fftw_real tmp213;
		    fftw_real tmp215;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp214 = X[13 * iostride];
		    tmp216 = Y[-2 * iostride];
		    tmp213 = c_re(W[12]);
		    tmp215 = c_im(W[12]);
		    tmp217 = (tmp213 * tmp214) - (tmp215 * tmp216);
		    tmp268 = (tmp215 * tmp214) + (tmp213 * tmp216);
	       }
	       {
		    fftw_real tmp203;
		    fftw_real tmp205;
		    fftw_real tmp202;
		    fftw_real tmp204;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp203 = X[9 * iostride];
		    tmp205 = Y[-6 * iostride];
		    tmp202 = c_re(W[8]);
		    tmp204 = c_im(W[8]);
		    tmp206 = (tmp202 * tmp203) - (tmp204 * tmp205);
		    tmp262 = (tmp204 * tmp203) + (tmp202 * tmp205);
	       }
	       {
		    fftw_real tmp209;
		    fftw_real tmp211;
		    fftw_real tmp208;
		    fftw_real tmp210;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp209 = X[5 * iostride];
		    tmp211 = Y[-10 * iostride];
		    tmp208 = c_re(W[4]);
		    tmp210 = c_im(W[4]);
		    tmp212 = (tmp208 * tmp209) - (tmp210 * tmp211);
		    tmp267 = (tmp210 * tmp209) + (tmp208 * tmp211);
	       }
	       {
		    fftw_real tmp266;
		    fftw_real tmp269;
		    fftw_real tmp263;
		    fftw_real tmp264;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp207 = tmp201 + tmp206;
		    tmp218 = tmp212 + tmp217;
		    tmp309 = tmp207 - tmp218;
		    tmp266 = tmp201 - tmp206;
		    tmp269 = tmp267 - tmp268;
		    tmp270 = tmp266 - tmp269;
		    tmp294 = tmp266 + tmp269;
		    tmp310 = tmp261 + tmp262;
		    tmp311 = tmp267 + tmp268;
		    tmp312 = tmp310 - tmp311;
		    tmp263 = tmp261 - tmp262;
		    tmp264 = tmp212 - tmp217;
		    tmp265 = tmp263 + tmp264;
		    tmp293 = tmp263 - tmp264;
	       }
	  }
	  {
	       fftw_real tmp260;
	       fftw_real tmp284;
	       fftw_real tmp354;
	       fftw_real tmp356;
	       fftw_real tmp283;
	       fftw_real tmp357;
	       fftw_real tmp287;
	       fftw_real tmp355;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp248;
		    fftw_real tmp259;
		    fftw_real tmp352;
		    fftw_real tmp353;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp248 = tmp244 - tmp247;
		    tmp259 = K707106781 * (tmp253 - tmp258);
		    tmp260 = tmp248 + tmp259;
		    tmp284 = tmp248 - tmp259;
		    tmp352 = K707106781 * (tmp290 - tmp289);
		    tmp353 = tmp346 + tmp345;
		    tmp354 = tmp352 + tmp353;
		    tmp356 = tmp353 - tmp352;
	       }
	       {
		    fftw_real tmp271;
		    fftw_real tmp282;
		    fftw_real tmp285;
		    fftw_real tmp286;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp271 = (K923879532 * tmp265) + (K382683432 * tmp270);
		    tmp282 = (K382683432 * tmp276) - (K923879532 * tmp281);
		    tmp283 = tmp271 + tmp282;
		    tmp357 = tmp282 - tmp271;
		    tmp285 = (K382683432 * tmp265) - (K923879532 * tmp270);
		    tmp286 = (K382683432 * tmp281) + (K923879532 * tmp276);
		    tmp287 = tmp285 - tmp286;
		    tmp355 = tmp285 + tmp286;
	       }
	       Y[-11 * iostride] = tmp260 - tmp283;
	       X[3 * iostride] = tmp260 + tmp283;
	       Y[-15 * iostride] = tmp284 - tmp287;
	       X[7 * iostride] = tmp284 + tmp287;
	       X[11 * iostride] = -(tmp354 - tmp355);
	       Y[-3 * iostride] = tmp355 + tmp354;
	       X[15 * iostride] = -(tmp356 - tmp357);
	       Y[-7 * iostride] = tmp357 + tmp356;
	  }
	  {
	       fftw_real tmp292;
	       fftw_real tmp300;
	       fftw_real tmp348;
	       fftw_real tmp350;
	       fftw_real tmp299;
	       fftw_real tmp351;
	       fftw_real tmp303;
	       fftw_real tmp349;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp288;
		    fftw_real tmp291;
		    fftw_real tmp344;
		    fftw_real tmp347;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp288 = tmp244 + tmp247;
		    tmp291 = K707106781 * (tmp289 + tmp290);
		    tmp292 = tmp288 + tmp291;
		    tmp300 = tmp288 - tmp291;
		    tmp344 = K707106781 * (tmp253 + tmp258);
		    tmp347 = tmp345 - tmp346;
		    tmp348 = tmp344 + tmp347;
		    tmp350 = tmp347 - tmp344;
	       }
	       {
		    fftw_real tmp295;
		    fftw_real tmp298;
		    fftw_real tmp301;
		    fftw_real tmp302;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp295 = (K382683432 * tmp293) + (K923879532 * tmp294);
		    tmp298 = (K923879532 * tmp296) - (K382683432 * tmp297);
		    tmp299 = tmp295 + tmp298;
		    tmp351 = tmp298 - tmp295;
		    tmp301 = (K923879532 * tmp293) - (K382683432 * tmp294);
		    tmp302 = (K923879532 * tmp297) + (K382683432 * tmp296);
		    tmp303 = tmp301 - tmp302;
		    tmp349 = tmp301 + tmp302;
	       }
	       Y[-9 * iostride] = tmp292 - tmp299;
	       X[iostride] = tmp292 + tmp299;
	       Y[-13 * iostride] = tmp300 - tmp303;
	       X[5 * iostride] = tmp300 + tmp303;
	       X[9 * iostride] = -(tmp348 - tmp349);
	       Y[-iostride] = tmp349 + tmp348;
	       X[13 * iostride] = -(tmp350 - tmp351);
	       Y[-5 * iostride] = tmp351 + tmp350;
	  }
	  {
	       fftw_real tmp308;
	       fftw_real tmp320;
	       fftw_real tmp340;
	       fftw_real tmp342;
	       fftw_real tmp319;
	       fftw_real tmp343;
	       fftw_real tmp323;
	       fftw_real tmp341;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp304;
		    fftw_real tmp307;
		    fftw_real tmp338;
		    fftw_real tmp339;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp304 = tmp160 - tmp171;
		    tmp307 = tmp305 - tmp306;
		    tmp308 = tmp304 + tmp307;
		    tmp320 = tmp304 - tmp307;
		    tmp338 = tmp194 - tmp183;
		    tmp339 = tmp332 - tmp329;
		    tmp340 = tmp338 + tmp339;
		    tmp342 = tmp339 - tmp338;
	       }
	       {
		    fftw_real tmp313;
		    fftw_real tmp318;
		    fftw_real tmp321;
		    fftw_real tmp322;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp313 = tmp309 + tmp312;
		    tmp318 = tmp314 - tmp317;
		    tmp319 = K707106781 * (tmp313 + tmp318);
		    tmp343 = K707106781 * (tmp318 - tmp313);
		    tmp321 = tmp312 - tmp309;
		    tmp322 = tmp314 + tmp317;
		    tmp323 = K707106781 * (tmp321 - tmp322);
		    tmp341 = K707106781 * (tmp321 + tmp322);
	       }
	       Y[-10 * iostride] = tmp308 - tmp319;
	       X[2 * iostride] = tmp308 + tmp319;
	       Y[-14 * iostride] = tmp320 - tmp323;
	       X[6 * iostride] = tmp320 + tmp323;
	       X[10 * iostride] = -(tmp340 - tmp341);
	       Y[-2 * iostride] = tmp341 + tmp340;
	       X[14 * iostride] = -(tmp342 - tmp343);
	       Y[-6 * iostride] = tmp343 + tmp342;
	  }
	  {
	       fftw_real tmp196;
	       fftw_real tmp324;
	       fftw_real tmp334;
	       fftw_real tmp336;
	       fftw_real tmp243;
	       fftw_real tmp337;
	       fftw_real tmp327;
	       fftw_real tmp335;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp172;
		    fftw_real tmp195;
		    fftw_real tmp328;
		    fftw_real tmp333;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp172 = tmp160 + tmp171;
		    tmp195 = tmp183 + tmp194;
		    tmp196 = tmp172 + tmp195;
		    tmp324 = tmp172 - tmp195;
		    tmp328 = tmp305 + tmp306;
		    tmp333 = tmp329 + tmp332;
		    tmp334 = tmp328 + tmp333;
		    tmp336 = tmp333 - tmp328;
	       }
	       {
		    fftw_real tmp219;
		    fftw_real tmp242;
		    fftw_real tmp325;
		    fftw_real tmp326;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp219 = tmp207 + tmp218;
		    tmp242 = tmp230 + tmp241;
		    tmp243 = tmp219 + tmp242;
		    tmp337 = tmp242 - tmp219;
		    tmp325 = tmp310 + tmp311;
		    tmp326 = tmp315 + tmp316;
		    tmp327 = tmp325 - tmp326;
		    tmp335 = tmp325 + tmp326;
	       }
	       Y[-8 * iostride] = tmp196 - tmp243;
	       X[0] = tmp196 + tmp243;
	       Y[-12 * iostride] = tmp324 - tmp327;
	       X[4 * iostride] = tmp324 + tmp327;
	       X[8 * iostride] = -(tmp334 - tmp335);
	       Y[0] = tmp335 + tmp334;
	       X[12 * iostride] = -(tmp336 - tmp337);
	       Y[-4 * iostride] = tmp337 + tmp336;
	  }
     }
     if (i == m) {
	  fftw_real tmp5;
	  fftw_real tmp78;
	  fftw_real tmp60;
	  fftw_real tmp50;
	  fftw_real tmp103;
	  fftw_real tmp114;
	  fftw_real tmp144;
	  fftw_real tmp57;
	  fftw_real tmp115;
	  fftw_real tmp108;
	  fftw_real tmp145;
	  fftw_real tmp12;
	  fftw_real tmp118;
	  fftw_real tmp65;
	  fftw_real tmp79;
	  fftw_real tmp20;
	  fftw_real tmp82;
	  fftw_real tmp71;
	  fftw_real tmp81;
	  fftw_real tmp35;
	  fftw_real tmp95;
	  fftw_real tmp92;
	  fftw_real tmp139;
	  fftw_real tmp42;
	  fftw_real tmp93;
	  fftw_real tmp100;
	  fftw_real tmp140;
	  fftw_real tmp27;
	  fftw_real tmp84;
	  fftw_real tmp76;
	  fftw_real tmp85;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp1;
	       fftw_real tmp3;
	       fftw_real tmp4;
	       fftw_real tmp2;
	       fftw_real tmp59;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp3 = X[8 * iostride];
	       tmp2 = c_re(W[7]);
	       tmp4 = tmp2 * tmp3;
	       tmp5 = tmp1 + tmp4;
	       tmp78 = tmp1 - tmp4;
	       tmp59 = c_im(W[7]);
	       tmp60 = tmp59 * tmp3;
	  }
	  {
	       fftw_real tmp46;
	       fftw_real tmp111;
	       fftw_real tmp49;
	       fftw_real tmp113;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp45;
		    fftw_real tmp44;
		    fftw_real tmp110;
		    fftw_real tmp48;
		    fftw_real tmp47;
		    fftw_real tmp112;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp45 = X[15 * iostride];
		    tmp44 = c_re(W[14]);
		    tmp46 = tmp44 * tmp45;
		    tmp110 = c_im(W[14]);
		    tmp111 = tmp110 * tmp45;
		    tmp48 = X[7 * iostride];
		    tmp47 = c_re(W[6]);
		    tmp49 = tmp47 * tmp48;
		    tmp112 = c_im(W[6]);
		    tmp113 = tmp112 * tmp48;
	       }
	       tmp50 = tmp46 + tmp49;
	       tmp103 = tmp46 - tmp49;
	       tmp114 = tmp111 - tmp113;
	       tmp144 = tmp111 + tmp113;
	  }
	  {
	       fftw_real tmp53;
	       fftw_real tmp105;
	       fftw_real tmp56;
	       fftw_real tmp107;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp52;
		    fftw_real tmp51;
		    fftw_real tmp104;
		    fftw_real tmp55;
		    fftw_real tmp54;
		    fftw_real tmp106;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp52 = X[3 * iostride];
		    tmp51 = c_re(W[2]);
		    tmp53 = tmp51 * tmp52;
		    tmp104 = c_im(W[2]);
		    tmp105 = tmp104 * tmp52;
		    tmp55 = X[11 * iostride];
		    tmp54 = c_re(W[10]);
		    tmp56 = tmp54 * tmp55;
		    tmp106 = c_im(W[10]);
		    tmp107 = tmp106 * tmp55;
	       }
	       tmp57 = tmp53 + tmp56;
	       tmp115 = tmp53 - tmp56;
	       tmp108 = tmp105 - tmp107;
	       tmp145 = tmp105 + tmp107;
	  }
	  {
	       fftw_real tmp8;
	       fftw_real tmp62;
	       fftw_real tmp11;
	       fftw_real tmp64;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp7;
		    fftw_real tmp6;
		    fftw_real tmp61;
		    fftw_real tmp10;
		    fftw_real tmp9;
		    fftw_real tmp63;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp7 = X[4 * iostride];
		    tmp6 = c_re(W[3]);
		    tmp8 = tmp6 * tmp7;
		    tmp61 = c_im(W[3]);
		    tmp62 = tmp61 * tmp7;
		    tmp10 = X[12 * iostride];
		    tmp9 = c_re(W[11]);
		    tmp11 = tmp9 * tmp10;
		    tmp63 = c_im(W[11]);
		    tmp64 = tmp63 * tmp10;
	       }
	       tmp12 = tmp8 + tmp11;
	       tmp118 = tmp8 - tmp11;
	       tmp65 = tmp62 + tmp64;
	       tmp79 = tmp62 - tmp64;
	  }
	  {
	       fftw_real tmp16;
	       fftw_real tmp68;
	       fftw_real tmp19;
	       fftw_real tmp70;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp15;
		    fftw_real tmp14;
		    fftw_real tmp67;
		    fftw_real tmp18;
		    fftw_real tmp17;
		    fftw_real tmp69;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp15 = X[2 * iostride];
		    tmp14 = c_re(W[1]);
		    tmp16 = tmp14 * tmp15;
		    tmp67 = c_im(W[1]);
		    tmp68 = tmp67 * tmp15;
		    tmp18 = X[10 * iostride];
		    tmp17 = c_re(W[9]);
		    tmp19 = tmp17 * tmp18;
		    tmp69 = c_im(W[9]);
		    tmp70 = tmp69 * tmp18;
	       }
	       tmp20 = tmp16 + tmp19;
	       tmp82 = tmp16 - tmp19;
	       tmp71 = tmp68 + tmp70;
	       tmp81 = tmp68 - tmp70;
	  }
	  {
	       fftw_real tmp31;
	       fftw_real tmp89;
	       fftw_real tmp34;
	       fftw_real tmp91;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp30;
		    fftw_real tmp29;
		    fftw_real tmp88;
		    fftw_real tmp33;
		    fftw_real tmp32;
		    fftw_real tmp90;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp30 = X[iostride];
		    tmp29 = c_re(W[0]);
		    tmp31 = tmp29 * tmp30;
		    tmp88 = c_im(W[0]);
		    tmp89 = tmp88 * tmp30;
		    tmp33 = X[9 * iostride];
		    tmp32 = c_re(W[8]);
		    tmp34 = tmp32 * tmp33;
		    tmp90 = c_im(W[8]);
		    tmp91 = tmp90 * tmp33;
	       }
	       tmp35 = tmp31 + tmp34;
	       tmp95 = tmp31 - tmp34;
	       tmp92 = tmp89 - tmp91;
	       tmp139 = tmp89 + tmp91;
	  }
	  {
	       fftw_real tmp38;
	       fftw_real tmp97;
	       fftw_real tmp41;
	       fftw_real tmp99;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp37;
		    fftw_real tmp36;
		    fftw_real tmp96;
		    fftw_real tmp40;
		    fftw_real tmp39;
		    fftw_real tmp98;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp37 = X[5 * iostride];
		    tmp36 = c_re(W[4]);
		    tmp38 = tmp36 * tmp37;
		    tmp96 = c_im(W[4]);
		    tmp97 = tmp96 * tmp37;
		    tmp40 = X[13 * iostride];
		    tmp39 = c_re(W[12]);
		    tmp41 = tmp39 * tmp40;
		    tmp98 = c_im(W[12]);
		    tmp99 = tmp98 * tmp40;
	       }
	       tmp42 = tmp38 + tmp41;
	       tmp93 = tmp38 - tmp41;
	       tmp100 = tmp97 - tmp99;
	       tmp140 = tmp97 + tmp99;
	  }
	  {
	       fftw_real tmp23;
	       fftw_real tmp73;
	       fftw_real tmp26;
	       fftw_real tmp75;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp22;
		    fftw_real tmp21;
		    fftw_real tmp72;
		    fftw_real tmp25;
		    fftw_real tmp24;
		    fftw_real tmp74;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp22 = X[14 * iostride];
		    tmp21 = c_re(W[13]);
		    tmp23 = tmp21 * tmp22;
		    tmp72 = c_im(W[13]);
		    tmp73 = tmp72 * tmp22;
		    tmp25 = X[6 * iostride];
		    tmp24 = c_re(W[5]);
		    tmp26 = tmp24 * tmp25;
		    tmp74 = c_im(W[5]);
		    tmp75 = tmp74 * tmp25;
	       }
	       tmp27 = tmp23 + tmp26;
	       tmp84 = tmp23 - tmp26;
	       tmp76 = tmp73 + tmp75;
	       tmp85 = tmp73 - tmp75;
	  }
	  {
	       fftw_real tmp13;
	       fftw_real tmp152;
	       fftw_real tmp153;
	       fftw_real tmp28;
	       fftw_real tmp43;
	       fftw_real tmp66;
	       fftw_real tmp77;
	       fftw_real tmp58;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp13 = tmp5 + tmp12;
	       tmp152 = tmp139 + tmp140;
	       tmp153 = tmp144 + tmp145;
	       tmp28 = tmp20 + tmp27;
	       tmp43 = tmp35 + tmp42;
	       tmp66 = tmp60 + tmp65;
	       tmp77 = tmp71 + tmp76;
	       tmp58 = tmp50 + tmp57;
	       X[0] = tmp13 + tmp28 + tmp43 + tmp58;
	       X[4 * iostride] = tmp13 + tmp152 - (tmp28 + tmp153);
	       Y[0] = tmp66 + tmp77 + tmp152 + tmp153;
	       Y[-4 * iostride] = tmp66 + tmp58 - (tmp77 + tmp43);
	  }
	  {
	       fftw_real tmp136;
	       fftw_real tmp137;
	       fftw_real tmp149;
	       fftw_real tmp148;
	       fftw_real tmp147;
	       fftw_real tmp151;
	       fftw_real tmp142;
	       fftw_real tmp150;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp136 = tmp5 - tmp12;
	       tmp137 = tmp71 - tmp76;
	       tmp149 = tmp27 - tmp20;
	       tmp148 = tmp60 - tmp65;
	       {
		    fftw_real tmp143;
		    fftw_real tmp146;
		    fftw_real tmp138;
		    fftw_real tmp141;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp143 = tmp50 - tmp57;
		    tmp146 = tmp144 - tmp145;
		    tmp147 = tmp143 - tmp146;
		    tmp151 = tmp143 + tmp146;
		    tmp138 = tmp35 - tmp42;
		    tmp141 = tmp139 - tmp140;
		    tmp142 = tmp138 + tmp141;
		    tmp150 = tmp141 - tmp138;
	       }
	       X[2 * iostride] = tmp136 + tmp137 + (K707106781 * (tmp142 + tmp147));
	       X[6 * iostride] = tmp136 + (K707106781 * tmp150) - (tmp137 + (K707106781 * tmp151));
	       Y[-2 * iostride] = tmp148 + tmp149 + (K707106781 * (tmp150 + tmp151));
	       Y[-6 * iostride] = tmp148 + (K707106781 * tmp147) - (tmp149 + (K707106781 * tmp142));
	  }
	  {
	       fftw_real tmp80;
	       fftw_real tmp125;
	       fftw_real tmp87;
	       fftw_real tmp133;
	       fftw_real tmp122;
	       fftw_real tmp126;
	       fftw_real tmp119;
	       fftw_real tmp132;
	       fftw_real tmp135;
	       fftw_real tmp117;
	       fftw_real tmp124;
	       fftw_real tmp102;
	       fftw_real tmp123;
	       fftw_real tmp129;
	       fftw_real tmp134;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp80 = tmp78 - tmp79;
	       tmp125 = tmp78 + tmp79;
	       {
		    fftw_real tmp83;
		    fftw_real tmp86;
		    fftw_real tmp120;
		    fftw_real tmp121;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp83 = tmp81 - tmp82;
		    tmp86 = tmp84 + tmp85;
		    tmp87 = K707106781 * (tmp83 - tmp86);
		    tmp133 = K707106781 * (tmp83 + tmp86);
		    tmp120 = tmp84 - tmp85;
		    tmp121 = tmp82 + tmp81;
		    tmp122 = K707106781 * (tmp120 - tmp121);
		    tmp126 = K707106781 * (tmp121 + tmp120);
	       }
	       {
		    fftw_real tmp130;
		    fftw_real tmp131;
		    fftw_real tmp109;
		    fftw_real tmp116;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp119 = tmp118 - tmp60;
		    tmp130 = tmp103 + tmp108;
		    tmp131 = tmp114 - tmp115;
		    tmp132 = (K923879532 * tmp130) - (K382683432 * tmp131);
		    tmp135 = (K923879532 * tmp131) + (K382683432 * tmp130);
		    tmp109 = tmp103 - tmp108;
		    tmp116 = tmp114 + tmp115;
		    tmp117 = (K382683432 * tmp109) - (K923879532 * tmp116);
		    tmp124 = (K382683432 * tmp116) + (K923879532 * tmp109);
		    {
			 fftw_real tmp94;
			 fftw_real tmp101;
			 fftw_real tmp127;
			 fftw_real tmp128;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp94 = tmp92 + tmp93;
			 tmp101 = tmp95 - tmp100;
			 tmp102 = (K923879532 * tmp94) + (K382683432 * tmp101);
			 tmp123 = (K382683432 * tmp94) - (K923879532 * tmp101);
			 tmp127 = tmp92 - tmp93;
			 tmp128 = tmp95 + tmp100;
			 tmp129 = (K382683432 * tmp127) + (K923879532 * tmp128);
			 tmp134 = (K923879532 * tmp127) - (K382683432 * tmp128);
		    }
	       }
	       X[3 * iostride] = tmp80 + tmp87 + tmp102 + tmp117;
	       Y[-7 * iostride] = tmp119 + tmp117 - (tmp122 + tmp102);
	       Y[-3 * iostride] = tmp119 + tmp122 + tmp123 + tmp124;
	       X[7 * iostride] = tmp80 + tmp123 - (tmp87 + tmp124);
	       X[iostride] = tmp125 + tmp126 + tmp129 + tmp132;
	       Y[-5 * iostride] = tmp132 - (tmp133 + tmp129) - (tmp60 + tmp118);
	       X[5 * iostride] = tmp125 + tmp134 - (tmp126 + tmp135);
	       Y[-iostride] = tmp133 + tmp134 + tmp135 - (tmp60 + tmp118);
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
fftw_codelet_desc fftw_hc2hc_forward_16_desc =
{
     "fftw_hc2hc_forward_16",
     (void (*)()) fftw_hc2hc_forward_16,
     16,
     FFTW_FORWARD,
     FFTW_HC2HC,
     259,
     15,
     twiddle_order,
};
