#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>
#include <grp.h>
#include <signal.h>
#include <errno.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/intattr.h"
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/warn.h"
#include "prjlibs-c/sys_param.h"

static char const var_groups[]="$GROUPS";
static char const var_home[]="$HOME";

char const* PROG="setstate";

int main(int argc, char** argv) {
  char const* x;
  unsigned int i;
  int do_chroot=0;
  int do_leader=0;
  int do_noleader=0;
  int do_setsid=0;
  int do_tty_chown=0;
  int do_tty_fg=0;
  int do_setgid=0;
  int do_setgroups=0;
  int do_setuid=0;
  int do_home=0;
  uid_t uid;
  gid_t gid;

  if (argc<3) DIE_USAGE(" -rlLsofgGuh command [arg ...]");

  x=argv[1];
  if (*x=='-') ++x;
  while (*x!='\0') {
    switch (*x) {
      case 'r': do_chroot=1;    break;
      case 'l': do_leader=1;    break;
      case 'L': do_noleader=1;  break;
      case 's': do_setsid=1;    break;
      case 'o': do_tty_chown=1; break;
      case 'f': do_tty_fg=1;    break;
      case 'g': do_setgid=1;    break;
      case 'G': do_setgroups=1; break;
      case 'u': do_setuid=1;    break;
      case 'h': do_home=1;      break;
      default: {
        char opt[2]={ '\0', '\0' };
        *opt=*x;
        DIE2X(100, "unrecognized option: ", opt);
      }
    }
    ++x;
  }

  if (do_chroot) {
    x=getenv(VAR_ROOT+1);
    if (x==NULLP) DIE_NOTSET(VAR_ROOT);
    if (chdir(x)!=0) DIE1(chdir, x);
    if (chroot(".")!=0) DIE1(chroot, x);
  }

  if (do_leader)
    if (setpgid(0, 0)!=0) DIE0(setpgid);

  if (do_noleader) {
    pid_t pid;
    int pipefd[2];
    if (pipe(pipefd)==-1) DIE0(pipe);
    pid=fork();
    if (pid==-1) DIE0(fork);
    if (pid==0) {
      if (close(pipefd[0])!=0) DIE1(close, "pipe");
      if (setpgid(0, 0)!=0) DIE0(setpgid);
      if (close(pipefd[1])!=0) DIE1(close, "pipe");
      pause();
      _exit(0);
    }
    if (close(pipefd[1])!=0) DIE1(close, "pipe");
    read(pipefd[0], &pipefd[1], 1);
    if (close(pipefd[0])!=0) DIE1(close, "pipe");
    if (setpgid(getpid(), pid)!=0) DIE0(setpgid);
    kill(pid, SIGKILL);
    if (waitpid_nointr(pid, NULLP, 0)!=pid) DIE0(wait);
  }

  if (do_setsid)
    if (setsid()<0) DIE0(setsid);

  if (do_tty_fg) {
    sigset_t ttou, old;
    if (sigemptyset(&ttou)!=0) DIE0(sigemptyset);
    if (sigaddset(&ttou, SIGTTOU)!=0) DIE0(sigaddset);
    if (sigprocmask(SIG_BLOCK, &ttou, &old)!=0) DIE0(sigprocmask);
    if (tcsetpgrp(0, getpgid(0))) DIE0(tcsetpgrp);
    if (sigprocmask(SIG_SETMASK, &old, NULLP)!=0) DIE0(sigprocmask);
  }

  if (do_tty_chown) {
    x=getenv(VAR_UID+1);
    if (x==NULLP) DIE_NOTSET(VAR_UID);
    i=uid_scan(x, &uid);
    if (i==0 || x[i]!='\0') DIE_MALFORMED(VAR_UID, x);
    if (fchown(STDIN_FILENO, uid, -1)!=0) DIE1(chown, "standard input");
  }

  if (do_setgid) {
    x=getenv(VAR_GID+1);
    if (x==NULLP) DIE_NOTSET(VAR_GID);
    i=gid_scan(x, &gid);
    if (i==0 || x[i]!='\0') DIE_MALFORMED(VAR_GID, x);
    if (setgid(gid)!=0) DIE0(setgid);
  }

  if (do_setgroups) {
    size_t ngroups;
    gid_t* groups;
    x=getenv(var_groups+1);
    if (x==NULLP) DIE_NOTSET(var_groups);
    {
      char const* y=x;
      ngroups=0;
      while (*y==' ') {
        ++ngroups;
        if (ngroups==0) DIE2X(100, var_groups, "too long");
        ++y;
        y+=str_chr(y, ' ');
      }
    }
    i=ngroups*sizeof (gid_t);
    if (i/sizeof (gid_t)!=ngroups) DIE2X(100, var_groups, "too long");
    groups=(void*)alloc(i);
    if (groups==NULLP) DIE0(alloc);
    ngroups=0;
    while (*x!='\0') {
      if (*x!=' ') DIE_MALFORMED(var_groups, x);
      ++x;
      i=gid_scan(x, &gid);
      if (i==0) DIE_MALFORMED(var_groups, x);
      x+=i;
      groups[ngroups]=gid;
      ++ngroups;
    }
    if (setgroups(ngroups, groups)!=0) DIE0(setgroups);
    alloc_free(groups);
  }

  if (do_setuid) {
    x=getenv(VAR_UID+1);
    if (x==NULLP) DIE_NOTSET(VAR_UID);
    i=uid_scan(x, &uid);
    if (i==0 || x[i]!='\0') DIE_MALFORMED(VAR_UID, x);
    if (setuid(uid)!=0) DIE0(setuid);
  }

  if (do_home) {
    x=getenv(var_home+1);
    if (x==NULLP) DIE_NOTSET(var_home);
    if (chdir(x)!=0) DIE1(chdir, x);
  }

  argv+=2;
  exec((char const**)argv);
  DIE1(exec, argv[0]);
}
