#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "fdtools.h"

char const* PROG="recvfd";

static void usage(void) gccattr_noreturn;
static void usage(void) {
  DIE_USAGE(" socket fd [...] : program ...");
}

int main(int argc, char** argv) {
  type_fd* fds_recvd, * fds_wanted;
  unsigned int sock;
  type_len pos;
  size_t nfds, allocsize, i;
  ssize_t nfds_recvd;
  if (argc<5) usage();
  pos=uint_scan(argv[1], &sock);
  if (pos==0 || argv[1][pos]!='\0' || sock>INT_MAX)
    DIE_MALFORMED_FD(argv[1]);
  argv+=2;
  for (nfds=0;; ++nfds) {
    if (argv[nfds]==NULL) usage();
    if (strcmp(argv[nfds], ":")==0) break;
  }
  if (nfds==0 || argv[nfds+1]==NULL) usage();
  allocsize=2*sizeof (type_fd);
  if (allocsize/2!=sizeof (type_fd)) DIE_OVERFLOW();
  allocsize*=nfds;
  if (allocsize/(2*sizeof (type_fd))!=nfds) DIE_OVERFLOW();
  fds_recvd=malloc(allocsize);
  if (fds_recvd==NULL) DIE0(alloc);
  fds_wanted=fds_recvd+nfds;
  nfds_recvd=fd_xfer_recv(sock, fds_recvd, nfds);
  if (nfds_recvd<0) DIE1(read, "from socket");
  if ((size_t)nfds_recvd!=nfds)
    DIE1X(100, "wrong number of descriptors received");
  for (i=0; i!=nfds; ++i) {
    unsigned int fd;
    type_len const pos=uint_scan(argv[i], &fd);
    if (argv[i][0]=='$') {
      fds_wanted[i]=-1;
    } else {
      if (pos==0 || argv[i][pos]!='\0' || fd>INT_MAX)
        DIE_MALFORMED_FD(argv[i]);
      fds_wanted[i]=fd;
    }
  }
  if (fd_shuffle(nfds, fds_recvd, fds_wanted)!=0) DIE0(dup);
  for (i=0; i!=nfds; ++i) {
    char buf[(sizeof (type_fd)*CHAR_BIT+2)/3+1];
    type_fd named_fd=fds_recvd[i];
    if (fds_wanted[i]>=0) continue;
    if (named_fd<10) {
      type_fd duped=fcntl(named_fd, F_DUPFD, 10);
      if (duped<0) DIE0(dup);
      fd_close(named_fd);
      named_fd=duped;
    }
    buf[int_fmt(buf, named_fd)]='\0';
    if (env_mexec(argv[i]+1, buf)==0) DIE0(alloc);
  }
  argv+=nfds+1;
  mexec0((char const**)argv);
  DIE1(exec, argv[0]);
}
