#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "prjlibs-c/vec.h"
#include "fdtools.h"

char const* PROG="pipecycle";

typedef struct {
  type_fd io[2];
  pid_t pid;
  int status;
} cmd;

int main(int argc, char** argv) {
  size_t n, i;
  type_fd start[2];
  VEC_T(cmd) cmds=VEC_0(cmd);

  if (argc<2) DIE_USAGE(" commandA [commandB...]");
  if (pipe(start)!=0) DIE0(pipe);
  n=argc-1;
  if ((int)n!=argc-1) DIE_OVERFLOW();
  if (VEC_PUSHN(cmd, &cmds, NULL, n)!=0) DIE0(alloc);
  for (i=0; i!=n; ++i) {
    cmd* c=VEC_ELT(cmd, &cmds, i);
    c->pid=0;
    if (pipe(c->io)!=0) DIE0(pipe);
  }

  for (i=0; i!=n; ++i) {
    size_t j;
    char const* const args[]={ "sh", "-c", argv[1u+i], NULL };
    cmd* c=VEC_ELT(cmd, &cmds, i);
    c->pid=fork();
    if (c->pid<0) {
      for (j=0; j!=i; ++j) kill(VEC_ELT(cmd, &cmds, j)->pid, SIGTERM);
      DIE0(fork);
    }
    if (c->pid>0) continue;
    fd_close(start[1]);
    for (j=0; j!=n; ++j) {
      cmd* c=VEC_ELT(cmd, &cmds, j);
      if (j!=i) fd_close(c->io[1]);
      if ((j+1u)%n!=i) fd_close(c->io[0]);
    }
    {
      cmd* c_prev=VEC_ELT(cmd, &cmds, (i-1u+n)%n);
      type_fd current[]={ c_prev->io[0], c->io[1] }, wanted[]={ 0, 1 };
      if (fd_shuffle(2, current, wanted)!=0) DIE0(dup);
    }
    read(start[0], &j, 1);
    mexec(args);
    DIE1(exec, args[0]);
  }

  for (i=0; i!=n; ++i) {
    cmd* c=VEC_ELT(cmd, &cmds, i);
    fd_close(c->io[0]);
    fd_close(c->io[1]);
  }
  fd_close(start[0]);
  fd_close(start[1]);

  {
    size_t n_exited;
    for (n_exited=0; n_exited!=n;) {
      int status;
      pid_t pid;
      /* Now we'll abuse each io[0] as a flag, indicating that the child
         exited "recently". */
      for (i=0; i!=n; ++i)
        VEC_ELT(cmd, &cmds, i)->io[0]=0;
      do { pid=wait(&status); } while (pid<0 && errno==EINTR);
      for (;; pid=wait_nohang(&status)) {
        if (pid==0) break;
        if (pid<0 && errno==ECHILD) break;
        if (pid<0) DIE0(wait);
        for (i=0; i!=n; ++i) {
          cmd* c=VEC_ELT(cmd, &cmds, i);
          if (c->pid==pid) {
            c->pid=0;
            c->status=status;
            c->io[0]=1;
            ++n_exited;
            break;
          }
        }
      }
      for (i=0; i!=n; ++i) {
        cmd* c=VEC_ELT(cmd, &cmds, i);
        cmd* c_next=VEC_ELT(cmd, &cmds, (i+1u)%n);
        if (n>1 && c->io[0]==1 && c_next->pid==0 && WIFSIGNALED(c->status) &&
            WTERMSIG(c->status)==SIGPIPE)
          c->status=0;
      }
    }
  }

  for (i=0; i!=n; ++i) {
    cmd* c=VEC_ELT(cmd, &cmds, i);
    if (WIFEXITED(c->status) && WEXITSTATUS(c->status)!=0)
      _exit(WEXITSTATUS(c->status));
    if (WIFSIGNALED(c->status)) {
      type_signal sig=WTERMSIG(c->status);
      sig_unblock(sig);
      signal(sig, SIG_DFL);
      raise(sig);
    }
  }

  _exit(0);
}
