#include "standards.h"
#include <stdlib.h>

#include "vec.h"

type_status vec_alloc(size_t typesize, vec_type* v, size_t n, type_bool plus) {
  unsigned char* snew;
  size_t anew=n*typesize;
  if (anew/typesize!=n) goto overflow;
  if (plus) {
    anew+=v->len;
    if (anew<v->len) goto overflow;
  }
  if (anew<=v->a) return 0;
  snew=realloc(v->s, anew);
  if (snew==NULL) return -1;
  v->a=anew;
  v->s=snew;
  return 0;
  overflow:
  errno=EINVAL;
  return -1;
}
