my %vars = vars();
my ($ret, $out, $err);
my $pfx;

######################################################################
### prints the version and exits

foreach ("--version", "-V") {
    $pfx = "version string ($_)";
    clean();
    ($ret, $out, $err) = etcmanage($_);

    ## test 1, test 5
    is_num($ret, 0, "$pfx: runs successfully");

    ## test 2, test 6
    is($err, "", "$pfx: doesn't print anything to STDERR");

    ## test 3, test 7
    like($out, qr|^\Q$ENV{PACKAGE_STRING}\E\n|,
	 "$pfx: writes version string as first line to STDOUT");

    ## test 4, test 8
    ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");
}

######################################################################
### ignores other commands

$pfx = "ignores other commands";
clean();
($ret, $out, $err) = etcmanage("--manual", "/etc/foo", "--print", "--version");

## test 9
is_num($ret, 0, "$pfx: runs successfully");

## test 10
is($err, "", "$pfx: doesn't print anything to STDERR");

## test 11
like($out, qr|^\Q$ENV{PACKAGE_STRING}\E\n|,
     "$pfx: writes '$ENV{PACKAGE_STRING}' as first line to STDOUT");

## test 12
unlike($out, qr|^/etc/foo manual$|m, "$pfx: doesn't process other commands");

## test 13
ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");

done_testing(13);
