my %vars = vars();
my ($ret, $out, $err);
my $pfx;
my %manifest;
my $md5;

######################################################################
### simple remove

clean();
etcmanage("--add", "/foo", "--md5", hash("foo"));
($ret, $out, $err) = etcmanage("--remove", "/foo");
$pfx = "simple remove";

# test 1
is_num($ret, 0, "$pfx: exits with 0 status");

# test 2
is($err, "", "$pfx: doesn't write to STDERR");

# test 3
is($out, "", "$pfx: doesn't write to STDOUT");

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 4
is_manifest(\%manifest, {}, "$pfx: entry removed");

######################################################################
### removing a file that doesn't exist works

clean();
($ret, $out, $err) = etcmanage("--remove", "/foo");
$pfx = "remove non-existant";

# test 5
is_num($ret, 0, "$pfx: exits with 0 status");

# test 6
is($err, "", "$pfx: doesn't write to STDERR");

# test 7
is($out, "", "$pfx: doesn't write to STDOUT");

######################################################################
### abnormal pathnames

$md5 = hash("X");
foreach (@{$vars{abnormal_files}}) {
    $pfx = escape("abnormal pathname '$_'");

    clean();
    etcmanage("--no-safety-checks", "--add", $_, "--md5", $md5);
    ($ret, $out, $err) = etcmanage("--remove", $_);

    ## tests 8 through 51
    is_num($ret, 0, "$pfx: returns 0 exit status");
    like($err, qr/^(?:WARNING: .*\n){1,2}\z/,
	 "$pfx: writes a warning to STDERR");
    is($out, "", "$pfx: writes nothing to STDOUT");

    ($ret, $out, $err) = etcmanage("--no-safety-checks", "--print");
    %manifest = parse_manifest($out);

    is_deeply(\%manifest, {}, "$pfx: removed from db");
}

done_testing(51);
