my %vars = vars();
my @dummy_files = @{$vars{dummy_files}};
my %dummy_manifest = %{$vars{dummy_manifest}};
my ($ret, $out, $err);
my %manifest;
my $pfx;
my $md5;

######################################################################
### add files one at a time

clean();
create_dummy_files();

while (my ($f_in, $h) = each(%dummy_manifest)) {
    my $pfx = "--add $f_in --md5 $h";

    ($ret, $out, $err) = etcmanage("--add", $f_in, "--md5", $h);

    # test 1, test 4, test 7, test 10, test 13
    is_num($ret, 0, "$pfx: doesn't fail");

    # test 2, test 5, test 8, test 11, test 14
    is($err, "", "$pfx: doesn't write to STDERR");

    # test 3, test 6, test 9, test 12, test 15
    is($out, "", "$pfx: doesn't write to STDOUT");
}

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 16
is_manifest(\%manifest, \%dummy_manifest, "one at a time: manifest matches");

######################################################################
### add files all at once

clean();
create_dummy_files();

($ret, $out, $err) = etcmanage(
    map(("--add", $_, "--md5", $dummy_manifest{$_}), @dummy_files));

# test 17
is_num($ret, 0, "all at once: doesn't fail");

# test 18
is($err, "", "all at once: doesn't write to STDERR");

# test 19
is($out, "", "all at once: doesn't write to STDOUT");

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 20
is_manifest(\%manifest, \%dummy_manifest, "all at once: manifest matches");

######################################################################
### add files all at once, mix and match with/without --md5

clean();
create_dummy_files();

foreach (1..5) {
    my @selectors = map(int(rand(2)), (0..@dummy_files-1));
    my $pfx = "mix with/without --md5, pass=$_ seed=$vars{seed} sel="
	. join("", @selectors);
    my @args = map(
	(
	 "--add", $dummy_files[$_],
	 ($selectors[$_]
	  ? ("--md5", $dummy_manifest{$dummy_files[$_]})
	  : ()),
	),
	(0..@dummy_files-1));

    ($ret, $out, $err) = etcmanage(@args);

    # test 21, test 25, test 29, test 33, test 37
    is_num($ret, 0, "$pfx: doesn't fail");

    # test 22, test 26, test 30, test 34, test 38
    is($err, "", "$pfx: doesn't write to STDERR");

    # test 23, test 27, test 31, test 35, test 39
    is($out, "", "$pfx: doesn't write to STDOUT");

    ($ret, $out, $err) = etcmanage("--print");
    %manifest = parse_manifest($out);

    # test 24, test 28, test 32, test 36, test 40
    is_manifest(\%manifest, \%dummy_manifest, "$pfx: manifest matches");
}

######################################################################
### abnormal pathnames (safety checks enabled)

$md5 = hash("X");
foreach (@{$vars{abnormal_files}}) {
    $pfx = escape("abnormal pathname '$_'");

    clean();
    ($ret, $out, $err) = etcmanage("--add", $_, "--md5", $md5);

    ## tests 41 through 73
    isnt_num($ret, 0, "$pfx: exits with non-0 status");
    like($err, qr/^(?:ERROR: .*\n)\z/,
	 "$pfx: prints an error message");
    is($out, "", "$pfx: doesn't write to STDOUT");
}

######################################################################
### abnormal pathnames (safety checks disabled)

$md5 = hash("X");
foreach (@{$vars{abnormal_files}}) {
    $pfx = escape("abnormal pathname (safety checks disabled) '$_'");

    clean();
    ($ret, $out, $err) = etcmanage(
	"--no-safety-checks", "--add", $_, "--md5", $md5);

    ## tests 73 through 117
    is_num($ret, 0, "$pfx: exits with 0 status");
    like($err, qr/^(?:WARNING: .*\n){1,2}\z/, "$pfx: prints a warning");
    is($out, "", "$pfx: doesn't write to STDOUT");

    ($ret, $out, $err) = etcmanage("--no-safety-checks", "--print");

    is($out, "$_ $md5\n", "$pfx: database contents match expected");
}

done_testing(117);
