my %vars = vars();
my ($ret, $out, $err);
my $pfx;
my @files;

######################################################################
### list a file that is in the db and one that isn't

$pfx = "list both present and missing";
clean();
@files = map(catfile(rootdir(), $_), "a", "b");
set_filestate([undef, undef, undef], $files[0]);
set_filestate([undef, "X", undef], $files[1]);

($ret, $out, $err) = etcmanage(map(("--list", $_), @files));

## test 1
is_num($ret, 0, "$pfx: returns 0 exit status");

## test 2
is($err, "", "$pfx: doesn't write to STDERR");

## test 3
is(sortlines($out),
   join("", sort("$files[1] " . hash("X") . "\n", "NOT $files[0]\n")),
   "$pfx: writes the expected messages to STDOUT");

######################################################################
### abnormal pathnames

foreach (@{$vars{abnormal_files}}) {
    $pfx = escape("abnormal pathname '$_'");

    clean();
    ($ret, $out, $err) = etcmanage("--list", $_);

    ## tests 4 through 36
    is_num($ret, 0, "$pfx: exits with 0 status");
    like($err, qr/^(?:WARNING: .*\n){1,2}\z/, "$pfx: prints a warning");
    is($out, "NOT $_\n", "$pfx: write the expected message to STDOUT");
}

done_testing(36);
