my %vars = vars();
my ($ret, $out, $err);
my $pfx;
my %manifest;
my %input_manifest;
my $md5;

######################################################################
### import to an empty db where all files match the manifest

$pfx = "empty db, all files match";
clean();
create_dummy_files();
($ret, $out, $err) = etcmanage("--generate-manifest", $vars{upstream_dir_in});
%input_manifest = parse_manifest($out);
($ret, $out, $err) = etcmanage_with_input($out, "--import-manifest");

## test 1
is_num($ret, 0, "$pfx: exits with 0 status");

## test 2
is($err, "", "$pfx: doesn't write to STDERR");

## test 3
is(join("", sortlines($out)),
   join("", sort(map("ADDING $_ $vars{dummy_manifest}->{$_}\n",
			   @{$vars{dummy_files}}))),
   "$pfx: writes expected strings to STDOUT");

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

## test 4
is_manifest(\%manifest, \%input_manifest, "$pfx: db matches provided");

## test 5
is_manifest(\%manifest, $vars{dummy_manifest}, "$pfx: db matches expected");

######################################################################
### abnormal pathnames

$md5 = hash("X");
foreach my $safety_enabled (1, 0) {
    foreach (@{$vars{abnormal_files}}) {
	# can't test pathnames with whitespace, pathnames beginning
	# with a comment character, or empty pathnames because the
	# resulting manifest would be parsed incorrectly
	next if (/\s|^(?:#|\z)/);

	$pfx = "abnormal pathname";
	$pfx .= " (safety checks disabled)" if (!$safety_enabled);
	$pfx .= " '$_'";
	clean();

	my $f_out = catfile($vars{live_dir}, $_);
	make_path(dirname($f_out));
	open(my $fh, ">", $f_out) or die("unable to open $f_out: $!");
	print($fh "X");
	$fh->close();

	($ret, $out, $err) = etcmanage_with_input(
	    "$_ $md5\n",
	    $safety_enabled ? () : ("--no-safety-checks",),
	    "--import-manifest");

	## tests 6 through 37

	if ($safety_enabled) {
	    isnt_num($ret, 0, "$pfx: exits with non-0 status");
	    like($err, qr/^(?:ERROR: .*\n)\z/,
		 "$pfx: prints an error message");
	    is($out, "", "$pfx: doesn't write to STDOUT");
	} else {
	    is_num($ret, 0, "$pfx: exits with 0 status");
	    like($err, qr/^(WARNING: .*\n)\1*\z/,
		 "$pfx: prints a warning");
	    is($out, "ADDING $_ $md5\n", "$pfx: logs ADDING message");
	}

	($ret, $out, $err) = etcmanage("--no-safety-checks", "--print");

	if ($safety_enabled) {
	    is($out, "", "$pfx: database still empty");
	} else {
	    is($out, "$_ $md5\n", "$pfx: file added to database");
	}
    }
}

done_testing(37);
