my %vars = vars();
my ($ret, $out, $err);
my $pfx;

######################################################################
### prints a usage message and exits

foreach ("--help", "-h") {
    $pfx = "usage message ($_)";
    clean();
    ($ret, $out, $err) = etcmanage($_);

    ## test 1, test 5
    is_num($ret, 0, "$pfx: runs successfully");

    ## test 2, test 6
    is($err, "", "$pfx: doesn't print anything to STDERR");

    ## test 3, test 7
    isnt($out, "", "$pfx: writes to STDOUT");

    ## test 4, test 8
    ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");
}

######################################################################
### ignores other commands

$pfx = "ignores other commands";
clean();
($ret, $out, $err) = etcmanage("--manual", "/etc/foo", "--print", "--help");

## test 9
is_num($ret, 0, "$pfx: runs successfully");

## test 10
is($err, "", "$pfx: doesn't print anything to STDERR");

## test 11
isnt($out, "", "$pfx: writes to STDOUT");

## test 12
unlike($out, qr|^/etc/foo manual$|m, "$pfx: doesn't process other commands");

## test 13
ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");

done_testing(13);
