my %vars = vars();
my ($ret, $out, $err);
my $pfx;

######################################################################
### test updating when both live and upstream dirs are empty

clean();
create_directories();
($ret, $out, $err) = etcmanage("--generate-manifest", $vars{upstream_dir_in});

# test 1
is_num($ret, 0, "empty dir: doesn't fail");

# test 2
is($err, "", "empty dir: doesn't write anything to STDERR");

# test 3
my $out_nocomments = join("\n", grep(!/^#/, split(/^/m, $out)));
is($out_nocomments, "", "empty dir: doesn't write any non-comments to STDOUT");

# test 4
ok(! -f $vars{dbfile_out}, "doesn't create a database file");

######################################################################
### test manifest on fresh dummy dir

clean();
create_dummy_files();
($ret, $out, $err) = etcmanage("--generate-manifest", $vars{upstream_dir_in});

# test 5
is_num($ret, 0, "fresh dummy dir: doesn't fail");

# test 6
is($err, "", "fresh dummy dir: doesn't write anything to STDERR");

my %manifest = parse_manifest($out);

# tests 7
is_manifest(\%manifest, $vars{dummy_manifest},
	    "fresh dummy dir: manifest matches");

######################################################################
### test abort on suspicious directory

clean();
create_dummy_files();
{
    my $f = catfile($vars{upstream_dir_out}, "sbin", "init");
    make_path(dirname($f));
    open(my $fh, ">", $f) or die("unable to open $f");
    print($fh "foo");
}
($ret, $out, $err) = etcmanage("--generate-manifest", $vars{upstream_dir_in});

# test 8
isnt_num($ret, 0, "suspicious dir: exits with non-0 status");

# test 9
like($err, qr/^(?:ERROR: .*\n)\z/, "suspicious dir: prints an error message");

# test 10
is($out, "", "suspicious dir: doesn't generate a manifest");

######################################################################
### test abort on invalid directory

clean();
($ret, $out, $err) = etcmanage(
    "--generate-manifest", catfile(rootdir(), "foo", "bar", "baz"));
$pfx = "invalid dir";

# test 11
isnt_num($ret, 0, "$pfx: exits with non-0 status");

# test 12
like($err, qr/^(?:ERROR: .*\n)\z/, "$pfx: prints an error message");

# test 13
is($out, "", "$pfx: doesn't generate a manifest");

done_testing(13);
