use File::Path qw(make_path);
use File::Spec::Functions qw(:ALL);

my %vars = vars();
my ($ret, $out, $err);
my $pfx;
my @dirs = ("a", "b");

######################################################################
### create multiple dbs in one invocation

clean();
$pfx = "multiple --destdir";
make_path(catdir($vars{test_dir}, $_)) foreach (@dirs);
($ret, $out, $err) = etcmanage(
    map(("--destdir", catdir($vars{test_dir}, $_),
	 "--add", catfile(rootdir(), $_), "--md5", hash($_)), @dirs));

## test 1
is_num($ret, 0, "$pfx: returns 0 exit status");

## test 2
is($err, "", "$pfx: doesn't write to STDERR");

## test 3
is($out, "", "$pfx: doesn't write to STDOUT");

## test 4, test 5
ok(-r catfile($vars{test_dir}, $_, $vars{dbfile_in}),
   "$pfx: db in subdir $_ exists") foreach (@dirs);

######################################################################
### check values in each database

foreach (@dirs) {
    ($ret, $out, $err) = etcmanage(
	"--destdir", catdir($vars{test_dir}, $_), "--print");
    $pfx = "check db contents in $_";

    ## test 6, test 9
    is_num($ret, 0, "$pfx: returns 0 exit status");

    ## test 7, test 10
    is($err, "", "$pfx: doesn't write to STDERR");

    my %manifest = parse_manifest($out);

    ## test 8, test 11
    is_manifest(\%manifest, { catfile(rootdir(), $_) => hash($_), },
		"$pfx: contents match");
}

######################################################################
### check abort on invalid directory

clean();
$pfx = "invalid dir";
($ret, $out, $err) = etcmanage("--destdir", catdir($vars{test_dir}, "foo"));

## test 12
isnt_num($ret, 0, "$pfx: exits with non-0 status");

## test 13
like($err, qr/^(?:ERROR: .*\n){2}\z/, "$pfx: prints an error message");

## test 14
is($out, "", "$pfx: doesn't write anything to STDOUT");

done_testing(14);
