use File::Spec::Functions qw(:ALL);

my %vars = vars();
my ($ret, $out, $err);
my $pfx;

for my $dbfile_in (
    $vars{dbfile_in},
    catfile(rootdir(), "foo", "bar", "baz.db"),
    ) {

    my $dbfile_out = ($dbfile_in eq $vars{dbfile_in})
	? $vars{dbfile_out} : catfile($vars{live_dir}, $dbfile_in);
    my @args = (
	($dbfile_in eq $vars{dbfile_in}) ? () : ("--db", $dbfile_in),
	"--print");
    $pfx = "'etcmanage " . join(" ", @args) . "'";

    clean();
    ($ret, $out, $err) = etcmanage(@args);

    # test 1, test 5
    is_num($ret, 0, "$pfx: runs successfully");

    # test 2, test 6
    is($err, "", "$pfx: doesn't print anything to STDERR");

    # test 3, test 7
    ok(-f $dbfile_out, "$pfx: database file $dbfile_in created");

    # test 4, test 8
    is($out, "", "$pfx: new database file is empty");
}

done_testing(8);
