my %vars = vars();
my @dummy_files = @{$vars{dummy_files}};
my %dummy_manifest = %{$vars{dummy_manifest}};
my ($ret, $out, $err);
my %manifest;

clean();
create_dummy_files();

while (my ($f_in, $h) = each(%dummy_manifest)) {
    ($ret, $out, $err) = etcmanage("--add", $f_in, "--md5", $h);
}

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 1
is_manifest(\%manifest, \%dummy_manifest, "initial: manifest matches");

($ret, $out, $err) = etcmanage("--clear");

# test 2
is_num($ret, 0, "clear: doesn't fail");

# test 3
is($err, "", "clear: doesn't write to STDERR");

# test 4
is($out, "", "clear: doesn't write to STDOUT");

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 5
is_manifest(\%manifest, {}, "clear: database is empty");

done_testing(5);
