my %vars = vars();
my @dummy_files = @{$vars{dummy_files}};
my %dummy_manifest = %{$vars{dummy_manifest}};
my ($ret, $out, $err);
my %manifest;
my $pfx;

######################################################################
### add files one at a time

clean();
create_dummy_files();

foreach my $f_in (@dummy_files) {
    my $pfx = "--add $f_in";

    ($ret, $out, $err) = etcmanage("--add", $f_in);

    # test 1, test 4, test 7, test 10, test 13
    is_num($ret, 0, "$pfx: doesn't fail");

    # test 2, test 5, test 8, test 11, test 14
    is($err, "", "$pfx: doesn't write to STDERR");

    # test 3, test 6, test 9, test 12, test 15
    is($out, "", "$pfx: doesn't write to STDOUT");
}

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 16
is_manifest(\%manifest, \%dummy_manifest, "one at a time: manifest matches");

######################################################################
### add files all at once

clean();
create_dummy_files();

($ret, $out, $err) = etcmanage(map(("--add", $_), @dummy_files));

# test 17
is_num($ret, 0, "all at once: doesn't fail");

# test 18
is($err, "", "all at once: doesn't write to STDERR");

# test 19
is($out, "", "all at once: doesn't write to STDOUT");

($ret, $out, $err) = etcmanage("--print");
%manifest = parse_manifest($out);

# test 20
is_manifest(\%manifest, \%dummy_manifest, "all at once: manifest matches");

######################################################################
### reject non-existent files

$pfx = "reject non-existent files";
clean();
($ret, $out, $err) = etcmanage("--add", "/does-not-exist");

# test 21
isnt_num($ret, 0, "$pfx: exits with non-0 status");

# test 22
like($err, qr/^(?:ERROR: .*\n)\z/, "$pfx: prints an error message");

# test 23
is($out, "", "$pfx: doesn't write to STDOUT");

######################################################################
### reject empty filename

## see t1090-etcmanage-md5.pl for rejection of other abnormal paths

$pfx = "reject empty filename";
clean();
($ret, $out, $err) = etcmanage("--no-safety-checks", "--add", "");

# test 24
isnt_num($ret, 0, "$pfx: exits with non-0 status");

# test 25
like($err, qr/^(?:WARNING: .*\n)(?:ERROR: .*\n)\z/,
     "$pfx: prints an error message");

# test 26
is($out, "", "$pfx: doesn't write to STDOUT");

done_testing(26);
