my %vars = vars();
my ($ret, $out, $err);
my $pfx;

######################################################################
### runs OK with no arguments

$pfx = "no arguments";
clean();
($ret, $out, $err) = etcmanage();

# test 1
is_num($ret, 0, "$pfx: runs successfully");

# test 2
is($err, "", "$pfx: doesn't print anything to STDERR");

# test 3
is($out, "", "$pfx: doesn't print anything to STDOUT");

# test 4
ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");

######################################################################
### check abort on invalid option

$pfx = "invalid option";
clean();
($ret, $out, $err) = etcmanage("--bad-option");

# test 5
isnt_num($ret, 0, "$pfx: exits with non-0 status");

# test 6
isnt($err, "", "$pfx: prints an error message");

# test 7
is($out, "", "$pfx: doesn't write anything to STDOUT");

######################################################################
### bail on invalid non-option argument

$pfx = "invalid non-option argument";
clean();
($ret, $out, $err) = etcmanage("--manual", "/etc/foo", "--print",
			       "--", "bad-non-option-argument");

# test 8
isnt_num($ret, 0, "$pfx: exits with non-0 status");

# test 9
isnt($err, "", "$pfx: prints an error message");

# test 10
is($out, "", "$pfx: doesn't write anything to STDOUT");

# test 11
ok(! -f $vars{dbfile_out}, "$pfx: doesn't create a database");

done_testing(11);
