/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: unicode.h,v 1.3 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_unicode_h_
#define	_unicode_h_

#include "osd.h"

#define	NEED_WCNAME		0
#define	NEED_WCNAME10	0
#define	NEED_WCCOMMENT	0
#define	NEED_WCGCAT		0
#define	NEED_WCCOMM		0
#define	NEED_WCBIDI		0
#define	NEED_WCDECO		0
#define	NEED_WCDIGIT	0
#define	NEED_WCNUMERIC	0
#define	NEED_WCMIRRORED	0
#define	NEED_WCUCASE	0
#define	NEED_WCLCASE	0
#define	NEED_WCTCASE	0
#define	NEED_WCWIDTH	1
#define	NEED_WCRANGES	0
#define	NEED_WCENCODE	1

typedef struct fontmap_s {
	uint8_t bytecode;
	uint16_t unicode;
}	fontmap_t;

const fontmap_t *map_iso8859_1;
const fontmap_t *map_iso8859_2;
const fontmap_t *map_iso8859_3;
const fontmap_t *map_iso8859_4;
const fontmap_t *map_iso8859_5;
const fontmap_t *map_iso8859_7;
const fontmap_t *map_iso8859_8;
const fontmap_t *map_iso8859_9;
const fontmap_t *map_iso8859_10;
const fontmap_t *map_iso8859_13;
const fontmap_t *map_iso8859_14;
const fontmap_t *map_iso8859_15;
const fontmap_t *map_jisx201_1976;
const fontmap_t *map_koi8_r;
const fontmap_t *map_cp437;

/* information about a unicode character code */
typedef struct unicode_data_s {
#if	NEED_WCNAME
	const char *name;
#endif
#if	NEED_WCNAME10
	const char *name10;
#endif
#if	NEED_WCCOMMENT
	const char *comment;
#endif
#if	NEED_WCGCAT
	uint8_t gcat;
#endif
#if	NEED_WCCOMM
	uint8_t ccom;
#endif
#if	NEED_WCBIDI
	uint8_t bidi;
#endif
#if	NEED_WCDECO
	uint8_t deco;
#endif
#if	NEED_WCDIGIT
	uint8_t decimal_digit;
	uint8_t digit;
#endif
#if	NEED_WCNUMERIC
	uint8_t numeric;
#endif
#if	NEED_WCMIRRORED
	int mirrored;
#endif
#if	NEED_WCDECN
	uint8_t decn;
	uint16_t *decp;
#endif
#if	NEED_WCUCASE
	uint16_t uppercase;
#endif
#if	NEED_WCLCASE
	uint16_t lowercase;
#endif
#if	NEED_WCTCASE
	uint16_t titlecase;
#endif
#if	NEED_WCWIDTH
	uint8_t width;
#endif
}	unicode_data_t;

#if	NEED_WCGCAT
enum general_category_e {
	gcat_0,		/* invalid value */
	gcat_Lu,	/* Letter, Uppercase */
	gcat_Ll,	/* Letter, Lowercase */
	gcat_Lt,	/* Letter, Titlecase */
	gcat_Mn,	/* Mark, Non-Spacing */
	gcat_Mc,	/* Mark, Spacing Combining */
	gcat_Me,	/* Mark, Enclosing */
	gcat_Nd,	/* Number, Decimal Digit */
	gcat_Nl,	/* Number, Letter */
	gcat_No,	/* Number, Other */
	gcat_Zs,	/* Separator, Space */
	gcat_Zl,	/* Separator, Line */
	gcat_Zp,	/* Separator, Paragraph */
	gcat_Cc,	/* Other, Control */
	gcat_Cf,	/* Other, Format */
	gcat_Cs,	/* Other, Surrogate */
	gcat_Co,	/* Other, Private Use */
	gcat_Cn,	/* Other, Not Assigned (no characters have this property) */
	gcat_Lm,	/* Letter, Modifier */
	gcat_Lo,	/* Letter, Other */
	gcat_Pc,	/* Punctuation, Connector */
	gcat_Pd,	/* Punctuation, Dash */
	gcat_Ps,	/* Punctuation, Open */
	gcat_Pe,	/* Punctuation, Close */
	gcat_Pi,	/* Punctuation, Initial quote */
	/* (may behave like Ps or Pe depending on usage) */
	gcat_Pf,	/* Punctuation, Final quote */
	/* (may behave like Ps or Pe depending on usage) */
	gcat_Po,	/* Punctuation, Other */
	gcat_Sm,	/* Symbol, Math */
	gcat_Sc,	/* Symbol, Currency */
	gcat_Sk,	/* Symbol, Modifier */
	gcat_So		/* Symbol, Other */
};
#endif

#if	NEED_WCBIDI
enum bidirectional_category_e {
	bidi_0,		/* invalid value */
	bidi_L,		/* Left-to-Right */
	bidi_LRE,	/* Left-to-Right Embedding */
	bidi_LRO,	/* Left-to-Right Override */
	bidi_R,		/* Right-to-Left */
	bidi_AL,	/* Right-to-Left Arabic */
	bidi_RLE,	/* Right-to-Left Embedding */
	bidi_RLO,	/* Right-to-Left Override */
	bidi_PDF,	/* Pop Directional Format */
	bidi_EN,	/* European Number */
	bidi_ES,	/* European Number Separator */
	bidi_ET,	/* European Number Terminator */
	bidi_AN,	/* Arabic Number */
	bidi_CS,	/* Common Number Separator */
	bidi_NSM,	/* Non-Spacing Mark */
	bidi_BN,	/* Boundary Neutral */
	bidi_B,		/* Paragraph Separator */
	bidi_S,		/* Segment Separator */
	bidi_WS,	/* Whitespace */
	bidi_ON		/* Other Neutrals */
};
#endif

#if	NEED_WCDECO
enum decomposition_mapping_e
{
	deco_0,			/* invalid value */
	deco_canonical, /* canonical mapping */
	deco_font,		/* A font variant (e.g. a blackletter form). */
	deco_noBreak,	/* A no-break version of a space or hyphen. */
	deco_initial,	/* An initial presentation form (Arabic). */
	deco_medial,	/* A medial presentation form (Arabic). */
	deco_final, 	/* A final presentation form (Arabic). */
	deco_isolated,	/* An isolated presentation form (Arabic). */
	deco_circle,	/* An encircled form. */
	deco_super, 	/* A superscript form. */
	deco_sub,		/* A subscript form. */
	deco_vertical,	/* A vertical layout presentation form. */
	deco_wide,		/* A wide (or zenkaku) compatibility character. */
	deco_narrow,	/* A narrow (or hankaku) compatibility character. */
	deco_small, 	/* A small variant form (CNS compatibility). */
	deco_square,	/* A CJK squared font variant. */
	deco_fraction,	/* A vulgar fraction form. */
	deco_compat 	/* Otherwise unspecified compatibility character. */
};
#endif

#ifdef	__cplusplus
extern "C" {
#endif

const fontmap_t *wcmapset(const char *charset);

uint32_t wcmapcode(const fontmap_t *map, uint8_t ch);
uint8_t mapencode(const fontmap_t *map, uint32_t ucs);

#define	wc_iso8859_1(ch) wcmapcode(map_iso8859_1, ch)
#define	wc_iso8859_2(ch) wcmapcode(map_iso8859_2, ch)
#define	wc_iso8859_3(ch) wcmapcode(map_iso8859_3, ch)
#define	wc_iso8859_4(ch) wcmapcode(map_iso8859_4, ch)
#define	wc_iso8859_5(ch) wcmapcode(map_iso8859_5, ch)
#define	wc_iso8859_7(ch) wcmapcode(map_iso8859_7, ch)
#define	wc_iso8859_8(ch) wcmapcode(map_iso8859_8, ch)
#define	wc_iso8859_9(ch) wcmapcode(map_iso8859_9, ch)
#define	wc_iso8859_10(ch) wcmapcode(map_iso8859_10, ch)
#define	wc_iso8859_13(ch) wcmapcode(map_iso8859_13, ch)
#define	wc_iso8859_14(ch) wcmapcode(map_iso8859_14, ch)
#define	wc_iso8859_15(ch) wcmapcode(map_iso8859_15, ch)
#define	wc_jisx201_1976(ch) wcmapcode(map_jisx201_1976, ch)
#define	wc_koi8_r(ch) wcmapcode(map_koi8_r, ch)
#define	wc_cp437(ch) wcmapcode(map_cp437, ch)

#if	NEED_WCNAME
const char *wcname(uint32_t ucs);
#endif

#if	NEED_WCNAME10
const char *wcname10(uint32_t ucs);
#endif

#if	NEED_WCCOMMENT
const char *wccomment(uint32_t ucs);
#endif

#if	NEED_WCGAT
uint8_t wcgcat(uint32_t ucs);
const char *wcgcat_name(uint32_t ucs);
#endif

#if	NEED_WCCOM
uint8_t wcccom(uint32_t ucs);
const char *wcccom_name(uint32_t ucs);
#endif

#if	NEED_WCBIDI
uint8_t wcbidi(uint32_t ucs);
const char *wcbidi_name(uint32_t ucs);
#endif

#if	NEED_WCDECO
uint8_t wcdeco(uint32_t ucs);
const char *wcdeco_name(uint32_t ucs);
#endif

#if	NEED_WCDECN
uint32_t wcdeco_n(uint32_t ucs, int n);
#endif

#if	NEED_WCDECIMAL
uint8_t wcdecimal(uint32_t ucs);
#endif

#if	NEED_WCDIGIT
uint8_t wcdigit(uint32_t ucs);
#endif

#if	NEED_WCNUMERIC
uint8_t wcnumeric(uint32_t ucs);
#endif

#if	NEED_WCMIRRORED
int wcmirrored(uint32_t ucs);
#endif

#if	NEED_WCUCASE
uint32_t wcucase(uint32_t ucs);
#endif

#if	NEED_WCLCASE
uint32_t wclcase(uint32_t ucs);
#endif

#if	NEED_WCTCASE
uint32_t wctcase(uint32_t ucs);
#endif

#if	NEED_WCWIDTH
int ucs_wcwidth(uint32_t ucs);
#endif

#if	NEED_WCRANGES
const char *wcrange_name(uint32_t ucs);
uint32_t wcrange_first(uint32_t ucs);
uint32_t wcrange_last(uint32_t ucs);
#endif

#if	NEED_WCENCODE
#define	WC_UTF8	0
int wcencode(char *dst, uint32_t ucs, int mode);
#endif

int unicode(void);

#ifdef __cplusplus
}
#endif

#endif	/* !defined(_unicode_h_) */
