/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: client.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef _node_h_
#define	_node_h_

#include "osd.h"
#include "sock.h"
#include "uri.h"
#include "base64.h"
#include "file.h"
#include "store.h"
#include "peer.h"

#ifdef	__cplusplus
extern "C" {
#endif

int node_format_error(conn_t *conn, const char *fmt, ...);
int node_hello(conn_t *conn);
int client_hello(conn_t *conn);
int node_uri_error(conn_t *conn);
int node_restarted(conn_t *conn);
int node_data_not_found(conn_t *conn, const char *reason);
int node_route_not_found(conn_t *conn, const char *reason);
int node_data_found(conn_t *conn, size_t datalen, size_t metadatalen);
int client_get(conn_t *conn);
int node_pending(conn_t *conn, const char *uri,
	const char *svk_public, const char *svk_private);
int node_success(conn_t *conn, const char *uri,
	const char *svk_public, const char *svk_private);
int client_put(conn_t *conn);
int client_command(conn_t *conn);
int client(void);

#ifdef	__cplusplus
}
#endif

#endif	/* !defined(_node_h_) */
