/*
 FILE:          nctgui.h for eMixer version 0.05.5
 PURPOSE:       Provides header files, function prototypes definitions of
                menus and dialog boxes need by the gui.c and emixer.c file
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   05th Dec 1999
*/

/* include files used by gui.c and main.c */
#include <ncurses.h>
#include <slang/slang.h>
#include <string.h>

/* defines used by gui.c and main.c */
#define CHANNEL_1                 1
#define CHANNEL_2                 2
#define VOLBAR                    1
#define SPDBAR                    2
#define MP3_MP3_FADER             1
#define MP3_CD_FADER              2
#define ENTER                    13
#define MENU_WIDTH                8
#define CH_WIDTH                 54
#define MAX_ITEMS                10
#define NUM_MENUS                 3
#define TIMEOUT                   2
#define FADER_BARS               13 /*always set to an odd num > 1 */
#define VOLUME_BARS              19 /*always set to an odd num > 1 */
#define SPEED_BARS               19 /*always set to an odd num > 1 */


/* prototypes for functions used by nctgui.c, main.c */
void ncurses_init(void);
void ncurses_exit(void);
void set_ncurses_color_schemes(void);

/*functions in main.c*/
void menu_action(char *item_name);
void display_listdata();

/*functions in nctgui.c*/
void display_bar(int num_menus,char **menu_name);
void display_info(char *info_string);
void display_menu(char *[][MAX_ITEMS], int *num_items);
void display_ch_window(int active_channel);
void display_fader(int fader_pos);
void display_player_status(int sim_play, int cont_play);
void display_volume(int ch1_volume_pos,int ch2_volume_pos,int bar);
void display_speed(int ch1_speed_pos,int ch2_speed_pos,int bar);
/*static int  get_code(void); */

void make_menus(int num_menus, char **menu_name, int *menu_name_alt,
                char *menu_item[][MAX_ITEMS], int *num_items);

void gui_exit(void);
