/*
 FILE:          nctgui.c for eMixer version 0.05.5
 PURPOSE:       Provides user interface, including menus and dialogs
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   11th Dec 1999
 */

#include "nctgui.h"

/* global variables */
int x = 2, y = 2 ;
int menus_active;
int hpos = 0, vpos = 0, simpLay=FALSE;
char *songname;

char *active_info   = "[ Arrow Keys ] select menu and items. Enter executes item";
char *inactive_info = "[ Lowercase First Letter ] activates menu";
char *dialog_info   = "What's This??";
char *ok_info       = "[ Enter ] to remove message";
char *yes_no_info   = "[ Enter ] for YES, [Esc] for NO";
char *pl_not_found  = "Playlist not found :(";
char *pl_found      = "Playlist found :)";
char *emixer_version= "eMixer Ver 0.05.5";
WINDOW *chWin, *subWin, *infoWin, *barWin, *tStatusWin,
       *faderWin, *volumeWin, *speedWin, *pStatusWin;



void ncurses_init(void)
{
    (void) initscr();
    curs_set(0);
}/* ncurses_init */

void ncurses_exit(void)
{
    endwin();
} /* ncurses_exit*/

/*Color schemes used on screen*/
void set_ncurses_color_schemes(void)
{
    start_color();
    init_pair(1, COLOR_WHITE, COLOR_BLUE);
    init_pair(2, COLOR_BLACK, COLOR_WHITE);
    init_pair(3, COLOR_BLACK, COLOR_GREEN);
    init_pair(4, COLOR_RED, COLOR_WHITE);
    init_pair(5, COLOR_BLACK, COLOR_CYAN);
    init_pair(6, COLOR_BLACK, COLOR_MAGENTA);
    init_pair(7, COLOR_WHITE, COLOR_CYAN);
    init_pair(8, COLOR_WHITE, COLOR_MAGENTA);
    init_pair(9, COLOR_YELLOW, COLOR_BLUE);
    init_pair(10, COLOR_RED, COLOR_BLUE);
    init_pair(11, COLOR_CYAN, COLOR_BLUE);
    init_pair(12, COLOR_MAGENTA, COLOR_BLUE);
    init_pair(13, COLOR_GREEN, COLOR_BLUE);
    init_pair(14, COLOR_RED, COLOR_BLACK);
    init_pair(15, COLOR_BLUE, COLOR_WHITE);
    init_pair(16, COLOR_GREEN, COLOR_BLUE);
} /*set_ncurses_color_schemes*/

/*Displays menu names at top of screen*/
void display_bar(int num_menus,char **menu_name)
{
    int j;
    int maxY,maxX;

    wattrset(barWin,COLOR_PAIR(2)); wbkgdset(barWin,COLOR_PAIR(2));

    wmove(barWin,0,0); wclrtoeol(barWin);  wrefresh(barWin);
    for(j=0; j<num_menus; j++)
    {
        wmove(barWin,0,(j*MENU_WIDTH));
        if(j==hpos && menus_active)
        {
            wattrset(barWin,COLOR_PAIR(3)|A_BOLD);
        }
        waddstr(barWin,menu_name[j]); wrefresh (barWin);

        wattrset(barWin,COLOR_PAIR(15));
        getmaxyx(stdscr,maxY,maxX); mvwaddstr(barWin,0,maxX-20,emixer_version);
        
        wattrset(barWin,COLOR_PAIR(2));
        wrefresh (barWin);
    }
} /* display_bar */

/*Display additional info at bottom of screen*/
void display_info(char *info_string)
{
    
    wattrset(infoWin,COLOR_PAIR(4)); wbkgdset(infoWin,COLOR_PAIR(4));
    mvwaddstr(infoWin,0,0,info_string);
    wclrtoeol(infoWin); wrefresh(infoWin);
}  /* display_info */

/*Displays menu boxes*/
void display_menu(char *menu_item[][MAX_ITEMS], int *num_items)
{
    WINDOW *subWn;
    int j;

    subWn=newwin(2+num_items[hpos],MENU_WIDTH+9,1,(hpos*MENU_WIDTH));
    wbkgd(subWn,COLOR_PAIR(2));
    
    for(j=0;j<num_items[hpos];j++)
    {
        if(j==vpos){wattrset(subWn,COLOR_PAIR(3)); wbkgdset(subWn,COLOR_PAIR(3)); }
        else {wattrset(subWn,COLOR_PAIR(2));wbkgdset(subWn,COLOR_PAIR(2)); }

        wmove(subWn,j+1,1);
        waddstr(subWn,menu_item[hpos][j]); wclrtoeol(subWn);
        wrefresh(subWn);
    }
    wattrset(subWn,COLOR_PAIR(2));wbkgdset(subWn,COLOR_PAIR(2));
    box(subWn,0,0);
    wrefresh(subWn);
} /* display_menu */

/*Displays channel windows*/
void display_ch_window(int active_channel)
{
    int height,width;

    getmaxyx(chWin,height,width);
    switch(active_channel)
    {
    case CHANNEL_1:
        wbkgd(chWin,COLOR_PAIR(11)|A_BOLD);
        box(chWin,0,0);
        wmove(chWin,0,2);
        wattrset(chWin,COLOR_PAIR(5)|A_BOLD|A_BLINK);
        wbkgdset(chWin,COLOR_PAIR(5));
        waddstr(chWin,"Channel One");
        wattrset(chWin,COLOR_PAIR(7)|A_BOLD);
        break;
     
    case CHANNEL_2:
        wbkgd(chWin,COLOR_PAIR(12)|A_BOLD);
        box(chWin,0,0);
        wmove(chWin,0,width-13);
        wattrset(chWin,COLOR_PAIR(6)|A_BOLD|A_BLINK);
        wbkgdset(chWin,COLOR_PAIR(6));
        waddstr(chWin,"Channel Two");
        wattrset(chWin,COLOR_PAIR(8)|A_BOLD);
        break;
    }
    wrefresh (chWin);
}/*display_ch_window*/

/*Displays fader window*/
void display_fader(int fader_pos)
{
    int centre, j;

    centre=(FADER_BARS/2)+2;
    wbkgd(faderWin,COLOR_PAIR(1)|A_BOLD);
    box(faderWin,0,0);
    wattrset(faderWin,COLOR_PAIR(9)|A_BOLD);
    mvwaddstr(faderWin,0,1,"Fader");
    mvwaddstr(faderWin,2,1,"CH1");
    mvwaddstr(faderWin,2,FADER_BARS,"CH2");
    mvwaddstr(faderWin,2,centre,"|");

    wattrset(faderWin,COLOR_PAIR(1)|A_BOLD);
    for(j=0 ;j<FADER_BARS; j++) mvwaddch(faderWin,1,j+2,ACS_BOARD);

    switch(fader_pos)
    {
    case 0:
        mvwaddch(faderWin,1,centre+fader_pos,ACS_BLOCK);
        mvwaddch(faderWin,1,centre+fader_pos-1,' ');
        mvwaddch(faderWin,1,centre+fader_pos+1,' ');
        break;

    case -(FADER_BARS/2):
        mvwaddch(faderWin,1,centre+fader_pos,ACS_BLOCK);
        mvwaddch(faderWin,1,centre+fader_pos+1,187);
        break;

    case (FADER_BARS/2):
        mvwaddch(faderWin,1,centre+fader_pos,ACS_BLOCK);
        mvwaddch(faderWin,1,centre+fader_pos-1,171);
        break;

    default:
        mvwaddch(faderWin,1,centre+fader_pos,ACS_BLOCK);
        mvwaddch(faderWin,1,centre+fader_pos-1,171);
        mvwaddch(faderWin,1,centre+fader_pos+1,187);
        break;
    }
    wrefresh (faderWin);

} /*display_fader*/

void display_volume(int ch1_volume_pos,int ch2_volume_pos,int bar)
{
    
    int centre, j, posY ,volume_pos,maxY,maxX;

    getmaxyx(volumeWin,maxY,maxX);
    centre=(VOLUME_BARS/2)+2;
    wbkgd(volumeWin,COLOR_PAIR(1)|A_BOLD);
    box(volumeWin,0,0);
    if(bar==VOLBAR)mvwaddstr(volumeWin,maxY-1,maxX-9,"[Active]");
    wattrset(volumeWin,COLOR_PAIR(9)|A_BOLD);
    mvwaddstr(volumeWin,0,1,"Volume");
    mvwaddstr(volumeWin,3,1,"0%");
    mvwaddstr(volumeWin,3,VOLUME_BARS-1,"100%");
    mvwaddstr(volumeWin,3,centre,"|");

    for(j=0 ;j<VOLUME_BARS; j++)
    {
        wattrset(volumeWin,COLOR_PAIR(11)|A_BOLD);
        mvwaddch(volumeWin,1,j+2,ACS_BULLET);

        wattrset(volumeWin,COLOR_PAIR(12)|A_BOLD);
        mvwaddch(volumeWin,2,j+2,ACS_BULLET);

    }

    posY=1 ; volume_pos=ch1_volume_pos;
    wattrset(volumeWin,COLOR_PAIR(11)|A_BOLD);

    for(j=0 ;j<2; j++)
    {
        
    switch(volume_pos)
    {
    case 0:
        mvwaddch(volumeWin,posY,centre+volume_pos,ACS_BLOCK);
        /*mvwaddch(volumeWin,posY,centre+volume_pos-1,' '); */
        /*mvwaddch(volumeWin,posY,centre+volume_pos+1,' ');  */
        break;

    case -(VOLUME_BARS/2):
        mvwaddch(volumeWin,posY,centre+volume_pos,ACS_BLOCK);
        mvwaddch(volumeWin,posY,centre+volume_pos+1,187);
        break;

    case (VOLUME_BARS/2):
        mvwaddch(volumeWin,posY,centre+volume_pos,ACS_BLOCK);
        mvwaddch(volumeWin,posY,centre+volume_pos-1,171);
        break;

    default:
        mvwaddch(volumeWin,posY,centre+volume_pos,ACS_BLOCK);
        mvwaddch(volumeWin,posY,centre+volume_pos-1,171);
        mvwaddch(volumeWin,posY,centre+volume_pos+1,187);
        break;
    }

    posY=2 ; volume_pos=ch2_volume_pos;
    wattrset(volumeWin,COLOR_PAIR(12)|A_BOLD);
}
    wrefresh (volumeWin);
} /*display_volume*/

void display_speed(int ch1_speed_pos, int ch2_speed_pos,int bar)
{
    int centre, j, posY, speed_pos,maxY,maxX;

    getmaxyx(speedWin,maxY,maxX);
    centre=(SPEED_BARS/2)+2;
    wbkgd(speedWin,COLOR_PAIR(1)|A_BOLD);
    box(speedWin,0,0);
    if(bar==SPDBAR)mvwaddstr(speedWin,maxY-1,maxX-9,"[Active]");
    wattrset(speedWin,COLOR_PAIR(9)|A_BOLD);
    mvwaddstr(speedWin,0,1,"Speed");
    mvwaddstr(speedWin,3,1,"-");
    mvwaddstr(speedWin,3,VOLUME_BARS,"  +");
    mvwaddstr(speedWin,3,centre,"|");

    for(j=0 ;j<SPEED_BARS; j++)
    {
        wattrset(speedWin,COLOR_PAIR(11)|A_BOLD);
        mvwaddch(speedWin,1,j+2,ACS_BULLET);

        wattrset(speedWin,COLOR_PAIR(12)|A_BOLD);
        mvwaddch(speedWin,2,j+2,ACS_BULLET);
    }

    posY=1 ; speed_pos=ch1_speed_pos;
    wattrset(speedWin,COLOR_PAIR(11)|A_BOLD);

    for(j=0 ;j<2; j++)
    {
    

    switch(speed_pos)
    {
    case 0:
        mvwaddch(speedWin,posY,centre+speed_pos,ACS_BLOCK);
        /*mvwaddch(speedWin,posY,centre+speed_pos-1,' '); */
        /*mvwaddch(speedWin,posY,centre+speed_pos+1,' ');  */
        break;

    case -(SPEED_BARS/2):
        mvwaddch(speedWin,posY,centre+speed_pos,ACS_BLOCK);
        mvwaddch(speedWin,posY,centre+speed_pos+1,187);
        break;

    case (SPEED_BARS/2):
        mvwaddch(speedWin,posY,centre+speed_pos,ACS_BLOCK);
        mvwaddch(speedWin,posY,centre+speed_pos-1,171);
        break;

    default:
        mvwaddch(speedWin,posY,centre+speed_pos,ACS_BLOCK);
        mvwaddch(speedWin,posY,centre+speed_pos-1,171);
        mvwaddch(speedWin,posY,centre+speed_pos+1,187);
        break;
    }
    posY=2 ; speed_pos=ch2_speed_pos;
    wattrset(speedWin,COLOR_PAIR(12)|A_BOLD);

    }
    wrefresh (speedWin);

} /*display_speed*/

void display_player_status(int sim_play, int playmode)
{

    wbkgd(pStatusWin,COLOR_PAIR(1)|A_BOLD);
    box(pStatusWin,0,0);
    wattrset(pStatusWin,COLOR_PAIR(9)|A_BOLD);
    mvwaddstr(pStatusWin,0,1,"Player Status");
    wattrset(pStatusWin,COLOR_PAIR(1)|A_BOLD);
    if(playmode==3)mvwaddstr(pStatusWin,1,1,      "PlayMode : RANDOM   ");
    else if(playmode==2)mvwaddstr(pStatusWin,1,1, "PlayMode : CONTINOUS");
    else if(playmode==1)mvwaddstr(pStatusWin,1,1, "PlayMode : LOOP     ");
    else mvwaddstr(pStatusWin,1,1, "PlayMode : SINGLE   ");
    /*mvwaddstr(pStatusWin,2,1,"GroupMode: OFF");  */
    if(sim_play==TRUE)mvwaddstr(pStatusWin,2,1, "SimPlay  : ON ");
    else mvwaddstr(pStatusWin,2,1, "SimPlay  : OFF");
    wrefresh (pStatusWin);
} /*display_play_mode*/

void gui_exit(void)
{
 exit(0);
} /*gui_exit/*/

void sLang_init(void)
{
    SLtt_get_terminfo();
    SLang_init_tty(0,0,1);
    SLkp_init();
    SLsmg_init_smg();
    SLsig_block_signals();
    /*ncurses stuff - experimental */
    (void) initscr();
    curs_set(0);
    noecho();
    keypad(stdscr,TRUE);
} /* sLang_init*/


void sLang_exit(void)
{
    /*ncurses stuff - experimental */
    endwin();

    SLsmg_cls();
    SLsmg_refresh ();
    SLsmg_reset_smg();
    SLang_reset_tty();
} /* sLang_exit*/

void set_color_schemes(void)
{
    SLtt_set_color(1, NULL, "white", "blue");
    SLtt_set_color(2, NULL, "black", "lightgray");
    SLtt_set_color(3, NULL, "black", "green");
    SLtt_set_color(4, NULL, "red","lightgray");
    SLtt_set_color(5, NULL, "yellow","blue");
    SLtt_set_color(6, NULL, "lightgray","blue");
    SLtt_set_color(7, NULL, "yellow","black");
    SLtt_set_color(8, NULL, "green","blue");
    SLtt_set_color(9, NULL, "lightgray","black");
    SLtt_set_color(10, NULL, "red","black");
    SLtt_set_color(11, NULL, "brightcyan","black");
    SLtt_set_color(12, NULL, "brightmagenta","black");
    SLtt_set_color(13, NULL, "black","brightcyan");
    SLtt_set_color(14, NULL, "black","brightmagenta");
    SLtt_set_color(15, NULL, "white","brightcyan");
    SLtt_set_color(16, NULL, "white","brightmagenta");


}/*set_color_schemes*/

void create_windows()
{
    int maxY, maxX, height, width, origY=1, origX=0;

    getmaxyx(stdscr,maxY,maxX);
    height = maxY-4; width  = (maxX/10)*7;
    chWin  = newwin(height,width,origY,origX);

    origY=origY++; origX=origX++ ;
    height = maxY-6;  width = ((maxX/10)*7)-2;
    subWin  = newwin(height,width,origY,origX);
    
    origY=maxY-1; origX=0;
    height = 1;  width = maxX-1;
    infoWin  = newwin(height,width,origY,origX);
    
    origY=0; origX=0;
    height = 1;  width = maxX-1;
    barWin  = newwin(height,width,origY,origX);

    origY=maxY-3; origX=0;
    height = 2;  width = maxX-1;
    tStatusWin = newwin(height,width,origY,origX);

    origY = maxY-7;
    origX = ((maxX/10)*7)+1;
    height = 4; width= FADER_BARS+4;
    faderWin  = newwin(height,width,origY,origX);
    
    origY = maxY-13;
    origX = ((maxX/10)*7)+1;
    height = 5; width= SPEED_BARS+4;
    speedWin  = newwin(height,width,origY,origX);
    
    origY = maxY-19;
    origX = ((maxX/10)*7)+1;
    height = 5; width= VOLUME_BARS+4;
    volumeWin  = newwin(height,width,origY,origX);
    
    origY = 1;
    origX = ((maxX/10)*7)+1;
    height = 4; width= VOLUME_BARS+4;
    pStatusWin  = newwin(height,width,origY,origX);
    
} /*create_windows*/
