/*
 FILE:          mixer.h for eMixer version 0.05.5
 PURPOSE:       Provides functions for mixing mp3 data streams
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   09th May 1999

 This program was originally written by Scott Manley
 and modified for used with eMixer by Dunstan B. Nesbit.
 The original version can be found at
 http://szyzyg.arm.ac.uk/~spm/mp3mixer.html
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <signal.h>
#include <sys/types.h>
#include <termios.h>

#define BUF_SIZE    4096 /* this is set to this value because it's the longest fragment we can read from a pipe  */
#define MAX_SAMPLE  32766

#define CLIP        30000
#define CLIP_A      ((MAX_SAMPLE-CLIP)*(MAX_SAMPLE-CLIP))
#define CLIP_B      (MAX_SAMPLE-2*CLIP)

#define CHANNEL_PLAY        1
#define CHANNEL_START_STOP  2
#define SIM_PLAY            3
#define SIM_START_STOP      4
#define KILL_ALL            5
#define SPEED_CHANGE        6

struct termios tsave;

typedef struct
{
    short inbuf[BUF_SIZE];
    float volume;
    float speed;
    int on;
    int end;
    int stream;
    FILE *fstr;           /* use std buffering to simplify things */
    pid_t pid;
    int argindx;
} channel;


void spawn_stream(char *filename, channel *ch);
void open_sound_device(void);
void close_sound_device(void);
void kill_channel(channel *ch);
void change_channel(channel *ch,char *fpath);
void get_audio(channel *ch,int *buf);
void play_chunks(void);
void set_terminal(void);
void restore_terminal(void);
void initialize_audio(void);
void reset_audio(void);
void start_stop_channel(channel *ch);
