/*
 FILE:          mixer.c for eMixer version 0.05.5
 PURPOSE:       Provides functions for mixing mp3 data streams
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   27th Dec 1999

 This program was originally written by Scott Manley
 and modified for used with eMixer by Dunstan B. Nesbit.
 The original version can be found at
 http://szyzyg.arm.ac.uk/~spm/mp3mixer.html
*/


#include "mixer.h"
short audio_buffer[BUF_SIZE];
int   audio_fd, j, argindex;
int   process_buffer[BUF_SIZE];
char  *mp3Path1, *mp3Path2;



float ch1_volume=1.0, ch2_volume=1.0,
      ch1_fader_ratio=1.0, ch2_fader_ratio=1.0,
      ch1_speed_ratio=1.0, ch2_speed_ratio=1.0,
      ch1_speed=1.0, ch2_speed=1.0;

channel ch1,ch2;

void spawn_stream(char *filename,channel *ch)
{
    int strm[2];
    pid_t pid;
    /* create pipe */
    pipe(strm);
    pid=fork();
    if(pid)
    {
        (*ch).pid=pid;
        close(strm[1]);
        (*ch).stream=strm[0];
        (*ch).fstr=fdopen((*ch).stream,"rb");
    }
    else
    {
        close(strm[0]);
        close(1);
        dup(strm[1]);
        close(strm[0]);
        close(strm[1]);
        execlp("mpg123","mpg123","-s","-q"/*,"-n 300"*/,filename,NULL);
    }
}   /*spawn_stream */

void open_sound_device(void)
{
    int format;
    int stereo = 1;
    int rate = 44100;
    if ((audio_fd = open("/dev/dsp", O_WRONLY , 0)) == -1)
    {
        perror("/dev/dsp");
        return;
        /*exit(1);  */
    }
    format = AFMT_S16_LE;
    if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1)
    {
        perror("SNDCTL_DSP_SETFMT");
        exit(1);
    }
    if (format != AFMT_S16_LE)
    {
        fprintf(stderr,"Output format not set correctly");
    }
    if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo)==-1)
    {
        perror("SNDCTL_DSP_STEREO");
        exit(1);
    }
    if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &rate)==-1)
    { /* Fatal error */
        perror("SNDCTL_DSP_SPEED");
        exit(1);
    }
} /* open_sound_device  */


void close_sound_device(void)
{
    close(audio_fd);
}  /*close_sound_device */

void init_channel(channel *ch)
{
    int i;
    for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
    (*ch).volume=1.0;
    (*ch).speed=1.0;
    (*ch).on=1;
    (*ch).end=0;
    (*ch).stream=0;
    (*ch).pid=0;
    (*ch).argindx=1;

}  /*init_channel */

void kill_channel(channel *ch)
{
    int i;
    if((*ch).pid>0)
    {
        kill((*ch).pid,15);
        (*ch).pid=0;
        (*ch).on=0;
    }
    else
    {
        if((*ch).stream>2) close((*ch).stream);
        (*ch).pid=0;
        (*ch).on=0;
    }
    for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
} /*kill_channel */

/* step up through the list of tracks */
void change_channel(channel *ch,char *fpath)
{

    kill_channel(ch);
    (*ch).speed=1.0;
    spawn_stream(fpath,ch);
} /*change_channel */


/* get the audio for one channel - should include speedup and slowdown here */
void get_audio(channel *ch,int *buf/*,int *trackend*/)
{
    static short adat[BUF_SIZE],inbuf[BUF_SIZE*4];
    int i,j;

    if((*ch).on)
    {
        if((*ch).speed==1.0) i=fread(adat,2,BUF_SIZE,(*ch).fstr);
        else
        {
            j=(BUF_SIZE>>1)*(*ch).speed;
            j<<=1;
            i=fread(inbuf,2,j,(*ch).fstr);
            if(i<j)
            {
                kill_channel(ch);
                for(;i<j;i++)inbuf[i]=0;
                (*ch).on=0; /*mp3 ended*/
                (*ch).end=1;
            }
            for(i=0;i<(BUF_SIZE/2);i++)
            {
                j=i*(*ch).speed;
                adat[i*2]=inbuf[j*2];
                adat[i*2+1]=inbuf[j*2+1];
            }
            i=BUF_SIZE;
        }

        if(i<BUF_SIZE)
        {
            kill_channel(ch);
            for(;i<BUF_SIZE;i++) adat[i]=0;
            (*ch).on=0; /*mp3 ended*/
            (*ch).end=1;
        }

        for(i=0;i<BUF_SIZE;i++) buf[i]+=adat[i]*(*ch).volume;
    }
} /* get_audio  */

void play_chunks(void)
{
    int i,num;
    num=BUF_SIZE;

    for(i=0;i<BUF_SIZE;i++) process_buffer[i]=0;

    get_audio(&ch1,process_buffer/*,&ch1_trkend*/);
    //chch1_trkend
    get_audio(&ch2,process_buffer/*,&ch2_trkend*/);

    for(i=0;i<num;i++)
    {
        if((process_buffer[i]<CLIP)&&(process_buffer[i]>-CLIP))
            audio_buffer[i]=(short)(process_buffer[i]);
        else if (process_buffer[i]>0)
            audio_buffer[i]=MAX_SAMPLE-(CLIP_A/(CLIP_B+process_buffer[i]));
        else
            audio_buffer[i]=-(MAX_SAMPLE-(CLIP_A/(CLIP_B-process_buffer[i])));
    }
    write(audio_fd,audio_buffer,num*2);
}   /* play_chunks */

/* sets canonical input mode */
void set_terminal(void)
{
    struct termios tbuf;
    tcgetattr(0,&tbuf);
    tsave=tbuf;
    tbuf.c_lflag &= ~(ECHO | ICANON | ISIG);
    tbuf.c_cc[VMIN] = tbuf.c_cc[VTIME] = 0;
    tcsetattr(0,TCSANOW,&tbuf);
}  /* set_terminal */

/* restore the settings */
void restore_terminal(void)
{

    tcsetattr(0,TCSANOW,&tsave);
}  /*restore_terminal */

void initialize_audio(void)
{
    signal(SIGCHLD,SIG_IGN);
    open_sound_device();
    set_terminal();
    init_channel(&ch1);
    init_channel(&ch2);
} /*  initialize_audio   */

void reset_audio(void)
{
    restore_terminal();
    close_sound_device();
}   /*reset_audio */

void start_stop_channel(channel *ch)
{
  if((*ch).on) (*ch).on=0; else (*ch).on=1;
} /*start_stop_channel*/

void stop_channel(channel *ch)
{
  (*ch).on=0;
} /*stop_channel*/

void start_channel(channel *ch)
{
  (*ch).on=1;
} /*start_channel*/

