/*
 FILE:          main.h for eMixer version 0.05.5
 PURPOSE:       Provides user interface, including menus and dialogs
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   27th Dec 1999
 */


/*#include <sys/io.h>*/
#include "nctgui.c"
#include "mixer.c"
#include <sys/time.h>

typedef struct node_type
{
    //int index;
    char *filePath;
    int   playcount;
    struct node_type *fLink;
    struct node_type *bLink;
} node;

/* bottom line info */
char *menu_name[NUM_MENUS] = {"File","Utils","Help"};

/*int menu_name_alt[NUM_MENUS] = {33,22,35};*/
int menu_name_alt[NUM_MENUS] = {'f','u','h'};
char *menu_item[NUM_MENUS] [MAX_ITEMS] = {
         { "Play Mode", "Load Playlist", "Exit"},
         { "Volume Control", "CD Player","Mount Device", "UnMount Device", "Playlist Editor" },
         { "About", "Usage", "Credits"}
         };
int num_items[NUM_MENUS] = {3,5,3};

void exit_prog(void);
static node *create_node(char *filepath);
void get_playlist_data(char *playlist_filename);
void adjust_display(int key);
void get_random_play_track();
void enter_action(void);
void start_new_track(channel *ch, char* mp3Path);
char* track_selection(channel *ch, node *ch_current, char *mp3loc);
void display_track_path(int active_channel,int sim_play, node *current1, node *current2);
void display_track_status();
void track_status_text(chtype tcolor, char *text, int posY);
void refresh_windows(void);
