#include "main.h"
/*
 FILE:          main.c for eMixer version 0.05.5
 PURPOSE:       Provides user interface, including menus and dialogs
 AUTHOR:        Dunstan B. Nesbit
 START DATE:    27th March 1999
 LAST UPDATE:   27th Dec 1999
 */
/*global variables */
node *fHead=NULL, *bHead=NULL, *current=NULL, *last=NULL;
node *ch1_Head,* ch2_Head, *ch1_current, *ch2_current, *ch1_last, *ch2_last,
     *ch_temp1, *ch_temp2;
int total_records=1, ch1_counter=1, ch2_counter=1, sim_play=0, playmode=0,
    fader_bars=FADER_BARS, volume_bars=VOLUME_BARS, speed_bars=SPEED_BARS,
    active_channel=CHANNEL_1, active_bar=VOLBAR,
    fader_pos=0, volume_pos=0, speed_pos=0,
    ch1_volume_pos=0,ch2_volume_pos=0,
    ch1_speed_pos=0, ch2_speed_pos=0,
    active_fader=MP3_MP3_FADER, clickcount=0, playcount=0, rcount=0,
    firstplay=TRUE;

int main(int argc, char **argv)
{
    get_playlist_data(argv[1]);
    ch1_Head=fHead; ch2_Head=fHead;
    ch1_current=fHead; ch2_current=fHead;
    ch1_last=fHead; ch2_last=fHead;
    mp3Path1=fHead->filePath; mp3Path2=fHead->filePath;
    make_menus(NUM_MENUS,menu_name,menu_name_alt,menu_item,num_items);

} /*main*/

static node *create_node(char *filepath)
{
    node *newnode;
    newnode = (node *) malloc(sizeof(node));
    newnode->fLink=NULL;
    newnode->bLink=NULL;
    newnode->filePath=strdup(filepath);
    newnode->filePath[strlen(newnode->filePath)-1]='\0';
    newnode->playcount=0;
    return newnode;
} /*new_node*/

void get_playlist_data(char *playlist_filename)
{
    char filepath[1024];
    FILE *pListFile;
    int FirstNode=TRUE;

    if((pListFile=fopen(playlist_filename,"rt"))==NULL)
    {
        printf(" \n");
        printf("playlist file not specified\n");
        printf("Usage: emixer [PLAYLIST]\n");
        printf(" \n");
        exit(0);
    }
    else
    {
        printf("playlist file found\n");
        while (fgets(filepath,1024,pListFile))
        {
            if((current=(node *) malloc(sizeof(node)))==NULL)
            {
                printf("out of memory\n");
                exit(0);
            }
            else 
            {
                if(FirstNode)
                {
                    current=create_node(filepath);
                    bHead=current;
                    last=current;
                    FirstNode=FALSE;
            }
            else
            {
                current->fLink=create_node(filepath);
                current=current->fLink;
                current->bLink=last;
                bHead=current;
                last=current;
            }
        }
    }
    FirstNode=TRUE;
    while (current->bLink!=NULL)
        {
            if(FirstNode)
            {
                last=current;
                FirstNode=FALSE;
            }
            else
            {
                current=current->bLink;
                current->fLink=last;
                last=current;
            }
        }
    }
    fHead=current;
    fHead->bLink=bHead;
    bHead->fLink=fHead;
    fclose(pListFile);
} /*get_playlist_data*/

void make_menus(int num_menus, char **menu_name, int *menu_name_alt,
                char *menu_item[][MAX_ITEMS], int *num_items)
{
    int j;
    int extcode;

    menus_active = FALSE;
    /*initialize screen routines*/
    sLang_init();
    set_color_schemes();
    ncurses_init();
    set_ncurses_color_schemes();
    create_windows();
    /*initialize audio stuff*/
    initialize_audio();
    change_channel(&ch1,mp3Path1);
    change_channel(&ch2,mp3Path2);


    /*display windows*/
    display_bar(num_menus, menu_name);
    display_ch_window(active_channel);
    display_track_path(active_channel,sim_play,ch1_current,ch2_current);
    display_track_status();
    adjust_display(get_code());
    display_listdata();
    display_player_status(sim_play,playmode);
    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
    display_fader(fader_pos);
    

    while(TRUE)
    {
        play_chunks();

        ch1.volume=ch1_volume*ch1_fader_ratio;
        ch2.volume=ch2_volume*ch2_fader_ratio;

       if((ch1.end==1)||(ch2.end==1)) display_track_status();
       if(rcount==5)
       {
           refresh_windows();
           display_bar(num_menus, menu_name);
           rcount=0;
       }

       if(playmode==1) /*loop play*/
       {
           if((ch1.on==0)&&(ch1.end==1))
           {
               start_new_track(&ch1,mp3Path1);
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               rcount++;
           }

           if((ch2.on==0)&&(ch2.end==1))
           {
               start_new_track(&ch2,mp3Path2);
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               rcount++;
           }
           
       }
       else if(playmode==2)  /*continous play*/
       {
           if((ch1.on==0)&&(ch1.end==1))
           {
               if(ch1_current==ch1_last)
               {
                   ch1_Head=ch1_Head->fLink;
                   ch1_current=ch1_current->fLink;
               }

               ch1_speed=1.0;ch1_speed_pos=0;ch1.speed=ch1_speed;
               mp3Path1=track_selection(&ch1,ch1_current,mp3Path1);
               ch1_last=ch1_current;
               display_ch_window(active_channel);
               display_listdata();
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               display_player_status(sim_play,playmode);
               display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
               rcount++;
           }

           if((ch2.on==0)&&(ch2.end==1))
           {
               if(ch2_current==ch2_last)
               {
                   ch2_Head=ch2_Head->fLink;
                   ch2_current=ch2_current->fLink;
               }
               ch2_speed=1.0;ch2_speed_pos=0;ch2.speed=ch2_speed;
               mp3Path2=track_selection(&ch2,ch2_current,mp3Path2);
               ch2_last=ch2_current;
               display_ch_window(active_channel);
               display_listdata();
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               display_player_status(sim_play,playmode);
               display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
               rcount++;
           }
           
       }
       else if(playmode==3)  /*random play*/
       {
           if((ch1.on==0)&&(ch1.end==1))
           {
               get_random_play_track();
               /*this is crap, the function does not work when I pass the pointers to it)*/
               ch1_Head=ch_temp1; ch1_current=ch_temp2;  
               mvwprintw(infoWin,0,0,"%s \n",ch1_Head);
               wrefresh(infoWin);
               ch1_speed=1.0;ch1_speed_pos=0;ch1.speed=ch1_speed;
               mp3Path1=track_selection(&ch1,ch1_current,mp3Path1);
               ch1_last=ch1_current;
               display_ch_window(active_channel);
               display_listdata();
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               display_player_status(sim_play,playmode);
               display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
               rcount++;
           }

           if((ch2.on==0)&&(ch2.end==1))
           {
               get_random_play_track();
               ch2_Head=ch_temp1; ch2_current=ch_temp2;
               ch2_speed=1.0;ch2_speed_pos=0;ch2.speed=ch2_speed;
               mp3Path2=track_selection(&ch2,ch2_current,mp3Path2);
               ch2_last=ch2_current;
               display_ch_window(active_channel);
               display_listdata();
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               display_player_status(sim_play,playmode);
               display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
               rcount++;
           }
           
       }


       if(menus_active)
        {
            {
                display_info(inactive_info);
                switch(get_code())
                {
                case SL_KEY_LEFT:
                    vpos=0;
                    hpos=(hpos>0) ? --hpos: num_menus-1;
                    display_bar(num_menus, menu_name);
                    display_ch_window(active_channel);
                    display_listdata();
                    display_menu(menu_item,num_items);
                    break;

                case SL_KEY_RIGHT:
                    vpos=0;
                    hpos=(hpos<num_menus-1) ? ++hpos: 0;
                    display_bar(num_menus, menu_name);
                    display_ch_window(active_channel);
                    display_listdata();
                    display_menu(menu_item,num_items);
                    break;

                case SL_KEY_UP:
                    vpos=(vpos>0) ? --vpos: num_items[hpos]-1;
                    display_menu(menu_item,num_items);
                    break;

                case SL_KEY_DOWN:
                    vpos=(vpos<num_items[hpos]-1) ? ++vpos:0;
                    display_menu(menu_item,num_items);
                    break;

                case 10:
                case ENTER:
                    menus_active=FALSE;
                    menu_action(menu_item[hpos][vpos]);
                    vpos=0;
                    display_ch_window(active_channel);
                    display_listdata();
                    break;

                
                /*case KEY_F(1):*/
                case '`':
                    vpos=0;
                    menus_active=FALSE;
                    display_ch_window(active_channel);
                    display_listdata();
                    display_bar(num_menus,menu_name);
                    break;

                default:
                    play_chunks();
                    if((ch1.on==0)||(ch2.on==0)) display_track_status();
                   
                }
            }
        }
    	else
        {
            display_info(inactive_info);
            extcode = get_code();

            switch(extcode)
            {
            case 10:
            case ENTER: /*enter key pressed, selects track in active channel */
                if(active_channel==CHANNEL_1)
                {
                    ch1_speed=1.0;ch1_speed_pos=0;ch1.speed=ch1_speed;
                    if(sim_play) /*starts same track in both channels*/
                    {
                        /* ch2_current = ch1_current;*/
                        ch2_speed=1.0;ch2_speed_pos=0;ch2.speed=ch2_speed;
                        mp3Path2=track_selection(&ch2,ch1_current,mp3Path1);
                        mp3Path1=track_selection(&ch1,ch1_current,mp3Path1);
                        ch2_Head=ch1_Head;
                        ch2_current=ch1_current;

                    }
                    else mp3Path1=track_selection(&ch1,ch1_current,mp3Path1);
                    ch1_last=ch1_current;
                }
                else
                {
                    ch2_speed=1.0;ch2_speed_pos=0; ch2.speed=ch2_speed;
                    if(sim_play) /*starts same track in both channels*/
                    {
                        /*ch1_current = ch2_current; */
                        ch1_speed=1.0;ch1_speed_pos=0;ch1.speed=ch1_speed;
                        mp3Path1=track_selection(&ch1,ch2_current,mp3Path2);
                        mp3Path2=track_selection(&ch2,ch2_current,mp3Path2);
                        ch1_current=ch2_current;
                        ch1_Head=ch2_Head;
                    }
                    else mp3Path2=track_selection(&ch2,ch2_current,mp3Path2);
                    ch2_last=ch2_current;
                }
               display_listdata();
               display_track_path(active_channel,sim_play,ch1_last,ch2_last);
               display_track_status();
               sim_play=FALSE;
               display_player_status(sim_play,playmode);
               display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
               break;

            case '\t': /*tab key pressed, alternates between active channels*/
                if (active_channel==CHANNEL_1) active_channel=CHANNEL_2;
                else active_channel=CHANNEL_1;
                /* updates active channel display */

                
                display_ch_window(active_channel);
                display_listdata();
                break;
                
            case ']' :
            case '}':   /*' ] '  ' } ' , alternates between volume and speed windows*/

                if (active_bar==VOLBAR)
                {
                    active_bar=SPDBAR; 
                }
                else
                {
                    active_bar=VOLBAR;
                }
                display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
                display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
                break;
            

            case ' ': /* space bar pressed, restarts track in active_channel*/
                if(sim_play==TRUE)
                {
                    if(active_channel==1)
                    {
                        start_new_track(&ch1,mp3Path1);
                        start_new_track(&ch2,mp3Path1);
                        mp3Path2=mp3Path1;
                        ch2_current=ch1_current;
                        ch2_Head=ch1_Head;
                        ch2_last=ch1_current; ch1_last=ch1_current;

                    }
                    else
                    {
                        start_new_track(&ch1,mp3Path2);
                        start_new_track(&ch2,mp3Path2);
                        mp3Path1=mp3Path2;
                        ch1_current=ch2_current;
                        ch2_Head=ch1_Head;
                        ch1_last=ch2_current; ch2_last=ch2_current;
                    }
                    ch1_current->playcount++;
                    ch2_current->playcount++;
                    display_track_path(active_channel,sim_play,ch1_last,ch2_last);
                    display_track_status();
                    sim_play=FALSE;
                    display_player_status(sim_play,playmode);
                }
                else
                {
                    if(active_channel==1)
                    {
                        start_new_track(&ch1,mp3Path1);
                        ch1_current->playcount++;
                    }
                    else
                    {
                        start_new_track(&ch2,mp3Path2);
                        ch2_current->playcount++;
                    }
                    display_listdata();
                    display_track_path(active_channel,sim_play,ch1_last,ch2_last);
                    display_track_status();
                }
                break ;

            case 'q': /* start/stop channel one */
            case 'Q':
                start_stop_channel(&ch1);
                display_track_status();
                break;

            case 'w': /* start/stop channel two */
            case 'W':
                start_stop_channel(&ch2);
                display_track_status();
                break;

            case 'a': /* stop all channels */
            case 'A':
                stop_channel(&ch1);
                stop_channel(&ch2);
                display_track_status();
                break;

            case 's': /* toggles simultaneous channel play ON or OFF */
            case 'S':
                if(sim_play) sim_play=FALSE; else sim_play=TRUE;
                display_player_status(sim_play,playmode);
                break;

            case 'p': /* toggles playmode */
            case 'P':
                if (playmode==0) playmode=1; /*loop*/
                else if (playmode==1) playmode=2;  /*continous*/
                else if (playmode==2) playmode=3;  /*random*/
                else  playmode=0; /*single*/
                display_player_status(sim_play,playmode);

                //printf("------- %i ----------\n",playmode);
                break;

            case SL_KEY_IC:
                if (active_bar==VOLBAR)
                {
                    ch1_volume_pos--;
                    if(ch1_volume_pos<=-(volume_bars/2))ch1_volume_pos=-(volume_bars/2);
                    if(ch1_volume_pos == 0)
                    {
                        ch1_volume=1.0;
                        ch1.volume=ch1_volume;
                         
                    }
                    else if(ch1_volume_pos < 0)ch1_volume=1.0-((ch1_volume_pos/((volume_bars/2) *1.0))* -1.0);
                    else ch1_volume=((ch1_volume_pos/((volume_bars/2)*1.0))*4.0)+1;
                    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);

                }
                else
                {
                    ch1_speed_pos--;
                    if(ch1_speed_pos<=-(speed_bars/2))ch1_speed_pos=-(speed_bars/2);
                    if(ch1_speed_pos == 0)
                    {
                        ch1_speed=1.0;
                        ch1.speed=ch1_speed;
                         
                    }
                    else if(ch1_speed_pos < 0)ch1_speed=1.0-(ch1_speed_pos/((speed_bars/2)*1.0))*-0.2;
                    else ch1_speed=((ch1_speed_pos/((speed_bars/2)*1.0))*0.2)+1.0;
                    ch1.speed=ch1_speed;
                    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
                }

      
                break;

            case SL_KEY_HOME:

                if (active_bar==VOLBAR)
                {
                    ch1_volume_pos++;
                    if(ch1_volume_pos>=(volume_bars/2))ch1_volume_pos=(volume_bars/2) ;
                    if(ch1_volume_pos == 0)
                    {
                        ch1_volume=1.0;
                        ch1.volume=ch1_volume;
                        
                    }
                    else if(ch1_volume_pos > 0)ch1_volume=((ch1_volume_pos/((volume_bars/2)*1.0))*4.0)+1 ;
                    else ch1_volume=1.0-(ch1_volume_pos/((volume_bars/2)*1.0))* -1.0;


                    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
                }
                else
                {
                    ch1_speed_pos++;
                    if(ch1_speed_pos>=(speed_bars/2))ch1_speed_pos=(speed_bars/2) ;
                    if(ch1_speed_pos == 0)
                    {
                        ch1_speed=1.0;
                        ch1.speed=ch1_speed;
                        
                    }
                    else if(ch1_speed_pos > 0)ch1_speed=((ch1_speed_pos/((speed_bars/2)*1.0))*0.2)+1.0 ;
                    else ch1_speed=1.0-(ch1_speed_pos/((speed_bars/2)*1.0))*-0.2 ;
                    ch1.speed=ch1_speed;
                    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
                }
            break;

            case SL_KEY_DELETE:
                if (active_bar==VOLBAR)
                {
                    ch2_volume_pos--;
                    if(ch2_volume_pos<=-(volume_bars/2))ch2_volume_pos=-(volume_bars/2);
                    if(ch2_volume_pos == 0)
                    {
                        ch2_volume=1.0;
                        ch2.volume=ch2_volume;
                    
                    }
                    else if(ch2_volume_pos < 0)ch2_volume=1.0-((ch2_volume_pos/((volume_bars/2) *1.0))* -1.0);
                    else ch2_volume=((ch2_volume_pos/((volume_bars/2)*1.0))*4.0)+1;
                    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
                }
                else
                {
                    ch2_speed_pos--;
                    if(ch2_speed_pos<=-(speed_bars/2))ch2_speed_pos=-(speed_bars/2);
                    if(ch2_speed_pos == 0)
                    {
                        ch2_speed=1.0;
                        ch2.speed=ch2_speed;
                         
                    }
                    else if(ch2_speed_pos < 0)ch2_speed=1.0-(ch2_speed_pos/((speed_bars/2)*1.0))*-0.2;
                    else ch2_speed=((ch2_speed_pos/((speed_bars/2)*1.0))*0.2)+1.0;
                    ch2.speed=ch2_speed;
                    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
                }
                break;

            case SL_KEY_END:
                if (active_bar==VOLBAR)
                {
                    ch2_volume_pos++;
                    if(ch2_volume_pos>=(volume_bars/2))ch2_volume_pos=(volume_bars/2) ;
                    if(ch2_volume_pos == 0)
                    {
                        ch2_volume=1.0;
                        ch2.volume=ch2_volume;
                    }
                    else if(ch2_volume_pos > 0)ch2_volume=((ch2_volume_pos/((volume_bars/2)*1.0))*4.0)+1;
                    else ch2_volume=1.0-((ch2_volume_pos/((volume_bars/2)*1.0))* -1.0);
                    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
                }
                else
                {
                    ch2_speed_pos++;
                    if(ch2_speed_pos>=(speed_bars/2))ch2_speed_pos=(speed_bars/2) ;
                    if(ch2_speed_pos == 0)
                    {
                        ch2_speed=1.0;
                        ch2.speed=ch2_speed;
                        
                    }
                    else if(ch2_speed_pos > 0)ch2_speed=((ch2_speed_pos/((speed_bars/2)*1.0))*0.2)+1.0 ;
                    else ch2_speed=1.0-(ch2_speed_pos/((speed_bars/2)*1.0))*-0.2 ;
                    ch2.speed=ch2_speed;
                    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
                }
                break;

            case SL_KEY_LEFT : /* left arrow pressed, adjusts fader postion */
                fader_pos-- ;
                if(fader_pos<=-(fader_bars/2))fader_pos=-(fader_bars/2);
                if(fader_pos == 0)
                {
                    ch1.volume=ch1_volume;
                    ch2.volume=ch2_volume;
                    ch1_fader_ratio=1.0;
                    ch2_fader_ratio=1.0;
                }
                else if(fader_pos < 0)ch2_fader_ratio=1.0-((fader_pos/((fader_bars/2)*1.0))* -1.0);
                else ch1_fader_ratio=1.0-(fader_pos/((fader_bars/2)*1.0));
                display_fader(fader_pos);
                break;

            case SL_KEY_RIGHT:
                fader_pos++;
                if(fader_pos>=(fader_bars/2))fader_pos=(fader_bars/2) ;
                if(fader_pos == 0)
                {
                    ch1.volume=ch1_volume;
                    ch2.volume=ch2_volume;
                    ch1_fader_ratio=1.0;
                    ch2_fader_ratio=1.0;
    
                }
                else if(fader_pos > 0)ch1_fader_ratio=1.0-(fader_pos/((fader_bars/2)*1.0));
                else ch2_fader_ratio=1.0-((fader_pos/((fader_bars/2)*1.0))* -1.0);
                display_fader(fader_pos);
                break;

            case '>':
            case '.':
                fader_pos=fader_bars/2 ;
                ch2_fader_ratio=1.0;
                ch1_fader_ratio=0.0;
                display_fader(fader_pos);
                break;

            case '<':
            case ',':
                fader_pos=-(fader_bars/2);
                ch1_fader_ratio=1.0;
                ch2_fader_ratio=0.0;
                display_fader(fader_pos);
                break;

            case '?':
            case '/':
                fader_pos=0;
                ch1_fader_ratio=1.0;
                ch2_fader_ratio=1.0;
                display_fader(fader_pos);
                break;

            case SL_KEY_DOWN:
            case SL_KEY_UP:
            case SL_KEY_PPAGE:
            case SL_KEY_NPAGE:
                adjust_display(extcode);
                display_ch_window(active_channel);
                display_listdata();
                break;

            case'r':  /*redraws screen*/
            case'R':
                refresh_windows();
                display_bar(num_menus, menu_name);
                break ;

            default:
                for(j=0; j<num_menus; j++)
                    if(extcode==menu_name_alt[j])
                    {
                        menus_active=TRUE;
                        hpos=j;
                        display_bar(num_menus, menu_name);
                        display_menu(menu_item, num_items);
                    }
                break;
            }
        }
   }
} /*make_menus */

void start_new_track(channel *ch, char* mp3Path)
{
    kill_channel(ch);
    spawn_stream(mp3Path,ch);
    (*ch).on=1;
    (*ch).end=0;
} /*start_new_track*/

char* track_selection(channel *ch, node *ch_current,char *mp3Path)
{
    char *fpath;

    fpath=ch_current->filePath;
    if(strcmp(mp3Path,fpath)==0)
    {   /*if selected track == curently playing track, stop channel*/
        start_stop_channel(ch);
        if(firstplay){ch_current->playcount++; firstplay=FALSE;}
    }
    else
    {   /*start channel with newly selected track*/
        mp3Path=fpath;
        start_new_track(ch,mp3Path);
        ch_current->playcount++;
    }
    return(mp3Path);
} /*track_selection*/

void display_track_path(int active_channel,int sim_play, node *current1, node *current2)
{
    int tracknum, totaltracks=1,tnum1,tnum2;
    node *top;

    tracknum=1;
    wattrset(tStatusWin,COLOR_PAIR(5)|A_REVERSE|A_BOLD);
    wmove(tStatusWin,0,9);
    top=fHead;
    while(top!=current1){tracknum++;top=top->fLink;}
    tnum1=tracknum;
    wprintw(tStatusWin,"%5i: %s",tnum1,mp3Path1);
    wclrtoeol(tStatusWin);

    tracknum=1;
    wattrset(tStatusWin,COLOR_PAIR(6)|A_REVERSE|A_BOLD);
    wmove(tStatusWin,1,9);
    top=fHead;
    while(top!=current2){tracknum++;top=top->fLink;}
    tnum2=tracknum;
    wprintw(tStatusWin,"%5i: %s",tnum2,mp3Path2);
    wclrtoeol(tStatusWin); 

    if(sim_play==TRUE)
    {
        if(active_channel==CHANNEL_1)tracknum=tnum1; else tracknum=tnum2;
        wattrset(tStatusWin,COLOR_PAIR(5)|A_REVERSE|A_BOLD);
        wmove(tStatusWin,0,9); wprintw(tStatusWin,"%4i: ",tracknum);
        wattrset(tStatusWin,COLOR_PAIR(6)|A_REVERSE|A_BOLD);
        wmove(tStatusWin,1,9); wprintw(tStatusWin,"%4i: ",tracknum);
    }
    wrefresh(tStatusWin);
    top=fHead;
    while(top!=bHead){totaltracks++; top=top->fLink;}

} /*display_track_path*/

void display_track_status()
{
    chtype stop_color=(COLOR_PAIR(14)|A_BOLD),
           play_color=(COLOR_PAIR(3)|A_REVERSE|A_BOLD);
           char  *play_text="Playing#:", *stop_text="Stopped#:";

    if(ch1.on==0) track_status_text(stop_color,stop_text,0);
    else track_status_text(play_color,play_text,0);
    
    if(ch2.on==0) track_status_text(stop_color,stop_text,1);
    else track_status_text(play_color, play_text ,1);
} /* display_track_status */

void track_status_text(chtype tcolor, char *text, int posY)
{
    wattrset(tStatusWin,tcolor);
    mvwaddstr(tStatusWin,posY,0,text);
    wrefresh(tStatusWin);
} /*track_status_text */

void adjust_display(int key)
{
    int counter=0, index=0, j ,height,width;
    node *top, *current, *temp;
    char *tempstr;

    getmaxyx(subWin,height,width);

    if(active_channel==CHANNEL_1){top=ch1_Head; current=ch1_current;}
    else if(active_channel==CHANNEL_2){top=ch2_Head; current=ch2_current;}

    temp=top;
    while((temp!=current)&&(counter < height)){temp=temp->fLink; ++counter;}

    /* " NULL " is used in these routines in case you decide not to
         a circular linked list*/
    switch(key)
    {
     case SL_KEY_DOWN:
            if((counter >= height-1)&&(current->fLink!=NULL))
               {
                   top=top->fLink; current=current->fLink;
               }
            else  if(current->fLink!=NULL) current=current->fLink;
            break;

    case SL_KEY_UP:
            if((top->bLink!=NULL)&&(top==current))
            {
                top=top->bLink; current=current->bLink;
            }
            else
                if(current->bLink!=NULL) current=current->bLink ;
            break;

    case SL_KEY_NPAGE: /*pagedown*/
            while((index < height-1)&&(current->fLink!=NULL))
               {
                   top=top->fLink; current=current->fLink; index++;
               }   
            break;

    case SL_KEY_PPAGE:/*pageup*/
            while((index < height-1)&(top->bLink!=NULL))
               {
                   top=top->bLink; current=current->bLink; index++;
               }
            break;
    }

    if(active_channel==CHANNEL_1)
    {
        ch1_Head=top; ch1_current=current; 
    }
    else if(active_channel==CHANNEL_2)
    {
        ch2_Head=top; ch2_current=current; 
    }
} /*adjust_display */

void get_random_play_track()
{
    int index=0, tracktotal=0, height,width, randomtrack, y;
    long rndseed;
    float x;
    time_t nowsec;  /*time.h*/
    node *top, *current, *temp;
    
    
    temp=fHead;
    while(temp!=bHead){tracktotal++;temp=temp->fLink;}
    
    time(&nowsec);  /*get time*/
    rndseed=(long)(nowsec);
    srand(rndseed); /*generate non-psuedo seed*/

    x=tracktotal*1.0;
    y=rand();
    randomtrack=1+(int)(x*y/(RAND_MAX+1.0));
    
    top=fHead; current=fHead;
    getmaxyx(subWin,height,width);
    /* get random top of list */
    while((index < randomtrack)&&(current->fLink!=NULL))
    {
        top=top->fLink; current=current->fLink; index++;
    }
    getmaxyx(chWin,height,width);
    
    /* get random current track*/
    x=height*1.0;
    y=rand();
    randomtrack=1+(int)(x*y/(RAND_MAX+1.0));
    index=0;
    while((index < randomtrack-3)&&(current->fLink!=NULL))
    {
        current=current->fLink; index++;
    }
    ch_temp1=top;
    ch_temp2=current;
} /* get_random_play_track */


void display_listdata(void)
{
    char *fpath, *songname, *tempname;
    int index=0,j,height,width,tracknum=1, tracktotal=1, playcount,
        height1,width1;
    node *top, *current, *temp;

    
    if (active_channel==CHANNEL_1)
    {
        top=ch1_Head; current=ch1_current;
        
    }
    else if(active_channel==CHANNEL_2)
    {
        top=ch2_Head; current=ch2_current;
    }

    getmaxyx(chWin,height1,width1);

    /*get current track number and total tracks*/
    temp=fHead;
    while(temp!=current){tracknum++;temp=temp->fLink;}
    temp=fHead;
    while(temp!=bHead){tracktotal++;temp=temp->fLink;}
    
    /* display  current track number and total tracks */
    /*wmove(chWin,height1-1,width1-15);*/
    mvwprintw(chWin,height1-1,width1-15,"[%5i][%5i]",tracknum,tracktotal);

    touchwin(chWin);
    wrefresh(chWin);

    getmaxyx(subWin,height,width);
    wbkgd(subWin,COLOR_PAIR(9)|A_BOLD);
    
    while (top!=NULL)
    {
        fpath=top->filePath;
        playcount=top->playcount;
        /*get songname from path, the songname is assumed to be
         the characters after the last forward slash(/) */
        songname=strstr(strrchr(fpath,'/'),"/")+1;
        if(current==top)
            if(active_channel==CHANNEL_1)
            {
               wbkgdset(subWin,COLOR_PAIR(7)|A_BOLD);
               wattrset(subWin,COLOR_PAIR(7)|A_BOLD);
            }
            else if(active_channel==CHANNEL_2)
            {
               wbkgdset(subWin,COLOR_PAIR(8)|A_BOLD);
               wattrset(subWin,COLOR_PAIR(8)|A_BOLD);
            }

        tempname=strdup(songname);
        /*shorten song so that it fits in channel/display window*/
        mvwaddstr(subWin,index,0,tempname); wclrtoeol(subWin);
        mvwprintw(subWin,index,width-6,"*%5i",playcount);

        touchwin(subWin);
        wrefresh(subWin);
        
        wbkgdset(subWin,COLOR_PAIR(9)|A_BOLD);
        index++; if(index==height)return;
        top=top->fLink;
    }
} /*display_listdata */

void menu_action(char *item_name)
{
    if(strcmp(item_name, "Create Playlist")==0)enter_action();
    else if(strcmp(item_name, "Load Playlist")==0)enter_action();
    else if(strcmp(item_name, "Exit")==0)exit_prog();
    else if(strcmp(item_name, "Volume Control")==0)enter_action();
    else if(strcmp(item_name, "Mount Device")==0)enter_action();
    else if(strcmp(item_name, "UnMount Device")==0)enter_action();
    else if(strcmp(item_name, "Soundcard Config")==0)enter_action();
    else if(strcmp(item_name, "About")==0)enter_action();
    else if(strcmp(item_name, "Usage")==0)enter_action();
    else if(strcmp(item_name, "Credits")==0)enter_action();
}/*menu_action*/

void enter_action(void)
{
} /* enter_action*/

void exit_prog(void)
{
    reset_audio();
    sLang_exit();
    gui_exit();
}/*exit_prog*/

int get_code(void)
{
    int key;
    /*qiflush(); */
    /*if(clickcount>=15){flushinp(); clickcount=0;}*/
    if(SLang_input_pending(-10)) key= /*getch();  */
        SLkp_getkey(); 
    else  key=0;
    /*clickcount++;*/
    return(key);
}  /* get_code */
void refresh_windows(void)
{
    erase();refresh();
    display_ch_window(active_channel);
    display_listdata();
    display_player_status(sim_play,playmode);
    display_volume(ch1_volume_pos,ch2_volume_pos,active_bar);
    display_speed(ch1_speed_pos,ch2_speed_pos,active_bar);
    display_fader(fader_pos);
    display_track_path(active_channel,sim_play,ch1_last,ch2_last);
    display_track_status();
} /*refresh_windows*/



