static char rcsid[] = "@(#)$Id: newalias.c,v 1.11 2001/06/16 10:40:38 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *
 *****************************************************************************/

/** Install a new set of aliases for the 'Elm' mailer. 

	If invoked without the -g argument, it assumes that
  it is working with an individual users alias tables, and
  generates the .alias.pag and .alias.dir files in their
  .elm directory.
	If, however, it is invoked with the -g flag,
  it assumes that the user is updating the system alias
  file and uses the defaults for everything.

  The format for the input file is;
    alias1, alias2, ... = username = address
or  alias1, alias2, ... = groupname= member, member, member, ...
                                     member, member, member, ...

**/

#include "elmutil.h"
#include "s_newalias.h"

void error();

extern int  is_system;		/* system file updating?     */

int main(argc, argv)
     int argc;
     char *argv[];
{
	char inputname[SLEN], dataname[SLEN];
	int  a;

#if DEBUG
	init_debugfile("NEWALIAS");
#endif
	locale_init();
	user_init();
	init_defaults();
	read_rc_file();

	sleepmsg=0;		/* not in elm, dont wait for messages */

	for (a = 1; a < argc; ++a) {
	  if (strcmp(argv[a], "-g") == 0)
	    is_system = 1;
#ifdef DEBUG
	  else if (strcmp(argv[a], "-d") == 0) {	       
	    if (++a < argc)
	      set_debugging(argv[a]);	 
	  }
#endif
	  else {
	      lib_error(CATGETS(elm_msg_cat,
				NewaliasSet, NewaliasUsage, 
				"Usage: %s [-g]\n"), argv[0]);
	      exit(1);
	  }
	}


    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);

#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the NEWALIAS program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
#endif
    }
#endif

	if (is_system) {   /* update system aliases */
	    elm_fprintf(stdout,
			CATGETS(elm_msg_cat, NewaliasSet, NewaliasUpdateSystem,
				"Updating the system alias file..."));

	    strfcpy(inputname, system_text_file, sizeof inputname);
	    strfcpy(dataname,  system_data_file, sizeof dataname);
	}
	else {
	    elm_fprintf(stdout,
			CATGETS(elm_msg_cat, NewaliasSet, 
				NewaliasUpdatePersonal,
				"Updating your personal alias file..."));
	
	    strfcpy(inputname, user_text_file,sizeof inputname);
	    strfcpy(dataname, user_data_file,sizeof dataname);
	}

	if ((a = do_newalias(inputname, dataname, FALSE, TRUE)) < 0) {
	    exit(1);
	}
	else {
	     elm_fprintf(stdout,
			 CATGETS(elm_msg_cat, NewaliasSet, NewaliasProcessed,
				 "processed %d aliases.\n"), a);
	     exit(0);
	}

	/*NOTREACHED*/
}

void
error(err_message)
char *err_message;
{
	fflush(stdout);
	fprintf(stderr, "\n%s\n", err_message);
	return;
}
